/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.setup.update6to7.generic;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.opencms.setup.CmsSetupDBWrapper;
import org.opencms.setup.CmsSetupDb;
import org.opencms.setup.update6to7.A_CmsUpdateDBPart;

public class CmsUpdateDBContentTables
extends A_CmsUpdateDBPart {
    protected static final String QUERY_CREATE_CMS_CONTENTS_TABLE = "Q_CREATE_CMS_CONTENTS_TABLE";
    protected static final String QUERY_TRANSFER_ONLINE_CONTENTS = "Q_TRANSFER_ONLINE_CONTENTS";
    protected static final String TABLE_CMS_CONTENTS = "CMS_CONTENTS";
    private static final String QUERY_DROP_TABLE = "Q_DROP_TABLE";
    private static final String QUERY_PROPERTY_FILE = "generic/cms_content_table_queries.properties";
    private static final String QUERY_READ_MAX_PUBTAG = "Q_READ_MAX_PUBTAG";
    private static final String QUERY_TRANSFER_BACKUP_CONTENTS = "Q_TRANSFER_BACKUP_CONTENTS";
    private static final String REPLACEMENT_TABLENAME = "${tablename}";
    private static final String TABLE_CMS_BACKUP_CONTENTS = "CMS_BACKUP_CONTENTS";
    private static final String TABLE_CMS_ONLINE_CONTENTS = "CMS_ONLINE_CONTENTS";

    public CmsUpdateDBContentTables() throws IOException {
        this.loadQueryProperties("org/opencms/setup/update6to7/generic/cms_content_table_queries.properties");
    }

    protected void createContentsTable(CmsSetupDb dbCon) throws SQLException {
        System.out.println(new Exception().getStackTrace()[0].toString());
        if (!dbCon.hasTableOrColumn(TABLE_CMS_CONTENTS, null)) {
            String query = this.readQuery(QUERY_CREATE_CMS_CONTENTS_TABLE);
            dbCon.updateSqlStatement(query, null, null);
        } else {
            System.out.println("table CMS_CONTENTS already exists");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalExecute(CmsSetupDb dbCon) throws SQLException {
        System.out.println(new Exception().getStackTrace()[0].toString());
        this.createContentsTable(dbCon);
        if (dbCon.hasTableOrColumn(TABLE_CMS_ONLINE_CONTENTS, null)) {
            int pubTag = 1;
            String query = this.readQuery(QUERY_READ_MAX_PUBTAG);
            CmsSetupDBWrapper db = null;
            try {
                db = dbCon.executeSqlStatement(query, null);
                if (db.getResultSet().next()) {
                    pubTag = db.getResultSet().getInt(1);
                }
            }
            finally {
                if (db != null) {
                    db.close();
                }
            }
            this.transferOnlineContents(dbCon, pubTag);
        } else {
            System.out.println("no table CMS_ONLINE_CONTENTS found");
        }
        if (this.isKeepHistory()) {
            if (dbCon.hasTableOrColumn(TABLE_CMS_BACKUP_CONTENTS, null)) {
                String query = this.readQuery(QUERY_TRANSFER_BACKUP_CONTENTS);
                dbCon.updateSqlStatement(query, null, null);
            } else {
                System.out.println("no table CMS_BACKUP_CONTENTS found");
            }
        }
        this.cleanUpContentsTables(dbCon);
    }

    protected void transferOnlineContents(CmsSetupDb dbCon, int pubTag) throws SQLException {
        String query = this.readQuery(QUERY_TRANSFER_ONLINE_CONTENTS);
        Map<String, String> replacer = Collections.singletonMap("${pubTag}", "" + pubTag);
        dbCon.updateSqlStatement(query, replacer, null);
    }

    private void cleanUpContentsTables(CmsSetupDb dbCon) throws SQLException {
        System.out.println(new Exception().getStackTrace()[0].toString());
        String query = this.readQuery(QUERY_DROP_TABLE);
        HashMap<String, String> replacers = new HashMap<String, String>();
        replacers.put(REPLACEMENT_TABLENAME, TABLE_CMS_ONLINE_CONTENTS);
        dbCon.updateSqlStatement(query, replacers, null);
        replacers.clear();
        replacers.put(REPLACEMENT_TABLENAME, TABLE_CMS_BACKUP_CONTENTS);
        dbCon.updateSqlStatement(query, replacers, null);
    }
}

