/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.setup.update6to7.generic;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.opencms.setup.CmsSetupDBWrapper;
import org.opencms.setup.CmsSetupDb;
import org.opencms.setup.update6to7.A_CmsUpdateDBPart;

public class CmsUpdateDBCreateIndexes7
extends A_CmsUpdateDBPart {
    protected static final String QUERY_SHOW_INDEX = "QUERY_SHOW_INDEX";
    protected static final String REPLACEMENT_TABLENAME = "${tablename}";
    private static final String FIELD_INDEX = "KEY_NAME";
    private static final String PRIMARY_KEY = "PRIMARY";
    private static final String QUERY_PROPERTY_FILE = "generic/cms_add_new_indexes_queries.properties";
    private static final String REPLACEMENT_INDEXES = "${dropindexes}";

    public CmsUpdateDBCreateIndexes7() throws IOException {
        this.loadQueryProperties("org/opencms/setup/update6to7/generic/cms_add_new_indexes_queries.properties");
    }

    protected void internalExecute(CmsSetupDb dbCon) {
        System.out.println(new Exception().getStackTrace()[0].toString());
        ArrayList<String> elements = new ArrayList<String>();
        elements.add("CMS_CONTENTS");
        elements.add("CMS_GROUPS");
        elements.add("CMS_GROUPUSERS");
        elements.add("CMS_OFFLINE_ACCESSCONTROL");
        elements.add("CMS_OFFLINE_CONTENTS");
        elements.add("CMS_OFFLINE_PROPERTIES");
        elements.add("CMS_OFFLINE_PROPERTYDEF");
        elements.add("CMS_OFFLINE_RESOURCES");
        elements.add("CMS_OFFLINE_STRUCTURE");
        elements.add("CMS_ONLINE_ACCESSCONTROL");
        elements.add("CMS_ONLINE_PROPERTIES");
        elements.add("CMS_ONLINE_PROPERTYDEF");
        elements.add("CMS_ONLINE_RESOURCES");
        elements.add("CMS_ONLINE_STRUCTURE");
        elements.add("CMS_PROJECTRESOURCES");
        elements.add("CMS_PROJECTS");
        elements.add("CMS_PUBLISH_HISTORY");
        elements.add("CMS_STATICEXPORT_LINKS");
        elements.add("CMS_USERS");
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            String query = (String)it.next();
            if (dbCon.hasTableOrColumn(query, null)) {
                HashMap<String, String> replacer = new HashMap<String, String>();
                replacer.put(REPLACEMENT_INDEXES, this.getIndexesToDrop(dbCon, query));
                try {
                    dbCon.updateSqlStatement(this.readQuery(query), replacer, null);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                continue;
            }
            System.out.println("Table " + query + "does not exist.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getIndexesToDrop(CmsSetupDb dbCon, String tablename) {
        ArrayList<String> indexes = new ArrayList<String>();
        String tableIndex = this.readQuery(QUERY_SHOW_INDEX);
        HashMap<String, String> replacer = new HashMap<String, String>();
        replacer.put(REPLACEMENT_TABLENAME, tablename);
        CmsSetupDBWrapper db = null;
        try {
            db = dbCon.executeSqlStatement(tableIndex, replacer);
            while (db.getResultSet().next()) {
                String index = db.getResultSet().getString(FIELD_INDEX);
                if (indexes.contains(index)) continue;
                indexes.add(index);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
        StringBuffer dropIndex = new StringBuffer();
        Iterator it = indexes.iterator();
        while (it.hasNext()) {
            String index = (String)it.next();
            if (index.equals(PRIMARY_KEY)) {
                dropIndex.append("DROP PRIMARY KEY, ");
                continue;
            }
            dropIndex.append("DROP INDEX ");
            dropIndex.append(index);
            dropIndex.append(", ");
        }
        return dropIndex.toString();
    }
}

