/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.setup.update6to7.generic;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.opencms.setup.CmsSetupDBWrapper;
import org.opencms.setup.CmsSetupDb;
import org.opencms.setup.update6to7.A_CmsUpdateDBPart;
import org.opencms.util.CmsStringUtil;

public class CmsUpdateDBDropOldIndexes
extends A_CmsUpdateDBPart {
    protected static final String[] CMS_TABLES = new String[]{"CMS_BACKUP_CONTENTS", "CMS_BACKUP_PROJECTRESOURCES", "CMS_BACKUP_PROJECTS", "CMS_BACKUP_PROPERTIES", "CMS_BACKUP_PROPERTYDEF", "CMS_BACKUP_RESOURCES", "CMS_BACKUP_STRUCTURE", "CMS_GROUPS", "CMS_GROUPUSERS", "CMS_OFFLINE_ACCESSCONTROL", "CMS_OFFLINE_CONTENTS", "CMS_OFFLINE_PROPERTIES", "CMS_OFFLINE_PROPERTYDEF", "CMS_OFFLINE_RESOURCES", "CMS_OFFLINE_STRUCTURE", "CMS_ONLINE_ACCESSCONTROL", "CMS_ONLINE_CONTENTS", "CMS_ONLINE_PROPERTIES", "CMS_ONLINE_PROPERTYDEF", "CMS_ONLINE_RESOURCES", "CMS_ONLINE_STRUCTURE", "CMS_PROJECTRESOURCES", "CMS_PROJECTS", "CMS_PUBLISH_HISTORY", "CMS_STATICEXPORT_LINKS", "CMS_SYSTEMID", "CMS_TASK", "CMS_TASKLOG", "CMS_TASKPAR", "CMS_TASKTYPE", "CMS_USERS"};
    protected static final List CMS_TABLES_LIST = Collections.unmodifiableList(Arrays.asList(CMS_TABLES));
    protected static final String QUERY_DROP_INDEX = "Q_DROP_INDEX";
    protected static final String QUERY_SHOW_INDEX = "Q_SHOW_INDEXES";
    protected static final String REPLACEMENT_TABLENAME = "${tablename}";
    private static final String FIELD_INDEX = "KEY_NAME";
    private static final String PRIMARY_KEY = "PRIMARY";
    private static final String QUERY_PROPERTY_FILE = "generic/cms_drop_all_indexes_queries.properties";
    private static final String REPLACEMENT_INDEX = "${dropindexes}";

    public CmsUpdateDBDropOldIndexes() throws IOException {
        this.loadQueryProperties("org/opencms/setup/update6to7/generic/cms_drop_all_indexes_queries.properties");
    }

    protected void internalExecute(CmsSetupDb dbCon) {
        List tablenames = CMS_TABLES_LIST;
        Iterator tableIterator = tablenames.iterator();
        while (tableIterator.hasNext()) {
            String tablename = (String)tableIterator.next();
            System.out.println("dropping indexes for table " + tablename);
            if (!dbCon.hasTableOrColumn(tablename, null)) continue;
            try {
                List indexes = this.getIndexes(dbCon, tablename);
                StringBuffer buffer = new StringBuffer();
                Iterator indexIt = indexes.iterator();
                while (indexIt.hasNext()) {
                    String index = (String)indexIt.next();
                    if (index.equalsIgnoreCase(PRIMARY_KEY)) {
                        buffer.append("DROP PRIMARY KEY");
                        if (!indexIt.hasNext()) continue;
                        buffer.append(",");
                        continue;
                    }
                    buffer.append(" DROP INDEX ");
                    buffer.append(index);
                    if (!indexIt.hasNext()) continue;
                    buffer.append(",");
                }
                String tempIndex = this.readQuery(tablename);
                if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)tempIndex)) {
                    buffer.append(", ");
                    buffer.append(tempIndex);
                }
                if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)buffer.toString())) continue;
                String dropIndexQuery = this.readQuery(QUERY_DROP_INDEX);
                HashMap<String, String> replacer = new HashMap<String, String>();
                replacer.put(REPLACEMENT_TABLENAME, tablename);
                replacer.put(REPLACEMENT_INDEX, buffer.toString());
                try {
                    dbCon.updateSqlStatement(dropIndexQuery, replacer, null);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getIndexes(CmsSetupDb dbCon, String tablename) throws SQLException {
        ArrayList<String> indexes = new ArrayList<String>();
        String tableIndex = this.readQuery(QUERY_SHOW_INDEX);
        HashMap<String, String> replacer = new HashMap<String, String>();
        replacer.put(REPLACEMENT_TABLENAME, tablename);
        CmsSetupDBWrapper db = null;
        try {
            db = dbCon.executeSqlStatement(tableIndex, replacer);
            while (db.getResultSet().next()) {
                String index = db.getResultSet().getString(FIELD_INDEX);
                if (indexes.contains(index)) continue;
                indexes.add(index);
            }
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
        return indexes;
    }
}

