/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.setup.update6to7.generic;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import org.opencms.setup.CmsSetupDBWrapper;
import org.opencms.setup.CmsSetupDb;
import org.opencms.setup.update6to7.A_CmsUpdateDBPart;

public class CmsUpdateDBHistoryPrincipals
extends A_CmsUpdateDBPart {
    protected static final String QUERY_HISTORY_PRINCIPALS_CREATE_TABLE = "Q_HISTORY_PRINCIPALS_CREATE_TABLE";
    protected static final String TABLE_CMS_HISTORY_PRINCIPALS = "CMS_HISTORY_PRINCIPALS";
    private static final String QUERY_HISTORY_PRINCIPALS_PROJECTS_GROUPS = "Q_HISTORY_PRINCIPALS_PROJECTS_GROUPS";
    private static final String QUERY_HISTORY_PRINCIPALS_PROJECTS_MANAGERGROUPS = "Q_HISTORY_PRINCIPALS_PROJECTS_MANAGERGROUPS";
    private static final String QUERY_HISTORY_PRINCIPALS_PROJECTS_PUBLISHED = "Q_HISTORY_PRINCIPALS_PROJECTS_PUBLISHED";
    private static final String QUERY_HISTORY_PRINCIPALS_PROJECTS_USERS = "Q_HISTORY_PRINCIPALS_PROJECTS_USERS";
    private static final String QUERY_HISTORY_PRINCIPALS_RESOURCES = "Q_HISTORY_PRINCIPALS_RESOURCES";
    private static final String QUERY_PROPERTY_FILE = "generic/cms_history_principals_queries.properties";
    private static final String QUERY_SELECT_COUNT_HISTORY_PRINCIPALS = "Q_SELECT_COUNT_HISTORY_PRINICPALS";
    private static final String QUERY_UPDATE_DATEDELETED = "Q_UPDATE_DATEDELETED";

    public CmsUpdateDBHistoryPrincipals() throws IOException {
        this.loadQueryProperties("org/opencms/setup/update6to7/generic/cms_history_principals_queries.properties");
    }

    protected void createHistPrincipalsTable(CmsSetupDb dbCon) throws SQLException {
        System.out.println(new Exception().getStackTrace()[0].toString());
        if (!dbCon.hasTableOrColumn(TABLE_CMS_HISTORY_PRINCIPALS, null)) {
            String createStatement = this.readQuery(QUERY_HISTORY_PRINCIPALS_CREATE_TABLE);
            dbCon.updateSqlStatement(createStatement, null, null);
        } else {
            System.out.println("table CMS_HISTORY_PRINCIPALS already exists");
        }
    }

    protected void internalExecute(CmsSetupDb dbCon) throws SQLException {
        System.out.println(new Exception().getStackTrace()[0].toString());
        if (this.insertHistoryPrincipals(dbCon)) {
            ArrayList<Long> params = new ArrayList<Long>();
            params.add(new Long(System.currentTimeMillis()));
            dbCon.updateSqlStatement(this.readQuery(QUERY_UPDATE_DATEDELETED), null, params);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasData(CmsSetupDb dbCon) throws SQLException {
        System.out.println(new Exception().getStackTrace()[0].toString());
        boolean result = false;
        String query = this.readQuery(QUERY_SELECT_COUNT_HISTORY_PRINCIPALS);
        CmsSetupDBWrapper db = null;
        try {
            db = dbCon.executeSqlStatement(query, null);
            if (db.getResultSet().next() && db.getResultSet().getInt("COUNT") > 0) {
                result = true;
            }
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
        return result;
    }

    private boolean insertHistoryPrincipals(CmsSetupDb dbCon) throws SQLException {
        System.out.println(new Exception().getStackTrace()[0].toString());
        this.createHistPrincipalsTable(dbCon);
        boolean updateUserDateDeleted = false;
        if (this.isKeepHistory() && !this.hasData(dbCon)) {
            dbCon.updateSqlStatement(this.readQuery(QUERY_HISTORY_PRINCIPALS_RESOURCES), null, null);
            dbCon.updateSqlStatement(this.readQuery(QUERY_HISTORY_PRINCIPALS_PROJECTS_GROUPS), null, null);
            dbCon.updateSqlStatement(this.readQuery(QUERY_HISTORY_PRINCIPALS_PROJECTS_MANAGERGROUPS), null, null);
            dbCon.updateSqlStatement(this.readQuery(QUERY_HISTORY_PRINCIPALS_PROJECTS_PUBLISHED), null, null);
            dbCon.updateSqlStatement(this.readQuery(QUERY_HISTORY_PRINCIPALS_PROJECTS_USERS), null, null);
            updateUserDateDeleted = true;
        }
        return updateUserDateDeleted;
    }
}

