/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.setup.update6to7.generic;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.opencms.setup.CmsSetupDBWrapper;
import org.opencms.setup.CmsSetupDb;
import org.opencms.setup.update6to7.A_CmsUpdateDBPart;

public class CmsUpdateDBHistoryTables
extends A_CmsUpdateDBPart {
    private static final String QUERY_PROPERTY_FILE = "generic/cms_history_queries.properties";
    private static final String QUERY_SELECT_COUNT_HISTORY_TABLE = "Q_SELECT_COUNT_HISTORY_TABLE";
    private static final String REPLACEMENT_TABLENAME = "${tablename}";

    public CmsUpdateDBHistoryTables() throws IOException {
        this.loadQueryProperties("org/opencms/setup/update6to7/generic/cms_history_queries.properties");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalExecute(CmsSetupDb dbCon) throws SQLException {
        System.out.println(new Exception().getStackTrace()[0].toString());
        ArrayList<String> elements = new ArrayList<String>();
        elements.add("CMS_HISTORY_PROPERTYDEF");
        if (this.isKeepHistory()) {
            elements.add("CMS_HISTORY_PROJECTRESOURCES");
            elements.add("CMS_HISTORY_PROPERTIES");
            elements.add("CMS_HISTORY_RESOURCES");
            elements.add("CMS_HISTORY_STRUCTURE");
        }
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            String table = (String)it.next();
            System.out.println("Updating table " + table);
            if (dbCon.hasTableOrColumn(table, null)) {
                HashMap<String, String> replacer = new HashMap<String, String>();
                replacer.put(REPLACEMENT_TABLENAME, table);
                CmsSetupDBWrapper db = null;
                boolean update = false;
                try {
                    db = dbCon.executeSqlStatement(this.readQuery(QUERY_SELECT_COUNT_HISTORY_TABLE), replacer);
                    if (db.getResultSet().next() && db.getResultSet().getInt("COUNT") <= 0) {
                        update = true;
                    }
                }
                finally {
                    if (db != null) {
                        db.close();
                    }
                }
                if (update) {
                    String query = this.readQuery(table);
                    dbCon.updateSqlStatement(query, null, null);
                    continue;
                }
                System.out.println("table " + table + " already has data");
                continue;
            }
            System.out.println("table " + table + " does not exists");
        }
    }
}

