/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.setup.update6to7.generic;

import java.io.IOException;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opencms.file.CmsProject;
import org.opencms.setup.CmsSetupDBWrapper;
import org.opencms.setup.CmsSetupDb;
import org.opencms.setup.update6to7.A_CmsUpdateDBPart;
import org.opencms.util.CmsUUID;

public class CmsUpdateDBProjectId
extends A_CmsUpdateDBPart {
    protected static final String COLUMN_PROJECT_ID = "PROJECT_ID";
    protected static final String COLUMN_PROJECT_LASTMODIFIED = "PROJECT_LASTMODIFIED";
    protected static final String COLUMN_PROJECT_UUID = "PROJECT_UUID";
    protected static final String COLUMN_TEMP_PROJECT_UUID = "TEMP_PROJECT_UUID";
    protected static final String HISTORY_PROJECTS_TABLE = "CMS_HISTORY_PROJECTS";
    protected static final String QUERY_ADD_PRIMARY_KEY = "Q_ADD_PRIMARY_KEY";
    protected static final String QUERY_ADD_TEMP_UUID_COLUMN = "Q_ADD_COLUMN";
    protected static final String QUERY_CREATE_HISTORY_PROJECTS_TABLE = "Q_CREATE_HISTORY_PROJECTS_TABLE";
    protected static final String QUERY_CREATE_TEMP_TABLE_UUIDS = "Q_CREATE_TEMPORARY_TABLE_UUIDS";
    protected static final String QUERY_DESCRIBE_TABLE = "Q_DESCRIBE_TABLE";
    protected static final String QUERY_READ_MAX_PUBTAG = "Q_READ_MAX_PUBTAG";
    protected static final String REPLACEMENT_COLUMN = "${column}";
    protected static final String REPLACEMENT_NEW_COLUMN = "${newcolumn}";
    protected static final String REPLACEMENT_OLDID = "${oldid}";
    protected static final String REPLACEMENT_PRIMARY_KEY = "${primarykeycolumn}";
    protected static final String REPLACEMENT_TABLENAME = "${tablename}";
    protected static final String[] RESOURCE_TABLES = new String[]{"CMS_OFFLINE_RESOURCES", "CMS_ONLINE_RESOURCES"};
    protected static final List RESOURCES_TABLES_LIST = Collections.unmodifiableList(Arrays.asList(RESOURCE_TABLES));
    protected static final String[] TABLES = new String[]{"CMS_OFFLINE_RESOURCES", "CMS_ONLINE_RESOURCES", "CMS_PROJECTRESOURCES", "CMS_PROJECTS"};
    protected static final List TABLES_LIST = Collections.unmodifiableList(Arrays.asList(TABLES));
    protected static final String TEMP_UUID_COLUMN = "TEMP_PROJECT_UUID";
    protected static final String TEMPORARY_TABLE_NAME = "TEMP_PROJECT_UUIDS";
    private static final String COLUMN_PROJECT_ID_RESOURCE_PATH = "PROJECT_ID,RESOURCE_PATH(255)";
    private static final String QUERY_DROP_COLUMN = "Q_DROP_COLUMN";
    private static final String QUERY_GET_PROJECT_IDS = "Q_SELECT_PROJECT_IDS";
    private static final String QUERY_GET_UUIDS = "Q_SELECT_UUIDS";
    private static final String QUERY_INSERT_CMS_HISTORY_TABLE = "Q_INSERT_CMS_HISTORY_TABLE";
    private static final String QUERY_INSERT_UUIDS = "Q_INSERT_UUIDS_TEMP_TABLE";
    private static final String QUERY_PROPERTY_FILE = "generic/cms_projectid_queries.properties";
    private static final String QUERY_READ_ADMIN_GROUP = "Q_READ_ADMIN_GROUP";
    private static final String QUERY_READ_ADMIN_USER = "Q_READ_ADMIN_USER";
    private static final String QUERY_RENAME_COLUMN = "Q_RENAME_COLUMN";
    private static final String QUERY_SELECT_COUNT_HISTORY_TABLE = "Q_SELECT_COUNT_HISTORY_TABLE";
    private static final String QUERY_SELECT_DATA_FROM_BACKUP_PROJECTS = "Q_SELECT_DATA_FROM_BACKUP_PROJECTS";
    private static final String QUERY_TRANSFER_UUID = "Q_TRANSFER_UUID";
    private static final String QUERY_UPDATE_NULL_PROJECTID = "Q_UPDATE_NULL_PROJECTID";

    public CmsUpdateDBProjectId() throws IOException {
        this.loadQueryProperties("org/opencms/setup/update6to7/generic/cms_projectid_queries.properties");
    }

    protected void addPrimaryKey(CmsSetupDb dbCon, String tablename, String primaryKey) throws SQLException {
        System.out.println(new Exception().getStackTrace()[0].toString());
        if (dbCon.hasTableOrColumn(tablename, null)) {
            String query = this.readQuery(QUERY_ADD_PRIMARY_KEY);
            HashMap<String, String> replacer = new HashMap<String, String>();
            replacer.put(REPLACEMENT_TABLENAME, tablename);
            replacer.put(REPLACEMENT_PRIMARY_KEY, primaryKey);
            dbCon.updateSqlStatement(query, replacer, null);
        } else {
            System.out.println("table " + tablename + " does not exists");
        }
    }

    protected void addUUIDColumnToTable(CmsSetupDb dbCon, String tablename, String column) throws SQLException {
        System.out.println(new Exception().getStackTrace()[0].toString());
        if (!dbCon.hasTableOrColumn(tablename, column)) {
            String query = this.readQuery(QUERY_ADD_TEMP_UUID_COLUMN);
            if (!RESOURCES_TABLES_LIST.contains(tablename)) {
                query = query + " FIRST";
            }
            HashMap<String, String> replacer = new HashMap<String, String>();
            replacer.put(REPLACEMENT_TABLENAME, tablename);
            replacer.put(REPLACEMENT_COLUMN, column);
            dbCon.updateSqlStatement(query, replacer, null);
        } else {
            System.out.println("column " + column + " in table " + tablename + " already exists");
        }
    }

    protected boolean checkColumnTypeProjectId(int type) {
        return type == 4;
    }

    protected void createHistProjectsTable(CmsSetupDb dbCon) throws SQLException {
        System.out.println(new Exception().getStackTrace()[0].toString());
        if (!dbCon.hasTableOrColumn(HISTORY_PROJECTS_TABLE, null)) {
            String createStatement = this.readQuery(QUERY_CREATE_HISTORY_PROJECTS_TABLE);
            dbCon.updateSqlStatement(createStatement, null, null);
            this.transferDataToHistoryTable(dbCon);
        } else {
            System.out.println("table CMS_HISTORY_PROJECTS already exists");
        }
    }

    protected void createTempTable(CmsSetupDb dbCon) throws SQLException {
        System.out.println(new Exception().getStackTrace()[0].toString());
        if (!dbCon.hasTableOrColumn(TEMPORARY_TABLE_NAME, null)) {
            String createStatement = this.readQuery(QUERY_CREATE_TEMP_TABLE_UUIDS);
            dbCon.updateSqlStatement(createStatement, null, null);
        } else {
            System.out.println("table TEMP_PROJECT_UUIDS already exists");
        }
    }

    protected String getColumnProjectIdResourcePath() {
        return COLUMN_PROJECT_ID_RESOURCE_PATH;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalExecute(CmsSetupDb dbCon) throws SQLException {
        System.out.println(new Exception().getStackTrace()[0].toString());
        this.generateUUIDs(dbCon);
        this.createHistProjectsTable(dbCon);
        Map uuids = this.getUUIDs(dbCon);
        Iterator it = TABLES_LIST.iterator();
        while (it.hasNext()) {
            String tablename = (String)it.next();
            if (this.needsUpdating(dbCon, tablename)) {
                this.addUUIDColumnToTable(dbCon, tablename, "TEMP_PROJECT_UUID");
                boolean isInResourcesList = RESOURCES_TABLES_LIST.contains(tablename);
                Iterator entries = uuids.entrySet().iterator();
                while (entries.hasNext()) {
                    Map.Entry entry = entries.next();
                    if (entry.getKey() == null || entry.getValue() == null) continue;
                    if (isInResourcesList) {
                        this.fillUUIDSColumn(dbCon, tablename, "TEMP_PROJECT_UUID", (String)entry.getValue(), COLUMN_PROJECT_LASTMODIFIED, (String)entry.getKey());
                        continue;
                    }
                    this.fillUUIDSColumn(dbCon, tablename, "TEMP_PROJECT_UUID", (String)entry.getValue(), COLUMN_PROJECT_ID, (String)entry.getKey());
                }
                if (isInResourcesList) {
                    Map<String, String> replacer = Collections.singletonMap(REPLACEMENT_TABLENAME, tablename);
                    List<String> params = Collections.singletonList(CmsUUID.getNullUUID().toString());
                    String query = this.readQuery(QUERY_UPDATE_NULL_PROJECTID);
                    dbCon.updateSqlStatement(query, replacer, params);
                    this.dropColumn(dbCon, tablename, COLUMN_PROJECT_LASTMODIFIED);
                    this.renameColumn(dbCon, tablename, "TEMP_PROJECT_UUID", COLUMN_PROJECT_LASTMODIFIED);
                    continue;
                }
                this.dropColumn(dbCon, tablename, COLUMN_PROJECT_ID);
                this.renameColumn(dbCon, tablename, "TEMP_PROJECT_UUID", COLUMN_PROJECT_ID);
                if (tablename.equals("CMS_PROJECTRESOURCES")) {
                    this.addPrimaryKey(dbCon, tablename, this.getColumnProjectIdResourcePath());
                }
                if (!tablename.equals("CMS_PROJECTS")) continue;
                this.addPrimaryKey(dbCon, tablename, COLUMN_PROJECT_ID);
                continue;
            }
            System.out.println("table " + tablename + " does not need to be updated");
        }
        CmsSetupDBWrapper db = null;
        boolean update = false;
        try {
            db = dbCon.executeSqlStatement(this.readQuery(QUERY_SELECT_COUNT_HISTORY_TABLE), null);
            if (db.getResultSet().next() && db.getResultSet().getInt("COUNT") <= 0) {
                update = true;
            }
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
        if (update) {
            System.out.println("table CMS_HISTORY_PROJECTS has no content, create a dummy entry");
            CmsUUID userId = CmsUUID.getNullUUID();
            try {
                db = dbCon.executeSqlStatement(this.readQuery(QUERY_READ_ADMIN_USER), null);
                if (db.getResultSet().next()) {
                    userId = new CmsUUID(db.getResultSet().getString(1));
                }
            }
            finally {
                if (db != null) {
                    db.close();
                }
            }
            CmsUUID groupId = CmsUUID.getNullUUID();
            try {
                db = dbCon.executeSqlStatement(this.readQuery(QUERY_READ_ADMIN_GROUP), null);
                if (db.getResultSet().next()) {
                    groupId = new CmsUUID(db.getResultSet().getString(1));
                }
            }
            finally {
                if (db != null) {
                    db.close();
                }
            }
            int pubTag = 1;
            String query = this.readQuery(QUERY_READ_MAX_PUBTAG);
            try {
                db = dbCon.executeSqlStatement(query, null);
                if (db.getResultSet().next()) {
                    pubTag = db.getResultSet().getInt(1);
                }
            }
            finally {
                if (db != null) {
                    db.close();
                }
            }
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(new CmsUUID().toString());
            params.add("updateWizardDummyProject");
            params.add("dummy project just for having an entry");
            params.add(new Integer(1));
            params.add(userId.toString());
            params.add(groupId.toString());
            params.add(groupId.toString());
            params.add(new Long(System.currentTimeMillis()));
            params.add(new Integer(pubTag));
            params.add(new Long(System.currentTimeMillis()));
            params.add(userId.toString());
            params.add("/");
            query = this.readQuery(QUERY_INSERT_CMS_HISTORY_TABLE);
            dbCon.updateSqlStatement(query, null, params);
        } else {
            System.out.println("table CMS_HISTORY_PROJECTS has content");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean needsUpdating(CmsSetupDb dbCon, String tablename) throws SQLException {
        System.out.println(new Exception().getStackTrace()[0].toString());
        boolean result = true;
        String query = this.readQuery(QUERY_DESCRIBE_TABLE);
        HashMap<String, String> replacer = new HashMap<String, String>();
        replacer.put(REPLACEMENT_TABLENAME, tablename);
        CmsSetupDBWrapper db = null;
        try {
            db = dbCon.executeSqlStatement(query, replacer);
            while (db.getResultSet().next()) {
                String fieldname = db.getResultSet().getString("Field");
                if (!fieldname.equals(COLUMN_PROJECT_ID) && !fieldname.equals(COLUMN_PROJECT_LASTMODIFIED)) continue;
                try {
                    String fieldtype = db.getResultSet().getString("Type");
                    if (fieldtype.indexOf("varchar") <= 0) continue;
                    boolean bl = false;
                    return bl;
                }
                catch (SQLException e) {
                    result = true;
                }
            }
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void transferDataToHistoryTable(CmsSetupDb dbCon) throws SQLException {
        if (!this.isKeepHistory()) {
            return;
        }
        System.out.println(new Exception().getStackTrace()[0].toString());
        String query = this.readQuery(QUERY_SELECT_DATA_FROM_BACKUP_PROJECTS);
        CmsSetupDBWrapper db = null;
        try {
            db = dbCon.executeSqlStatement(query, null);
            String insertQuery = this.readQuery(QUERY_INSERT_CMS_HISTORY_TABLE);
            while (db.getResultSet().next()) {
                ArrayList<Object> params = new ArrayList<Object>();
                params.add(db.getResultSet().getString(COLUMN_PROJECT_UUID));
                params.add(db.getResultSet().getString("PROJECT_NAME"));
                params.add(db.getResultSet().getString("PROJECT_DESCRIPTION"));
                params.add(new Integer(db.getResultSet().getInt("PROJECT_TYPE")));
                params.add(db.getResultSet().getString("USER_ID"));
                params.add(db.getResultSet().getString("GROUP_ID"));
                params.add(db.getResultSet().getString("MANAGERGROUP_ID"));
                params.add(new Long(db.getResultSet().getLong("DATE_CREATED")));
                params.add(new Integer(db.getResultSet().getInt("PUBLISH_TAG")));
                Date date = db.getResultSet().getDate("PROJECT_PUBLISHDATE");
                params.add(new Long(date.getTime()));
                params.add(db.getResultSet().getString("PROJECT_PUBLISHED_BY"));
                params.add(db.getResultSet().getString("PROJECT_OU"));
                dbCon.updateSqlStatement(insertQuery, null, params);
            }
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
    }

    private void dropColumn(CmsSetupDb dbCon, String tablename, String column) throws SQLException {
        System.out.println(new Exception().getStackTrace()[0].toString());
        if (dbCon.hasTableOrColumn(tablename, column)) {
            String query = this.readQuery(QUERY_DROP_COLUMN);
            HashMap<String, String> replacer = new HashMap<String, String>();
            replacer.put(REPLACEMENT_TABLENAME, tablename);
            replacer.put(REPLACEMENT_COLUMN, column);
            dbCon.updateSqlStatement(query, replacer, null);
        } else {
            System.out.println("column " + column + " in table " + tablename + " does not exist");
        }
    }

    private void fillUUIDSColumn(CmsSetupDb dbCon, String tablename, String column, String newvalue, String oldid, String tempValue) throws SQLException {
        System.out.println(new Exception().getStackTrace()[0].toString());
        if (dbCon.hasTableOrColumn(tablename, column)) {
            String query = this.readQuery(QUERY_TRANSFER_UUID);
            HashMap<String, String> replacer = new HashMap<String, String>();
            replacer.put(REPLACEMENT_TABLENAME, tablename);
            replacer.put(REPLACEMENT_COLUMN, column);
            replacer.put(REPLACEMENT_OLDID, oldid);
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(newvalue);
            params.add(new Integer(tempValue));
            dbCon.updateSqlStatement(query, replacer, params);
        } else {
            System.out.println("column " + column + " in table " + tablename + " does not exists");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateUUIDs(CmsSetupDb dbCon) throws SQLException {
        System.out.println(new Exception().getStackTrace()[0].toString());
        String query = this.readQuery(QUERY_GET_PROJECT_IDS);
        CmsSetupDBWrapper db = null;
        try {
            db = dbCon.executeSqlStatement(query, null);
            ResultSetMetaData metaData = db.getResultSet().getMetaData();
            int columnType = metaData.getColumnType(1);
            if (this.checkColumnTypeProjectId(columnType)) {
                if (!dbCon.hasTableOrColumn(TEMPORARY_TABLE_NAME, null)) {
                    this.createTempTable(dbCon);
                    String updateQuery = this.readQuery(QUERY_INSERT_UUIDS);
                    ArrayList<Object> params = new ArrayList<Object>();
                    boolean hasNullId = false;
                    while (db.getResultSet().next()) {
                        int id = db.getResultSet().getInt(COLUMN_PROJECT_ID);
                        params.add(new Integer(id));
                        CmsUUID uuid = new CmsUUID();
                        if (id == 0) {
                            hasNullId = true;
                            uuid = CmsUUID.getNullUUID();
                        }
                        if (id == 1) {
                            uuid = CmsProject.ONLINE_PROJECT_ID;
                        }
                        params.add(uuid.toString());
                        dbCon.updateSqlStatement(updateQuery, null, params);
                        params.clear();
                    }
                    if (!hasNullId) {
                        params.add(new Integer(0));
                        params.add(CmsUUID.getNullUUID().toString());
                        dbCon.updateSqlStatement(updateQuery, null, params);
                    }
                } else {
                    System.out.println("table TEMP_PROJECT_UUIDS already exists");
                }
            }
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getUUIDs(CmsSetupDb dbCon) throws SQLException {
        System.out.println(new Exception().getStackTrace()[0].toString());
        HashMap<String, String> result = new HashMap<String, String>();
        String query = this.readQuery(QUERY_GET_UUIDS);
        CmsSetupDBWrapper db = null;
        try {
            db = dbCon.executeSqlStatement(query, null);
            while (db.getResultSet().next()) {
                String key = Integer.toString(db.getResultSet().getInt(COLUMN_PROJECT_ID));
                String value = db.getResultSet().getString(COLUMN_PROJECT_UUID);
                result.put(key, value);
            }
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
        return result;
    }

    private void renameColumn(CmsSetupDb dbCon, String tablename, String oldname, String newname) throws SQLException {
        System.out.println(new Exception().getStackTrace()[0].toString());
        if (dbCon.hasTableOrColumn(tablename, oldname)) {
            String query = this.readQuery(QUERY_RENAME_COLUMN);
            HashMap<String, String> replacer = new HashMap<String, String>();
            replacer.put(REPLACEMENT_TABLENAME, tablename);
            replacer.put(REPLACEMENT_COLUMN, oldname);
            replacer.put(REPLACEMENT_NEW_COLUMN, newname);
            dbCon.updateSqlStatement(query, replacer, null);
        } else {
            System.out.println("column " + oldname + " in table " + tablename + " not found exists");
        }
    }
}

