/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.setup.update6to7.oracle;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.opencms.setup.CmsSetupDb;

public class CmsUpdateDBContentTables
extends org.opencms.setup.update6to7.generic.CmsUpdateDBContentTables {
    protected static final String QUERY_UPDATE_ONLINE_CONTENTS_PUBLISH_TAG_FROM = "Q_UPDATE_ONLINE_CONTENTS_PUBLISH_TAG_FROM";
    protected static final String QUERY_UPDATE_ONLINE_CONTENTS_PUBLISH_TAG_FROM2 = "Q_UPDATE_ONLINE_CONTENTS_PUBLISH_TAG_FROM2";
    protected static final String QUERY_UPDATE_ONLINE_CONTENTS_PUBLISH_TAG_TO = "Q_UPDATE_ONLINE_CONTENTS_PUBLISH_TAG_TO";
    private static final String QUERY_PROPERTY_FILE = "oracle/cms_content_table_queries.properties";
    private static final String REPLACEMENT_TABLEINDEX_SPACE = "${indexTablespace}";

    public CmsUpdateDBContentTables() throws IOException {
        this.loadQueryProperties("org/opencms/setup/update6to7/oracle/cms_content_table_queries.properties");
    }

    protected void createContentsTable(CmsSetupDb dbCon) throws SQLException {
        String indexTablespace = (String)this.m_poolData.get("indexTablespace");
        System.out.println(new Exception().getStackTrace()[0].toString());
        if (!dbCon.hasTableOrColumn("CMS_CONTENTS", null)) {
            String query = this.readQuery("Q_CREATE_CMS_CONTENTS_TABLE");
            HashMap<String, String> replacer = new HashMap<String, String>();
            replacer.put(REPLACEMENT_TABLEINDEX_SPACE, indexTablespace);
            dbCon.updateSqlStatement(query, null, null);
        } else {
            System.out.println("table CMS_CONTENTS already exists");
        }
    }

    protected void transferOnlineContents(CmsSetupDb dbCon, int pubTag) throws SQLException {
        String query = this.readQuery("Q_TRANSFER_ONLINE_CONTENTS");
        Map<String, String> replacer = Collections.singletonMap("${pubTag}", "" + pubTag);
        dbCon.updateSqlStatement(query, replacer, null);
        query = this.readQuery(QUERY_UPDATE_ONLINE_CONTENTS_PUBLISH_TAG_FROM);
        dbCon.updateSqlStatement(query, null, null);
        query = this.readQuery(QUERY_UPDATE_ONLINE_CONTENTS_PUBLISH_TAG_FROM2);
        dbCon.updateSqlStatement(query, null, Collections.singletonList(new Integer(pubTag)));
        query = this.readQuery(QUERY_UPDATE_ONLINE_CONTENTS_PUBLISH_TAG_TO);
        dbCon.updateSqlStatement(query, null, null);
    }
}

