/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.setup.xml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.main.CmsLog;
import org.opencms.setup.xml.Messages;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.CmsXmlUtils;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class CmsSetupXmlHelper {
    private static final EntityResolver NO_ENTITY_RESOLVER = new EntityResolver(){

        public InputSource resolveEntity(String publicId, String systemId) {
            return new InputSource(new StringReader(""));
        }
    };
    private String m_basePath = null;
    private Map m_cache = new HashMap();
    private static final Log LOG = CmsLog.getLog((Object)CmsSetupXmlHelper.class);

    public CmsSetupXmlHelper() {
    }

    public CmsSetupXmlHelper(String basePath) {
        this.m_basePath = basePath;
    }

    public static String format(String xml) throws CmsXmlException {
        return CmsXmlUtils.marshal((Node)CmsXmlUtils.unmarshalHelper((String)xml, null), (String)"UTF-8");
    }

    public static String getValue(Document document, String xPath) {
        Node node = document.selectSingleNode(xPath);
        if (node != null) {
            return node.getText();
        }
        return null;
    }

    public static int setValue(Document document, String xPath, String value) {
        int changes = 0;
        Iterator itNodes = document.selectNodes(xPath).iterator();
        if (!itNodes.hasNext()) {
            if (value == null) {
                return 0;
            }
            Iterator it = CmsStringUtil.splitAsList((String)xPath, (String)"/", (boolean)false).iterator();
            Document currentNode = document;
            while (it.hasNext()) {
                String nodeName = (String)it.next();
                while (nodeName.indexOf("='") > 0 && nodeName.indexOf("']") < 0) {
                    nodeName = nodeName + "/" + (String)it.next();
                }
                Node node = currentNode.selectSingleNode(nodeName);
                if (node != null) {
                    currentNode = node;
                    if (it.hasNext()) continue;
                    currentNode.setText(value);
                    continue;
                }
                if (currentNode.getNodeType() == 1) {
                    Element elem = (Element)currentNode;
                    if (!nodeName.startsWith("@")) {
                        String childName = null;
                        String childValue = "";
                        int pos = nodeName.indexOf("[");
                        if (pos > 0) {
                            int pos2 = nodeName.indexOf("='", pos);
                            if (pos2 > 0) {
                                childName = nodeName.substring(pos + 1, pos2);
                                childValue = nodeName.substring(pos2 + 2, nodeName.indexOf(39, pos2 + 2));
                            }
                            nodeName = nodeName.substring(0, pos);
                        }
                        elem = elem.addElement(nodeName);
                        if (childName != null) {
                            if (childName.startsWith("@")) {
                                elem.addAttribute(childName.substring(1), childValue);
                            } else {
                                Element child = elem.addElement(childName);
                                if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)childValue)) {
                                    child.addText(childValue);
                                }
                            }
                        }
                        if (!it.hasNext()) {
                            elem.setText(value);
                        }
                    } else {
                        elem.addAttribute(nodeName.substring(1), value);
                    }
                    currentNode = elem;
                    continue;
                }
                if (!LOG.isDebugEnabled()) break;
                LOG.debug((Object)Messages.get().getBundle().key("ERR_XML_SET_VALUE_2", (Object)xPath, (Object)value));
                break;
            }
            return 1;
        }
        while (itNodes.hasNext()) {
            Node node = (Node)itNodes.next();
            if (value != null) {
                node.setText(value);
            } else {
                node.getParent().remove(node);
            }
            ++changes;
        }
        return changes;
    }

    public void flush(String xmlFilename) {
        this.m_cache.remove(xmlFilename);
    }

    public void flushAll() {
        this.m_cache.clear();
    }

    public String getBasePath() {
        return this.m_basePath;
    }

    public Document getDocument(String xmlFilename) throws CmsXmlException {
        Document document = (Document)this.m_cache.get(xmlFilename);
        if (document == null) {
            try {
                document = CmsXmlUtils.unmarshalHelper((InputSource)new InputSource(new FileReader(this.getFile(xmlFilename))), (EntityResolver)NO_ENTITY_RESOLVER);
            }
            catch (FileNotFoundException e) {
                throw new CmsXmlException(new CmsMessageContainer(null, e.toString()));
            }
            this.m_cache.put(xmlFilename, document);
        }
        return document;
    }

    public String getValue(String xmlFilename, String xPath) throws CmsXmlException {
        return CmsSetupXmlHelper.getValue(this.getDocument(xmlFilename), xPath);
    }

    public int setValue(String xmlFilename, String xPath, String value) throws CmsXmlException {
        return CmsSetupXmlHelper.setValue(this.getDocument(xmlFilename), xPath, value);
    }

    public void write(String xmlFilename) throws CmsXmlException {
        Document document = (Document)this.m_cache.get(xmlFilename);
        if (document != null) {
            try {
                FileOutputStream out = new FileOutputStream(this.getFile(xmlFilename));
                CmsXmlUtils.marshal((Document)document, (OutputStream)out, (String)"UTF-8");
            }
            catch (FileNotFoundException e) {
                throw new CmsXmlException(new CmsMessageContainer(null, e.toString()));
            }
        }
    }

    public void writeAll() throws CmsXmlException {
        Iterator it = new ArrayList(this.m_cache.keySet()).iterator();
        while (it.hasNext()) {
            String filename = (String)it.next();
            this.write(filename);
        }
    }

    private File getFile(String xmlFilename) {
        File file = new File(this.m_basePath + xmlFilename);
        if (!file.exists() || !file.canRead()) {
            file = new File(xmlFilename);
        }
        return file;
    }
}

