/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.setup.xml;

import java.util.Collections;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Node;
import org.opencms.loader.CmsImageLoader;
import org.opencms.setup.CmsSetupBean;
import org.opencms.setup.xml.A_CmsSetupXmlUpdate;
import org.opencms.setup.xml.CmsSetupXmlHelper;
import org.opencms.util.CmsStringUtil;

public class CmsXmlAddImageLoader
extends A_CmsSetupXmlUpdate {
    private List m_xpaths;

    public String getName() {
        return "Add new Image Loader";
    }

    public String getXmlFilename() {
        return "opencms-vfs.xml";
    }

    public boolean validate(CmsSetupBean setupBean) throws Exception {
        return CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)this.getCodeToChange(setupBean));
    }

    protected boolean executeUpdate(Document document, String xpath) {
        Node node = document.selectSingleNode(xpath);
        if (node == null) {
            if (xpath.equals(this.getXPathsToUpdate().get(0))) {
                CmsSetupXmlHelper.setValue(document, xpath + "/@" + "class", CmsImageLoader.class.getName());
                CmsSetupXmlHelper.setValue(document, xpath + "/" + "param", Boolean.TRUE.toString());
                CmsSetupXmlHelper.setValue(document, xpath + "/" + "param" + "/@" + "name", "image.scaling.enabled");
            }
            return true;
        }
        return false;
    }

    protected String getCommonPath() {
        return "/" + "opencms" + "/" + "vfs" + "/" + "resources" + "/" + "resourceloaders";
    }

    protected List getXPathsToUpdate() {
        if (this.m_xpaths == null) {
            StringBuffer xp = new StringBuffer(256);
            xp.append("/").append("opencms");
            xp.append("/").append("vfs");
            xp.append("/").append("resources");
            xp.append("/").append("resourceloaders");
            xp.append("/").append("loader");
            xp.append("[@").append("class");
            xp.append("='").append(CmsImageLoader.class.getName()).append("']");
            this.m_xpaths = Collections.singletonList(xp.toString());
        }
        return this.m_xpaths;
    }
}

