/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.setup.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Node;
import org.opencms.setup.xml.A_CmsSetupXmlUpdate;
import org.opencms.setup.xml.CmsSetupXmlHelper;
import org.opencms.widgets.CmsCategoryWidget;
import org.opencms.widgets.CmsDisplayWidget;
import org.opencms.widgets.CmsGroupWidget;
import org.opencms.widgets.CmsInputWidgetPlaintext;
import org.opencms.widgets.CmsLocalizationWidget;
import org.opencms.widgets.CmsMultiSelectWidget;
import org.opencms.widgets.CmsOrgUnitWidget;
import org.opencms.widgets.CmsPrincipalWidget;
import org.opencms.widgets.CmsRadioSelectWidget;
import org.opencms.widgets.CmsTextareaWidgetPlaintext;
import org.opencms.widgets.CmsUserWidget;

public class CmsXmlAddXmlContentWidgets
extends A_CmsSetupXmlUpdate {
    private Map m_widgetData;
    private List m_xpaths;

    public String getName() {
        return "Add new Xml Content widgets";
    }

    public String getXmlFilename() {
        return "opencms-vfs.xml";
    }

    protected boolean executeUpdate(Document document, String xpath) {
        Node node = document.selectSingleNode(xpath);
        if (node == null && this.getXPathsToUpdate().contains(xpath)) {
            Iterator it = this.getWidgetData().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String widgetName = (String)entry.getKey();
                String className = (String)entry.getValue();
                if (xpath.indexOf(widgetName) <= 0) continue;
                CmsSetupXmlHelper.setValue(document, xpath + "/@" + "alias", widgetName);
                CmsSetupXmlHelper.setValue(document, xpath + "/@" + "class", className);
                break;
            }
            return true;
        }
        return false;
    }

    protected String getCommonPath() {
        StringBuffer xp = new StringBuffer(256);
        xp.append("/").append("opencms");
        xp.append("/").append("vfs");
        xp.append("/").append("xmlcontent");
        xp.append("/").append("widgets");
        return xp.toString();
    }

    protected List getXPathsToUpdate() {
        if (this.m_xpaths == null) {
            StringBuffer xp = new StringBuffer(256);
            xp.append("/").append("opencms");
            xp.append("/").append("vfs");
            xp.append("/").append("xmlcontent");
            xp.append("/").append("widgets");
            xp.append("/").append("widget");
            xp.append("[@").append("alias");
            xp.append("='");
            this.m_xpaths = new ArrayList();
            Iterator it = this.getWidgetData().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String widgetName = (String)entry.getKey();
                this.m_xpaths.add(xp.toString() + widgetName + "']");
            }
        }
        return this.m_xpaths;
    }

    private Map getWidgetData() {
        if (this.m_widgetData == null) {
            this.m_widgetData = new HashMap();
            this.m_widgetData.put("DisplayWidget", CmsDisplayWidget.class.getName());
            this.m_widgetData.put("MultiSelectWidget", CmsMultiSelectWidget.class.getName());
            this.m_widgetData.put("UserWidget", CmsUserWidget.class.getName());
            this.m_widgetData.put("GroupWidget", CmsGroupWidget.class.getName());
            this.m_widgetData.put("CategoryWidget", CmsCategoryWidget.class.getName());
            this.m_widgetData.put("LocalizationWidget", CmsLocalizationWidget.class.getName());
            this.m_widgetData.put("TextareaWidgetPlaintext", CmsTextareaWidgetPlaintext.class.getName());
            this.m_widgetData.put("StringWidgetPlaintext", CmsInputWidgetPlaintext.class.getName());
            this.m_widgetData.put("OrgUnitWidget", CmsOrgUnitWidget.class.getName());
            this.m_widgetData.put("PrincipalWidget", CmsPrincipalWidget.class.getName());
            this.m_widgetData.put("RadioSelectWidget", CmsRadioSelectWidget.class.getName());
        }
        return this.m_widgetData;
    }
}

