/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.setup.xml;

import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Node;
import org.opencms.file.types.CmsResourceTypeBinary;
import org.opencms.file.types.CmsResourceTypeFolder;
import org.opencms.file.types.CmsResourceTypeImage;
import org.opencms.file.types.CmsResourceTypeJsp;
import org.opencms.file.types.CmsResourceTypePlain;
import org.opencms.file.types.CmsResourceTypePointer;
import org.opencms.file.types.CmsResourceTypeXmlPage;
import org.opencms.setup.xml.A_CmsXmlWorkplace;
import org.opencms.setup.xml.CmsSetupXmlHelper;
import org.opencms.util.CmsStringUtil;

public class CmsXmlUpdateDefaultPermissions
extends A_CmsXmlWorkplace {
    private List m_xpaths;

    public String getName() {
        return "Update default permissions for explorer access";
    }

    protected boolean executeUpdate(Document document, String xpath) {
        boolean changed = false;
        if (xpath.endsWith("accesscontrol")) {
            Node node = document.selectSingleNode(xpath);
            if (node != null) {
                String xp = xpath + "/" + "accessentry" + "[@" + "principal" + "='???']";
                if (xpath.indexOf(CmsResourceTypeJsp.getStaticTypeName()) < 0 && xpath.indexOf("XMLTemplate") < 0) {
                    if (xpath.indexOf("defaultaccesscontrol") < 0) {
                        changed = 0 < CmsSetupXmlHelper.setValue(document, CmsStringUtil.substitute((String)xp, (String)"???", (String)"DEFAULT"), null) || changed;
                        changed = 0 < CmsSetupXmlHelper.setValue(document, CmsStringUtil.substitute((String)xp, (String)"???", (String)"GROUP.Guests"), null) || changed;
                    }
                    changed = 0 < CmsSetupXmlHelper.setValue(document, CmsStringUtil.substitute((String)xp, (String)"???", (String)"GROUP.Administrators"), null) || changed;
                }
                changed = 0 < CmsSetupXmlHelper.setValue(document, CmsStringUtil.substitute((String)xp, (String)"???", (String)"GROUP.Projectmanagers"), null) || changed;
                changed = 0 < CmsSetupXmlHelper.setValue(document, CmsStringUtil.substitute((String)xp, (String)"???", (String)"GROUP.Users"), null) || changed;
                boolean bl = changed = 0 < CmsSetupXmlHelper.setValue(document, CmsStringUtil.substitute((String)xp, (String)"???", (String)"GROUP.TestGroup"), null) || changed;
                if (CmsSetupXmlHelper.getValue(document, xpath + "/" + "accessentry") == null && xpath.indexOf(CmsResourceTypeJsp.getStaticTypeName()) < 0 && xpath.indexOf("XMLTemplate") < 0) {
                    boolean bl2 = changed = 0 < CmsSetupXmlHelper.setValue(document, xpath, null) || changed;
                }
            }
            if (xpath.indexOf(CmsResourceTypeJsp.getStaticTypeName()) > 0 || xpath.indexOf("XMLTemplate") > 0) {
                changed = this.setAccessEntry(document, xpath, "DEFAULT", "+r+v") || changed;
                changed = this.setAccessEntry(document, xpath, "GROUP.Administrators", "+r+v+w+c") || changed;
                changed = this.setAccessEntry(document, xpath, "GROUP.Guests", "-r-v-w-c") || changed;
            } else if (xpath.indexOf("defaultaccesscontrol") > 0) {
                changed = this.setAccessEntry(document, xpath, "DEFAULT", "+r+v+w+c") || changed;
                changed = this.setAccessEntry(document, xpath, "GROUP.Guests", "-r-v-w-c") || changed;
            }
        }
        return changed;
    }

    protected String getCommonPath() {
        return "/" + "opencms" + "/" + "workplace" + "/" + "explorertypes";
    }

    protected List getXPathsToUpdate() {
        if (this.m_xpaths == null) {
            StringBuffer xp = new StringBuffer(256);
            xp.append("/").append("opencms");
            xp.append("/").append("workplace");
            xp.append("/").append("explorertypes");
            xp.append("/").append("explorertype");
            xp.append("[@").append("name");
            xp.append("='${etype}']/");
            xp.append("accesscontrol");
            this.m_xpaths = new ArrayList();
            this.m_xpaths.add(CmsStringUtil.substitute((String)xp.toString(), (String)"${etype}", (String)CmsResourceTypeFolder.getStaticTypeName()));
            this.m_xpaths.add(CmsStringUtil.substitute((String)xp.toString(), (String)"${etype}", (String)"imagegallery"));
            this.m_xpaths.add(CmsStringUtil.substitute((String)xp.toString(), (String)"${etype}", (String)"downloadgallery"));
            this.m_xpaths.add(CmsStringUtil.substitute((String)xp.toString(), (String)"${etype}", (String)"xmlcontent"));
            this.m_xpaths.add(CmsStringUtil.substitute((String)xp.toString(), (String)"${etype}", (String)CmsResourceTypeXmlPage.getStaticTypeName()));
            this.m_xpaths.add(CmsStringUtil.substitute((String)xp.toString(), (String)"${etype}", (String)CmsResourceTypePlain.getStaticTypeName()));
            this.m_xpaths.add(CmsStringUtil.substitute((String)xp.toString(), (String)"${etype}", (String)CmsResourceTypeImage.getStaticTypeName()));
            this.m_xpaths.add(CmsStringUtil.substitute((String)xp.toString(), (String)"${etype}", (String)CmsResourceTypeJsp.getStaticTypeName()));
            this.m_xpaths.add(CmsStringUtil.substitute((String)xp.toString(), (String)"${etype}", (String)CmsResourceTypeBinary.getStaticTypeName()));
            this.m_xpaths.add(CmsStringUtil.substitute((String)xp.toString(), (String)"${etype}", (String)"XMLTemplate"));
            this.m_xpaths.add(CmsStringUtil.substitute((String)xp.toString(), (String)"${etype}", (String)CmsResourceTypePointer.getStaticTypeName()));
            this.m_xpaths.add(CmsStringUtil.substitute((String)xp.toString(), (String)"${etype}", (String)"link"));
            this.m_xpaths.add(CmsStringUtil.substitute((String)xp.toString(), (String)"${etype}", (String)"upload"));
            xp = new StringBuffer(256);
            xp.append("/").append("opencms");
            xp.append("/").append("workplace");
            xp.append("/").append("explorertypes");
            xp.append("/").append("defaultaccesscontrol");
            xp.append("/").append("accesscontrol");
            this.m_xpaths.add(xp.toString());
        }
        return this.m_xpaths;
    }
}

