/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.setup.xml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Node;
import org.opencms.file.types.CmsResourceTypeBinary;
import org.opencms.file.types.CmsResourceTypeFolder;
import org.opencms.file.types.CmsResourceTypeImage;
import org.opencms.file.types.CmsResourceTypeJsp;
import org.opencms.file.types.CmsResourceTypePlain;
import org.opencms.file.types.CmsResourceTypePointer;
import org.opencms.file.types.CmsResourceTypeXmlPage;
import org.opencms.setup.xml.A_CmsSetupXmlUpdate;
import org.opencms.setup.xml.CmsSetupXmlHelper;
import org.opencms.util.CmsStringUtil;

public class CmsXmlUpdateDefaultProperties
extends A_CmsSetupXmlUpdate {
    private List m_xpaths;
    private List m_xpathsRemove;

    public String getName() {
        return "Update default properties";
    }

    public String getXmlFilename() {
        return "opencms-workplace.xml";
    }

    protected boolean executeUpdate(Document document, String xpath) {
        Node node = document.selectSingleNode(xpath);
        if (node == null) {
            int index = this.getXPathsToUpdate().indexOf(xpath);
            if (index > -1) {
                CmsSetupXmlHelper.setValue(document, xpath + "/@" + "name", ((Pair)this.getKeys().get(index)).getSecond());
                return true;
            }
            return false;
        }
        return false;
    }

    protected String getCommonPath() {
        return null;
    }

    protected List getKeys() {
        ArrayList<Pair> keys = new ArrayList<Pair>();
        keys.add(new Pair(CmsResourceTypeFolder.getStaticTypeName(), "Title"));
        keys.add(new Pair(CmsResourceTypeBinary.getStaticTypeName(), "Title"));
        keys.add(new Pair(CmsResourceTypePointer.getStaticTypeName(), "Title"));
        keys.add(new Pair("imagegallery", "Title"));
        keys.add(new Pair("downloadgallery", "Title"));
        keys.add(new Pair(CmsResourceTypeImage.getStaticTypeName(), "Title"));
        keys.add(new Pair(CmsResourceTypeImage.getStaticTypeName(), "Description"));
        keys.add(new Pair(CmsResourceTypeXmlPage.getStaticTypeName(), "Title"));
        keys.add(new Pair(CmsResourceTypeXmlPage.getStaticTypeName(), "Description"));
        keys.add(new Pair(CmsResourceTypeXmlPage.getStaticTypeName(), "Keywords"));
        keys.add(new Pair("xmlcontent", "Title"));
        keys.add(new Pair("xmlcontent", "Description"));
        keys.add(new Pair("xmlcontent", "Keywords"));
        keys.add(new Pair(CmsResourceTypePlain.getStaticTypeName(), "Title"));
        keys.add(new Pair(CmsResourceTypePlain.getStaticTypeName(), "export"));
        keys.add(new Pair(CmsResourceTypeJsp.getStaticTypeName(), "Title"));
        keys.add(new Pair(CmsResourceTypeJsp.getStaticTypeName(), "export"));
        keys.add(new Pair(CmsResourceTypeJsp.getStaticTypeName(), "cache"));
        keys.add(new Pair(CmsResourceTypeJsp.getStaticTypeName(), "content-encoding"));
        return keys;
    }

    protected List getXPathsToRemove() {
        if (this.m_xpathsRemove == null) {
            StringBuffer xp = new StringBuffer(256);
            xp.append("/").append("opencms");
            xp.append("/").append("workplace");
            xp.append("/").append("explorertypes");
            xp.append("/").append("explorertype");
            xp.append("/").append("editoptions");
            xp.append("/").append("defaultproperties");
            xp.append("/").append("property");
            this.m_xpathsRemove = Collections.singletonList(xp.toString());
        }
        return this.m_xpathsRemove;
    }

    protected List getXPathsToUpdate() {
        if (this.m_xpaths == null) {
            StringBuffer xp = new StringBuffer(256);
            xp.append("/").append("opencms");
            xp.append("/").append("workplace");
            xp.append("/").append("explorertypes");
            xp.append("/").append("explorertype");
            xp.append("[@").append("name");
            xp.append("='${etype}']/");
            xp.append("editoptions");
            xp.append("/").append("defaultproperties");
            xp.append("/").append("defaultproperty");
            xp.append("[@").append("name");
            xp.append("='${pname}']");
            this.m_xpaths = new ArrayList();
            Iterator it = this.getKeys().iterator();
            while (it.hasNext()) {
                Pair entry = (Pair)it.next();
                String eType = entry.getFirst();
                String prop = entry.getSecond();
                HashMap<String, String> subs = new HashMap<String, String>();
                subs.put("${etype}", eType);
                subs.put("${pname}", prop);
                this.m_xpaths.add(CmsStringUtil.substitute((String)xp.toString(), subs));
            }
        }
        return this.m_xpaths;
    }

    private static class Pair {
        private String m_first;
        private String m_second;

        protected Pair(String first, String second) {
            this.m_first = first;
            this.m_second = second;
        }

        public String getFirst() {
            return this.m_first;
        }

        public String getSecond() {
            return this.m_second;
        }
    }
}

