/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.setup.xml;

import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Node;
import org.opencms.file.types.CmsResourceTypeBinary;
import org.opencms.file.types.CmsResourceTypeImage;
import org.opencms.file.types.CmsResourceTypeJsp;
import org.opencms.file.types.CmsResourceTypePlain;
import org.opencms.file.types.CmsResourceTypePointer;
import org.opencms.file.types.CmsResourceTypeXmlPage;
import org.opencms.setup.xml.A_CmsSetupXmlUpdate;
import org.opencms.setup.xml.CmsSetupXmlHelper;
import org.opencms.util.CmsStringUtil;

public class CmsXmlUpdateHistoryContextMenu
extends A_CmsSetupXmlUpdate {
    private List m_xpaths;

    public String getName() {
        return "Modify the History context menu";
    }

    public String getXmlFilename() {
        return "opencms-workplace.xml";
    }

    protected boolean executeUpdate(Document document, String xpath) {
        Node node = document.selectSingleNode(xpath);
        if (xpath.indexOf("tool-manager") < 0) {
            if (node != null) {
                CmsSetupXmlHelper.setValue(document, xpath + "/@" + "uri", "views/admin/admin-main.jsp?root=explorer&amp;path=%2Fhistory");
                return true;
            }
        } else if (node == null) {
            String xp = xpath + "/" + "roots" + "/" + "root" + "[" + "key" + "='admin']";
            CmsSetupXmlHelper.setValue(document, xp + "/" + "key", "admin");
            CmsSetupXmlHelper.setValue(document, xp + "/" + "uri", "/system/workplace/admin/");
            CmsSetupXmlHelper.setValue(document, xp + "/" + "name", "${key.GUI_ADMIN_VIEW_ROOT_NAME_0}");
            CmsSetupXmlHelper.setValue(document, xp + "/" + "helptext", "${key.GUI_ADMIN_VIEW_ROOT_HELP_0}");
            xp = CmsStringUtil.substitute((String)xp, (String)"admin", (String)"explorer");
            CmsSetupXmlHelper.setValue(document, xp + "/" + "key", "explorer");
            CmsSetupXmlHelper.setValue(document, xp + "/" + "uri", "/system/workplace/explorer/");
            CmsSetupXmlHelper.setValue(document, xp + "/" + "name", "${key.GUI_EXPLORER_VIEW_ROOT_NAME_0}");
            CmsSetupXmlHelper.setValue(document, xp + "/" + "helptext", "${key.GUI_EXPLORER_VIEW_ROOT_HELP_0}");
            return true;
        }
        return false;
    }

    protected String getCommonPath() {
        return "/" + "opencms" + "/" + "workplace";
    }

    protected List getXPathsToUpdate() {
        if (this.m_xpaths == null) {
            StringBuffer xp = new StringBuffer(256);
            xp.append("/").append("opencms");
            xp.append("/").append("workplace");
            xp.append("/").append("explorertypes");
            xp.append("/").append("explorertype");
            xp.append("[@").append("name");
            xp.append("='${etype}']/");
            xp.append("editoptions");
            xp.append("/").append("contextmenu");
            xp.append("/").append("entry");
            xp.append("[@").append("uri");
            xp.append("='commons/history.jsp']");
            this.m_xpaths = new ArrayList();
            this.m_xpaths.add(CmsStringUtil.substitute((String)xp.toString(), (String)"${etype}", (String)"xmlcontent"));
            this.m_xpaths.add(CmsStringUtil.substitute((String)xp.toString(), (String)"${etype}", (String)CmsResourceTypeXmlPage.getStaticTypeName()));
            this.m_xpaths.add(CmsStringUtil.substitute((String)xp.toString(), (String)"${etype}", (String)CmsResourceTypePlain.getStaticTypeName()));
            this.m_xpaths.add(CmsStringUtil.substitute((String)xp.toString(), (String)"${etype}", (String)CmsResourceTypeImage.getStaticTypeName()));
            this.m_xpaths.add(CmsStringUtil.substitute((String)xp.toString(), (String)"${etype}", (String)CmsResourceTypeJsp.getStaticTypeName()));
            this.m_xpaths.add(CmsStringUtil.substitute((String)xp.toString(), (String)"${etype}", (String)CmsResourceTypeBinary.getStaticTypeName()));
            this.m_xpaths.add(CmsStringUtil.substitute((String)xp.toString(), (String)"${etype}", (String)CmsResourceTypePointer.getStaticTypeName()));
            this.m_xpaths.add(CmsStringUtil.substitute((String)xp.toString(), (String)"${etype}", (String)"XMLTemplate"));
            xp = new StringBuffer(256);
            xp.append("/").append("opencms");
            xp.append("/").append("workplace");
            xp.append("/").append("tool-manager");
            this.m_xpaths.add(xp.toString());
        }
        return this.m_xpaths;
    }
}

