/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.frontend.layoutpage;

import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.frontend.layoutpage.Messages;
import org.opencms.main.CmsEvent;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.I_CmsEventListener;
import org.opencms.main.OpenCms;

public final class CmsFreeMarkerTemplateCache
implements I_CmsEventListener {
    private static final Log LOG = CmsLog.getLog((Object)CmsFreeMarkerTemplateCache.class);
    private static CmsFreeMarkerTemplateCache m_instance;
    private Configuration m_configuration;

    private CmsFreeMarkerTemplateCache() {
        this.initConfiguration();
        OpenCms.addCmsEventListener((I_CmsEventListener)this);
    }

    public static CmsFreeMarkerTemplateCache getInstance() {
        if (m_instance == null) {
            m_instance = new CmsFreeMarkerTemplateCache();
        }
        return m_instance;
    }

    public void cmsEvent(CmsEvent event) {
        switch (event.getType()) {
            case 2: 
            case 5: 
            case 8: 
            case 9: {
                this.clearTemplateCache();
                if (!LOG.isDebugEnabled()) break;
                LOG.debug((Object)Messages.get().getBundle().key("LOG_CMSMACROMANAGER_CLEARED_0"));
                break;
            }
        }
    }

    public Template getTemplate(CmsObject cms, String fileName) throws CmsException, IOException {
        if (this.hasTemplate(fileName)) {
            return this.m_configuration.getTemplate(this.getCacheKey(fileName));
        }
        String encoding = cms.getRequestContext().getEncoding();
        byte[] content = cms.readFile(fileName).getContents();
        StringBuffer fTemplate = new StringBuffer(new String(content, encoding));
        fTemplate.append("<@");
        fTemplate.append("ocmsmacro");
        fTemplate.append(" />");
        return this.putTemplate(fileName, fTemplate.toString());
    }

    public boolean hasTemplate(String fileName) {
        try {
            this.m_configuration.getTemplate(this.getCacheKey(fileName));
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private void clearTemplateCache() {
        this.m_configuration.clearTemplateCache();
        this.m_configuration.setTemplateLoader((TemplateLoader)new StringTemplateLoader());
    }

    private String getCacheKey(String fileName) {
        return String.valueOf(fileName.hashCode());
    }

    private void initConfiguration() {
        this.m_configuration = new Configuration();
        this.m_configuration.setDefaultEncoding(OpenCms.getSystemInfo().getDefaultEncoding());
        this.m_configuration.setTemplateLoader((TemplateLoader)new StringTemplateLoader());
    }

    private Template putTemplate(String fileName, String templateSource) {
        String cacheKey = this.getCacheKey(fileName);
        ((StringTemplateLoader)this.m_configuration.getTemplateLoader()).putTemplate(cacheKey, templateSource);
        try {
            return this.m_configuration.getTemplate(cacheKey);
        }
        catch (IOException e) {
            return null;
        }
    }
}

