/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.publishqueue;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.i18n.CmsEncoder;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.publish.CmsPublishJobFinished;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.CmsWidgetDialog;
import org.opencms.workplace.tools.publishqueue.Messages;

public class CmsPublishQueueHistoricalReportDialog
extends CmsWidgetDialog {
    private static final String[] PAGES = new String[]{"page1"};
    public static final String PARAM_ID = "id";
    protected String m_jobId = null;

    public CmsPublishQueueHistoricalReportDialog(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsPublishQueueHistoricalReportDialog(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
        this.setParamId(CmsEncoder.decodeParameter((String)req.getParameter(PARAM_ID)));
    }

    public void actionCommit() {
    }

    public String getParamFilename() {
        return this.m_jobId;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String readFileContent() throws CmsException {
        String string;
        BufferedReader reader = null;
        try {
            try {
                CmsPublishJobFinished publishJob = (CmsPublishJobFinished)OpenCms.getPublishManager().getJobByPublishHistoryId(new CmsUUID(this.m_jobId));
                byte[] contents = OpenCms.getPublishManager().getReportContents(publishJob);
                StringBuffer result = new StringBuffer();
                if (contents != null) {
                    reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(contents)));
                    String read = reader.readLine();
                    while (read != null) {
                        result.append(read).append("\n");
                        read = reader.readLine();
                    }
                }
                string = result.toString();
                Object var7_8 = null;
                if (reader == null) return string;
            }
            catch (IOException ioex) {
                throw new CmsException(Messages.get().container("ERR_FILE_ARG_ACCESS_1", (Object)this.m_jobId), (Throwable)ioex);
            }
            catch (CmsException ex) {
                throw new CmsException(Messages.get().container("ERR_FILE_ARG_ACCESS_1", (Object)this.m_jobId), (Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (reader == null) throw throwable;
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException e) {
                throw throwable;
            }
        }
        try {}
        catch (IOException e) {
            // empty catch block
            return string;
        }
        reader.close();
        return string;
    }

    public void setParamId(String value) {
        this.m_jobId = value;
    }

    protected String createDialogHtml(String dialog) {
        String fileContentHeader;
        StringBuffer result = new StringBuffer(1024);
        result.append(this.createWidgetTableStart());
        result.append(this.createWidgetErrorHeader());
        if (this.m_jobId == null) {
            fileContentHeader = this.key("GUI_PERSONALQUEUE_LIST_NAME_0");
        } else {
            Object[] params = new Object[3];
            CmsPublishJobFinished publishJob = (CmsPublishJobFinished)OpenCms.getPublishManager().getJobByPublishHistoryId(new CmsUUID(this.m_jobId));
            params[0] = publishJob.getProjectName();
            params[1] = publishJob.getUserName(this.getCms());
            params[2] = Messages.get().getBundle(this.getLocale()).getDateTime(publishJob.getStartTime());
            fileContentHeader = this.key("GUI_PUBLISH_REPORT_VIEW_TITLE_3", params);
        }
        result.append(this.createWidgetBlockStart(fileContentHeader));
        try {
            result.append("<iframe style=\"overflow: auto;\" src=\"");
            result.append(this.getJsp().link("/system/workplace/admin/publishqueue/publishreportshow.jsp?" + CmsEncoder.encodeParameter((String)PARAM_ID) + "=" + CmsEncoder.encodeParameter((String)this.m_jobId)));
            result.append("\" width=\"100%\" height=\"500\" border=\"0\" frameborder=\"0\"></iframe>");
        }
        catch (Exception e) {
            // empty catch block
        }
        result.append(this.createWidgetBlockEnd());
        result.append(this.createWidgetTableEnd());
        return result.toString();
    }

    protected void defineWidgets() {
    }

    protected String[] getPageArray() {
        return PAGES;
    }

    protected void validateParamaters() throws Exception {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)this.m_jobId)) {
            throw new Exception();
        }
    }
}

