/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.publishqueue;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.db.CmsPublishList;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.publish.CmsPublishJobBase;
import org.opencms.publish.CmsPublishJobEnqueued;
import org.opencms.publish.CmsPublishJobRunning;
import org.opencms.security.CmsRole;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.list.A_CmsListDialog;
import org.opencms.workplace.list.CmsListColumnAlignEnum;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListDateMacroFormatter;
import org.opencms.workplace.list.CmsListDefaultAction;
import org.opencms.workplace.list.CmsListDirectAction;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListItemDetails;
import org.opencms.workplace.list.CmsListItemDetailsFormatter;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListOrderEnum;
import org.opencms.workplace.list.I_CmsListDirectAction;
import org.opencms.workplace.list.I_CmsListFormatter;
import org.opencms.workplace.tools.publishqueue.Messages;

public class CmsPublishQueueList
extends A_CmsListDialog {
    public static final String LIST_ID = "lpq";
    public static final String PUBLISHQUEUE_CANCEL_BUTTON = "tools/publishqueue/buttons/cancel.png";
    public static final String PUBLISHQUEUE_STATE_PROCEED_BUTTON = "tools/publishqueue/buttons/publish_current.png";
    public static final int STATE_OTHER = 1;
    public static final int STATE_OWN = 0;
    public static final int STATE_PROCEED = 2;
    private static final String LIST_ACTION_CANCEL = "ac";
    private static final String LIST_ACTION_NUMBER = "an";
    private static final String LIST_ACTION_PROJECT = "ap";
    private static final String LIST_ACTION_RESCOUNT = "ar";
    private static final String LIST_ACTION_STARTTIME = "at";
    private static final String LIST_ACTION_STATE = "as";
    private static final String LIST_ACTION_USER = "au";
    private static final String LIST_COLUMN_NUMBER = "cn";
    private static final String LIST_COLUMN_PROJECT = "cp";
    private static final String LIST_COLUMN_RESCOUNT = "cr";
    private static final String LIST_COLUMN_STARTTIME = "ct";
    private static final String LIST_COLUMN_STATE = "cs";
    private static final String LIST_COLUMN_USER = "cu";
    private static final String LIST_DETAIL_RESOURCES = "dr";

    public CmsPublishQueueList(CmsJspActionElement jsp) {
        this(jsp, LIST_ID);
    }

    public CmsPublishQueueList(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    protected CmsPublishQueueList(CmsJspActionElement jsp, String listId) {
        super(jsp, listId, Messages.get().container("GUI_PUBLISHQUEUE_LIST_NAME_0"), LIST_COLUMN_NUMBER, CmsListOrderEnum.ORDER_ASCENDING, null);
    }

    public void executeListMultiActions() throws CmsRuntimeException {
        this.throwListUnsupportedActionException();
    }

    public void executeListSingleActions() throws CmsRuntimeException {
        if (this.getParamListAction().equals(LIST_ACTION_NUMBER) || this.getParamListAction().equals(LIST_ACTION_PROJECT) || this.getParamListAction().equals(LIST_ACTION_RESCOUNT) || this.getParamListAction().equals(LIST_ACTION_STATE) || this.getParamListAction().equals(LIST_ACTION_USER) || this.getParamListAction().equals(LIST_ACTION_STARTTIME)) {
            try {
                this.getToolManager().jspForwardTool((CmsWorkplace)this, "/publishqueue/live", null);
            }
            catch (Exception e) {}
        } else if (this.getParamListAction().equals(LIST_ACTION_CANCEL)) {
            String userName = (String)this.getSelectedItem().get(LIST_COLUMN_USER);
            long enqueueTime = ((Date)this.getSelectedItem().get(LIST_COLUMN_STARTTIME)).getTime();
            Iterator itJobs = OpenCms.getPublishManager().getPublishQueue().iterator();
            while (itJobs.hasNext()) {
                CmsPublishJobEnqueued publishJob = (CmsPublishJobEnqueued)itJobs.next();
                if (!userName.equals(publishJob.getUserName(this.getCms())) || enqueueTime != publishJob.getEnqueueTime()) continue;
                try {
                    OpenCms.getPublishManager().abortPublishJob(this.getCms(), publishJob, true);
                    break;
                }
                catch (CmsException e) {
                    throw new CmsRuntimeException(e.getMessageContainer(), (Throwable)e);
                }
            }
        } else {
            this.throwListUnsupportedActionException();
        }
    }

    protected String defaultActionHtmlEnd() {
        return "&nbsp;<br>";
    }

    protected void fillDetails(String detailId) {
        List publishJobs = this.getList().getAllContent();
        Iterator itPublishJobs = publishJobs.iterator();
        while (itPublishJobs.hasNext()) {
            CmsPublishList publishList;
            CmsListItem item = (CmsListItem)itPublishJobs.next();
            int state = (Integer)item.get(LIST_COLUMN_STATE);
            boolean enabled = state == 2 && (OpenCms.getRoleManager().hasRole(this.getCms(), CmsRole.ROOT_ADMIN) || this.getCms().getRequestContext().currentUser().getName().equals(item.get(LIST_COLUMN_USER)));
            boolean bl = enabled = enabled || OpenCms.getRoleManager().hasRole(this.getCms(), CmsRole.ROOT_ADMIN) || state == 0;
            if (!enabled) continue;
            CmsUUID publishHistoryId = new CmsUUID(item.getId());
            CmsPublishJobBase publishJob = OpenCms.getPublishManager().getJobByPublishHistoryId(publishHistoryId);
            StringBuffer html = new StringBuffer(32);
            if (publishJob == null || !detailId.equals(LIST_DETAIL_RESOURCES)) continue;
            if (publishJob instanceof CmsPublishJobEnqueued) {
                publishList = ((CmsPublishJobEnqueued)publishJob).getPublishList();
            } else {
                if (!(publishJob instanceof CmsPublishJobRunning)) continue;
                publishList = ((CmsPublishJobRunning)publishJob).getPublishList();
            }
            ArrayList resources = new ArrayList(publishList.size());
            resources.addAll(publishList.getFolderList());
            resources.addAll(publishList.getFileList());
            resources.addAll(publishList.getDeletedFolderList());
            Iterator itResources = resources.iterator();
            while (itResources.hasNext()) {
                CmsResource resource = (CmsResource)itResources.next();
                html.append(this.getCms().getSitePath(resource));
                html.append("<br>");
            }
            item.set(detailId, (Object)html.toString());
        }
    }

    protected List getListItems() {
        CmsPublishJobRunning currentJob;
        ArrayList<CmsListItem> ret = new ArrayList<CmsListItem>();
        int number = 1;
        if (OpenCms.getPublishManager().isRunning() && (currentJob = OpenCms.getPublishManager().getCurrentPublishJob()) != null) {
            CmsListItem item = this.getList().newItem(currentJob.getPublishList().getPublishHistoryId().toString());
            item.set(LIST_COLUMN_STATE, (Object)new Integer(2));
            item.set(LIST_COLUMN_NUMBER, (Object)new Integer(number));
            item.set(LIST_COLUMN_PROJECT, (Object)currentJob.getProjectName());
            item.set(LIST_COLUMN_STARTTIME, (Object)new Date(currentJob.getEnqueueTime()));
            item.set(LIST_COLUMN_USER, (Object)currentJob.getUserName(this.getCms()));
            item.set(LIST_COLUMN_RESCOUNT, (Object)new Integer(currentJob.getSize()));
            ret.add(item);
            ++number;
        }
        Iterator iter = OpenCms.getPublishManager().getPublishQueue().iterator();
        while (iter.hasNext()) {
            CmsPublishJobEnqueued publishJob = (CmsPublishJobEnqueued)iter.next();
            CmsListItem item = this.getList().newItem(publishJob.getPublishList().getPublishHistoryId().toString());
            int state = 0;
            if (!publishJob.getUserId().equals((Object)this.getCms().getRequestContext().currentUser().getId())) {
                state = 1;
            }
            item.set(LIST_COLUMN_STATE, (Object)new Integer(state));
            item.set(LIST_COLUMN_NUMBER, (Object)new Integer(number));
            item.set(LIST_COLUMN_PROJECT, (Object)publishJob.getProjectName());
            item.set(LIST_COLUMN_STARTTIME, (Object)new Date(publishJob.getEnqueueTime()));
            item.set(LIST_COLUMN_USER, (Object)publishJob.getUserName(this.getCms()));
            item.set(LIST_COLUMN_RESCOUNT, (Object)new Integer(publishJob.getSize()));
            ret.add(item);
            ++number;
        }
        return ret;
    }

    protected void setColumns(CmsListMetadata metadata) {
        CmsListColumnDefinition stateCol = new CmsListColumnDefinition(LIST_COLUMN_STATE);
        stateCol.setName(Messages.get().container("GUI_PUBLISHQUEUE_COLS_STATE_0"));
        stateCol.setWidth("20");
        stateCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        stateCol.setSorteable(false);
        CmsListDirectAction viewDirectAction = new CmsListDirectAction(LIST_ACTION_STATE){

            public boolean isEnabled() {
                return OpenCms.getRoleManager().hasRole(this.getWp().getCms(), CmsRole.ROOT_ADMIN) || this.getWp().getCms().getRequestContext().currentUser().getName().equals(this.getItem().get(CmsPublishQueueList.LIST_COLUMN_USER));
            }

            public boolean isVisible() {
                int state = (Integer)this.getItem().get(CmsPublishQueueList.LIST_COLUMN_STATE);
                return state == 2;
            }
        };
        viewDirectAction.setName(Messages.get().container("GUI_PUBLISHQUEUE_ACTION_VIEW_NAME_0"));
        viewDirectAction.setHelpText(Messages.get().container("GUI_PUBLISHQUEUE_ACTION_VIEW_HELP_0"));
        viewDirectAction.setIconPath(PUBLISHQUEUE_STATE_PROCEED_BUTTON);
        stateCol.addDirectAction((I_CmsListDirectAction)viewDirectAction);
        CmsListDirectAction cancelAction = new CmsListDirectAction(LIST_ACTION_CANCEL){

            public boolean isEnabled() {
                int state = (Integer)this.getItem().get(CmsPublishQueueList.LIST_COLUMN_STATE);
                return OpenCms.getRoleManager().hasRole(this.getWp().getCms(), CmsRole.ROOT_ADMIN) || state == 0;
            }

            public boolean isVisible() {
                int state = (Integer)this.getItem().get(CmsPublishQueueList.LIST_COLUMN_STATE);
                return state != 2;
            }
        };
        cancelAction.setName(Messages.get().container("GUI_PUBLISHQUEUE_ACTION_CANCEL_NAME_0"));
        cancelAction.setHelpText(Messages.get().container("GUI_PUBLISHQUEUE_ACTION_CANCEL_HELP_0"));
        cancelAction.setConfirmationMessage(Messages.get().container("GUI_PUBLISHQUEUE_ACTION_CANCEL_CONF_0"));
        cancelAction.setIconPath(PUBLISHQUEUE_CANCEL_BUTTON);
        stateCol.addDirectAction((I_CmsListDirectAction)cancelAction);
        stateCol.setFormatter(new I_CmsListFormatter(){

            public String format(Object data, Locale locale) {
                return "";
            }
        });
        metadata.addColumn(stateCol);
        CmsListColumnDefinition numCol = new CmsListColumnDefinition(LIST_COLUMN_NUMBER);
        numCol.setName(Messages.get().container("GUI_PUBLISHQUEUE_COLS_NUMBER_0"));
        numCol.setWidth("5%");
        numCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        final class CmsPublishQueueViewLiveReportAction
        extends CmsListDefaultAction {
            CmsPublishQueueViewLiveReportAction(String id) {
                super(id);
                this.setName(Messages.get().container("GUI_PUBLISHQUEUE_ACTION_VIEW_NAME_0"));
                this.setHelpText(Messages.get().container("GUI_PUBLISHQUEUE_ACTION_VIEW_HELP_0"));
            }

            public CmsMessageContainer getHelpText() {
                if (this.isEnabled()) {
                    return super.getHelpText();
                }
                return EMPTY_MESSAGE;
            }

            public boolean isEnabled() {
                int state = (Integer)this.getItem().get(CmsPublishQueueList.LIST_COLUMN_STATE);
                return state == 2 && (OpenCms.getRoleManager().hasRole(this.getWp().getCms(), CmsRole.ROOT_ADMIN) || this.getWp().getCms().getRequestContext().currentUser().getName().equals(this.getItem().get(CmsPublishQueueList.LIST_COLUMN_USER)));
            }
        }
        numCol.addDefaultAction((CmsListDefaultAction)new CmsPublishQueueViewLiveReportAction(LIST_ACTION_NUMBER));
        metadata.addColumn(numCol);
        CmsListColumnDefinition projectCol = new CmsListColumnDefinition(LIST_COLUMN_PROJECT);
        projectCol.setName(Messages.get().container("GUI_PUBLISHQUEUE_COLS_PROJECT_0"));
        projectCol.setAlign(CmsListColumnAlignEnum.ALIGN_LEFT);
        projectCol.setWidth("30%");
        projectCol.addDefaultAction((CmsListDefaultAction)new CmsPublishQueueViewLiveReportAction(LIST_ACTION_PROJECT));
        metadata.addColumn(projectCol);
        CmsListColumnDefinition startCol = new CmsListColumnDefinition(LIST_COLUMN_STARTTIME);
        startCol.setName(Messages.get().container("GUI_PUBLISHQUEUE_COLS_INQUEUETIME_0"));
        startCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        startCol.setFormatter((I_CmsListFormatter)new CmsListDateMacroFormatter(Messages.get().container("GUI_LIST_DATE_FORMAT_WITH_SECONDS_1"), Messages.get().container("GUI_LIST_DATE_FORMAT_NEVER_0")));
        startCol.setWidth("30%");
        startCol.addDefaultAction((CmsListDefaultAction)new CmsPublishQueueViewLiveReportAction(LIST_ACTION_STARTTIME));
        metadata.addColumn(startCol);
        CmsListColumnDefinition userCol = new CmsListColumnDefinition(LIST_COLUMN_USER);
        userCol.setName(Messages.get().container("GUI_PUBLISHQUEUE_COLS_USER_0"));
        userCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        userCol.setWidth("30%");
        userCol.addDefaultAction((CmsListDefaultAction)new CmsPublishQueueViewLiveReportAction(LIST_ACTION_USER));
        metadata.addColumn(userCol);
        CmsListColumnDefinition countCol = new CmsListColumnDefinition(LIST_COLUMN_RESCOUNT);
        countCol.setName(Messages.get().container("GUI_PUBLISHQUEUE_COLS_RESCOUNT_0"));
        countCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        countCol.setWidth("5%");
        countCol.addDefaultAction((CmsListDefaultAction)new CmsPublishQueueViewLiveReportAction(LIST_ACTION_RESCOUNT));
        metadata.addColumn(countCol);
    }

    protected void setIndependentActions(CmsListMetadata metadata) {
        CmsListItemDetails resourcesDetails = new CmsListItemDetails(LIST_DETAIL_RESOURCES);
        resourcesDetails.setAtColumn(LIST_COLUMN_NUMBER);
        resourcesDetails.setVisible(false);
        resourcesDetails.setFormatter((I_CmsListFormatter)new CmsListItemDetailsFormatter(Messages.get().container("GUI_PUBLISHQUEUE_DETAIL_LABEL_RESOURCES_0")));
        resourcesDetails.setShowActionName(Messages.get().container("GUI_PUBLISHQUEUE_DETAIL_SHOW_RESOURCES_NAME_0"));
        resourcesDetails.setShowActionHelpText(Messages.get().container("GUI_PUBLISHQUEUE_DETAIL_SHOW_RESOURCES_HELP_0"));
        resourcesDetails.setHideActionName(Messages.get().container("GUI_PUBLISHQUEUE_DETAIL_HIDE_RESOURCES_NAME_0"));
        resourcesDetails.setHideActionHelpText(Messages.get().container("GUI_PUBLISHQUEUE_DETAIL_HIDE_RESOURCES_HELP_0"));
        metadata.addItemDetails(resourcesDetails);
    }

    protected void setMultiActions(CmsListMetadata metadata) {
    }
}

