/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.publishqueue;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.OpenCms;
import org.opencms.publish.CmsPublishJobRunning;
import org.opencms.security.CmsRole;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsReport;
import org.opencms.workplace.CmsWorkplaceSettings;

public class CmsPublishQueueLiveReportDialog
extends CmsReport {
    public static final String DIALOG_TYPE = "publishreport";

    public CmsPublishQueueLiveReportDialog(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsPublishQueueLiveReportDialog(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void displayReport() throws JspException {
        this.getJsp().getRequest().setAttribute("__CmsWorkplace.WORKPLACE_CLASS", (Object)this);
        switch (this.getAction()) {
            case 4: 
            case 92: {
                this.actionCloseDialog();
                break;
            }
            case 91: {
                this.setParamAction("reportupdate");
                this.getJsp().include("/system/workplace/commons/includes/report.jsp");
                break;
            }
            default: {
                CmsPublishJobRunning publishJob = OpenCms.getPublishManager().getCurrentPublishJob();
                if (publishJob != null) {
                    this.setParamAction("reportupdate");
                    this.setParamThread(publishJob.getThreadUUID().toString());
                    this.setParamThreadHasNext(CmsStringUtil.FALSE);
                } else {
                    this.setParamAction("reportend");
                }
                this.getJsp().include("/system/workplace/commons/includes/report.jsp");
            }
        }
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        CmsPublishJobRunning publishJob;
        this.fillParamValues(request);
        this.setParamDialogtype(DIALOG_TYPE);
        try {
            publishJob = OpenCms.getPublishManager().getCurrentPublishJob();
            if (publishJob == null) {
                throw new Exception();
            }
            if (!OpenCms.getRoleManager().hasRole(this.getCms(), CmsRole.ROOT_ADMIN) && !publishJob.getUserId().equals((Object)this.getCms().getRequestContext().currentUser().getId())) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            this.setAction(4);
            try {
                this.actionCloseDialog();
            }
            catch (JspException e1) {
                // empty catch block
            }
            return;
        }
        if ("reportupdate".equals(this.getParamAction())) {
            this.setAction(91);
        } else if ("reportbegin".equals(this.getParamAction())) {
            this.setAction(90);
        } else if ("reportend".equals(this.getParamAction())) {
            this.setAction(92);
        } else if ("cancel".equals(this.getParamAction())) {
            this.setAction(4);
        } else {
            this.setAction(0);
            publishJob = OpenCms.getPublishManager().getCurrentPublishJob();
            if (publishJob.isDirectPublish()) {
                this.setDialogTitle("GUI_PUBLISH_RESOURCE_1", "GUI_PUBLISH_MULTI_2");
            } else {
                this.setParamTitle(this.key("GUI_PUBLISH_PROJECT_0"));
            }
        }
    }
}

