/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.publishqueue;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.publish.CmsPublishJobFinished;
import org.opencms.security.CmsRole;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.list.A_CmsListDialog;
import org.opencms.workplace.list.CmsListColumnAlignEnum;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListDateMacroFormatter;
import org.opencms.workplace.list.CmsListDefaultAction;
import org.opencms.workplace.list.CmsListDirectAction;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListOrderEnum;
import org.opencms.workplace.list.I_CmsListDirectAction;
import org.opencms.workplace.list.I_CmsListFormatter;
import org.opencms.workplace.tools.publishqueue.Messages;

public class CmsPublishQueuePersonalList
extends A_CmsListDialog {
    public static final String LIST_ACTION_COUNT = "ac";
    public static final String LIST_ACTION_END = "ae";
    public static final String LIST_ACTION_PROJECT = "ap";
    public static final String LIST_ACTION_START = "as";
    public static final String LIST_ACTION_STATE_ERR = "ate";
    public static final String LIST_ACTION_STATE_OK = "ato";
    public static final String LIST_ACTION_VIEW = "av";
    public static final String LIST_ID = "lppq";
    private static final String LIST_ACTION_USER = "au";
    private static final String LIST_COLUMN_ENDTIME = "ce";
    private static final String LIST_COLUMN_ERRORS = "cse";
    private static final String LIST_COLUMN_ID = "ci";
    private static final String LIST_COLUMN_PROJECT = "cp";
    private static final String LIST_COLUMN_RESCOUNT = "cr";
    private static final String LIST_COLUMN_STARTTIME = "cs";
    private static final String LIST_COLUMN_STATE = "ct";
    private static final String LIST_COLUMN_STATE_ICON = "csi";
    private static final String LIST_COLUMN_USER = "cu";
    private static final String LIST_COLUMN_VIEW = "cv";
    private static final String LIST_COLUMN_WARNINGS = "csw";
    private static final Log LOG = CmsLog.getLog((Object)CmsPublishQueuePersonalList.class);
    private static final String PUBLISHQUEUE_ERROR_ICON = "tools/publishqueue/buttons/state_error.png";
    private static final String PUBLISHQUEUE_OK_ICON = "tools/publishqueue/buttons/state_ok.png";
    private static final String PUBLISHQUEUE_VIEW_BUTTON = "tools/publishqueue/buttons/publish_view.png";
    private static final String PUBLISHQUEUE_WARN_ICON = "tools/publishqueue/buttons/state_warning.png";
    private static final String STATE_ERROR = "error";
    private static final String STATE_OK = "ok";
    private static final String STATE_WARNING = "warning";

    public CmsPublishQueuePersonalList(CmsJspActionElement jsp) {
        this(jsp, LIST_ID);
    }

    public CmsPublishQueuePersonalList(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    protected CmsPublishQueuePersonalList(CmsJspActionElement jsp, String listId) {
        super(jsp, listId, Messages.get().container("GUI_PERSONALQUEUE_LIST_NAME_0"), LIST_COLUMN_STARTTIME, CmsListOrderEnum.ORDER_DESCENDING, null);
    }

    public String defaultActionHtmlStart() {
        return this.getList().listJs() + this.dialogContentStart(this.getParamTitle());
    }

    public void executeListMultiActions() throws CmsRuntimeException {
        this.throwListUnsupportedActionException();
    }

    public void executeListSingleActions() throws IOException, ServletException, CmsRuntimeException {
        String publishJobId = this.getSelectedItem().get(LIST_COLUMN_ID).toString();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", publishJobId);
        params.put("action", "initial");
        if (this.getParamListAction().equals(LIST_ACTION_COUNT) || this.getParamListAction().equals(LIST_ACTION_END) || this.getParamListAction().equals(LIST_ACTION_START) || this.getParamListAction().equals(LIST_ACTION_STATE_OK) || this.getParamListAction().equals(LIST_ACTION_STATE_ERR) || this.getParamListAction().equals(LIST_ACTION_USER) || this.getParamListAction().equals(LIST_ACTION_PROJECT) || this.getParamListAction().equals(LIST_ACTION_VIEW)) {
            this.getToolManager().jspForwardTool((CmsWorkplace)this, this.getCurrentToolPath() + "/view", params);
        } else {
            this.throwListUnsupportedActionException();
        }
        this.listSave();
    }

    protected void fillDetails(String detailId) {
    }

    protected List getListItems() {
        ArrayList<CmsListItem> ret = new ArrayList<CmsListItem>();
        List queue = OpenCms.getRoleManager().hasRole(this.getCms(), CmsRole.ROOT_ADMIN) ? OpenCms.getPublishManager().getPublishHistory() : OpenCms.getPublishManager().getPublishHistory(this.getCms().getRequestContext().currentUser());
        Iterator iter = queue.iterator();
        while (iter.hasNext()) {
            CmsPublishJobFinished publishJob = (CmsPublishJobFinished)iter.next();
            CmsListItem item = this.getList().newItem(new Long(publishJob.getStartTime()).toString());
            Map state = this.getState(publishJob);
            item.set(LIST_COLUMN_PROJECT, (Object)publishJob.getProjectName());
            item.set(LIST_COLUMN_STARTTIME, (Object)new Date(publishJob.getStartTime()));
            item.set(LIST_COLUMN_ENDTIME, (Object)new Date(publishJob.getFinishTime()));
            item.set(LIST_COLUMN_STATE, state.get(LIST_COLUMN_STATE));
            item.set(LIST_COLUMN_RESCOUNT, (Object)new Integer(publishJob.getSize()));
            item.set(LIST_COLUMN_ID, (Object)publishJob.getPublishHistoryId());
            item.set(LIST_COLUMN_USER, (Object)publishJob.getUserName(this.getCms()));
            item.set(LIST_COLUMN_WARNINGS, state.get(LIST_COLUMN_WARNINGS));
            item.set(LIST_COLUMN_ERRORS, state.get(LIST_COLUMN_ERRORS));
            ret.add(item);
        }
        this.getList().getMetadata().getColumnDefinition(LIST_COLUMN_USER).setVisible(OpenCms.getRoleManager().hasRole(this.getCms(), CmsRole.PROJECT_MANAGER));
        return ret;
    }

    protected void setColumns(CmsListMetadata metadata) {
        CmsListColumnDefinition viewCol = new CmsListColumnDefinition(LIST_COLUMN_VIEW);
        viewCol.setName(Messages.get().container("GUI_PERSONALQUEUE_COLS_VIEW_0"));
        viewCol.setWidth("20");
        viewCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        viewCol.setSorteable(false);
        CmsListDirectAction viewAction = new CmsListDirectAction(LIST_ACTION_VIEW);
        viewAction.setName(Messages.get().container("GUI_PERSONALQUEUE_ACTION_VIEW_NAME_0"));
        viewAction.setHelpText(Messages.get().container("GUI_PERSONALQUEUE_ACTION_VIEW_HELP_0"));
        viewAction.setIconPath(PUBLISHQUEUE_VIEW_BUTTON);
        viewCol.addDirectAction((I_CmsListDirectAction)viewAction);
        metadata.addColumn(viewCol);
        CmsListColumnDefinition stateIconCol = new CmsListColumnDefinition(LIST_COLUMN_STATE_ICON);
        stateIconCol.setName(Messages.get().container("GUI_PERSONALQUEUE_COLS_STATE_0"));
        stateIconCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        stateIconCol.setWidth("20");
        CmsListDirectAction stateAction = new CmsListDirectAction(LIST_ACTION_STATE_OK){

            public boolean isVisible() {
                String state = (String)this.getItem().get(CmsPublishQueuePersonalList.LIST_COLUMN_STATE);
                return CmsPublishQueuePersonalList.STATE_OK.equals(state);
            }
        };
        stateAction.setName(Messages.get().container("GUI_PUBLISH_JOB_FINISHED_0"));
        stateAction.setHelpText(Messages.get().container("GUI_PERSONALQUEUE_ACTION_VIEW_HELP_0"));
        stateAction.setIconPath(PUBLISHQUEUE_OK_ICON);
        stateIconCol.addDirectAction((I_CmsListDirectAction)stateAction);
        CmsListDirectAction stateErrAction = new CmsListDirectAction(LIST_ACTION_STATE_ERR){

            public String getIconPath() {
                String state = (String)this.getItem().get(CmsPublishQueuePersonalList.LIST_COLUMN_STATE);
                if (CmsPublishQueuePersonalList.STATE_ERROR.equals(state)) {
                    return CmsPublishQueuePersonalList.PUBLISHQUEUE_ERROR_ICON;
                }
                return CmsPublishQueuePersonalList.PUBLISHQUEUE_WARN_ICON;
            }

            public CmsMessageContainer getName() {
                Integer warns = (Integer)this.getItem().get(CmsPublishQueuePersonalList.LIST_COLUMN_WARNINGS);
                Integer errors = (Integer)this.getItem().get(CmsPublishQueuePersonalList.LIST_COLUMN_ERRORS);
                return Messages.get().container("GUI_PUBLISH_JOB_FINISHED_WITH_WARNS_2", (Object)warns, (Object)errors);
            }

            public boolean isVisible() {
                String state = (String)this.getItem().get(CmsPublishQueuePersonalList.LIST_COLUMN_STATE);
                return !CmsPublishQueuePersonalList.STATE_OK.equals(state);
            }
        };
        stateErrAction.setHelpText(Messages.get().container("GUI_PERSONALQUEUE_ACTION_VIEW_HELP_0"));
        stateIconCol.addDirectAction((I_CmsListDirectAction)stateErrAction);
        metadata.addColumn(stateIconCol);
        CmsListColumnDefinition projectCol = new CmsListColumnDefinition(LIST_COLUMN_PROJECT);
        projectCol.setName(Messages.get().container("GUI_PERSONALQUEUE_COLS_PROJECT_0"));
        projectCol.setAlign(CmsListColumnAlignEnum.ALIGN_LEFT);
        projectCol.setWidth("30%");
        CmsListDefaultAction projectAction = new CmsListDefaultAction(LIST_ACTION_PROJECT);
        projectAction.setName(Messages.get().container("GUI_PERSONALQUEUE_ACTION_VIEW_NAME_0"));
        projectAction.setHelpText(Messages.get().container("GUI_PERSONALQUEUE_ACTION_VIEW_HELP_0"));
        projectCol.addDefaultAction(projectAction);
        metadata.addColumn(projectCol);
        CmsListColumnDefinition startCol = new CmsListColumnDefinition(LIST_COLUMN_STARTTIME);
        startCol.setName(Messages.get().container("GUI_PERSONALQUEUE_COLS_STARTPUBLISHING_0"));
        startCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        startCol.setFormatter((I_CmsListFormatter)new CmsListDateMacroFormatter(Messages.get().container("GUI_LIST_DATE_FORMAT_WITH_SECONDS_1"), Messages.get().container("GUI_LIST_DATE_FORMAT_NEVER_0")));
        startCol.setWidth("20%");
        CmsListDefaultAction startAction = new CmsListDefaultAction(LIST_ACTION_START);
        startAction.setName(Messages.get().container("GUI_PERSONALQUEUE_ACTION_VIEW_NAME_0"));
        startAction.setHelpText(Messages.get().container("GUI_PERSONALQUEUE_ACTION_VIEW_HELP_0"));
        startCol.addDefaultAction(startAction);
        metadata.addColumn(startCol);
        CmsListColumnDefinition endCol = new CmsListColumnDefinition(LIST_COLUMN_ENDTIME);
        endCol.setName(Messages.get().container("GUI_PERSONALQUEUE_COLS_STOPPUBLISHING_0"));
        endCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        endCol.setFormatter((I_CmsListFormatter)new CmsListDateMacroFormatter(Messages.get().container("GUI_LIST_DATE_FORMAT_WITH_SECONDS_1"), Messages.get().container("GUI_LIST_DATE_FORMAT_NEVER_0")));
        endCol.setWidth("20%");
        CmsListDefaultAction endAction = new CmsListDefaultAction(LIST_ACTION_END);
        endAction.setName(Messages.get().container("GUI_PERSONALQUEUE_ACTION_VIEW_NAME_0"));
        endAction.setHelpText(Messages.get().container("GUI_PERSONALQUEUE_ACTION_VIEW_HELP_0"));
        endCol.addDefaultAction(endAction);
        metadata.addColumn(endCol);
        CmsListColumnDefinition userCol = new CmsListColumnDefinition(LIST_COLUMN_USER);
        userCol.setName(Messages.get().container("GUI_PERSONALQUEUE_COLS_USER_0"));
        userCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        userCol.setWidth("25%");
        CmsListDefaultAction userAction = new CmsListDefaultAction(LIST_ACTION_USER);
        userAction.setName(Messages.get().container("GUI_PERSONALQUEUE_ACTION_VIEW_NAME_0"));
        userAction.setHelpText(Messages.get().container("GUI_PERSONALQUEUE_ACTION_VIEW_HELP_0"));
        userCol.addDefaultAction(userAction);
        metadata.addColumn(userCol);
        CmsListColumnDefinition countCol = new CmsListColumnDefinition(LIST_COLUMN_RESCOUNT);
        countCol.setName(Messages.get().container("GUI_PERSONALQUEUE_COLS_RESCOUNT_0"));
        countCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        countCol.setWidth("5%");
        CmsListDefaultAction countAction = new CmsListDefaultAction(LIST_ACTION_COUNT);
        countAction.setName(Messages.get().container("GUI_PERSONALQUEUE_ACTION_VIEW_NAME_0"));
        countAction.setHelpText(Messages.get().container("GUI_PERSONALQUEUE_ACTION_VIEW_HELP_0"));
        countCol.addDefaultAction(countAction);
        metadata.addColumn(countCol);
        CmsListColumnDefinition idCol = new CmsListColumnDefinition(LIST_COLUMN_ID);
        idCol.setName(Messages.get().container("GUI_PERSONALQUEUE_COLS_ID_0"));
        idCol.setSorteable(false);
        idCol.setVisible(false);
        metadata.addColumn(idCol);
        CmsListColumnDefinition errCol = new CmsListColumnDefinition(LIST_COLUMN_ERRORS);
        errCol.setVisible(false);
        metadata.addColumn(errCol);
        CmsListColumnDefinition warnCol = new CmsListColumnDefinition(LIST_COLUMN_WARNINGS);
        warnCol.setVisible(false);
        metadata.addColumn(warnCol);
        CmsListColumnDefinition stateCol = new CmsListColumnDefinition(LIST_COLUMN_STATE);
        stateCol.setVisible(false);
        metadata.addColumn(stateCol);
    }

    protected void setIndependentActions(CmsListMetadata metadata) {
    }

    protected void setMultiActions(CmsListMetadata metadata) {
    }

    private Map getState(CmsPublishJobFinished publishJob) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        byte[] reportBytes = null;
        try {
            reportBytes = OpenCms.getPublishManager().getReportContents(publishJob);
        }
        catch (CmsException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e.getLocalizedMessage());
            }
            result.put(LIST_COLUMN_STATE, STATE_OK);
        }
        if (reportBytes != null && result.get(LIST_COLUMN_STATE) == null) {
            String report = new String(reportBytes);
            if (report.indexOf("<span class='err'>") > -1) {
                result.put(LIST_COLUMN_STATE, STATE_ERROR);
                result.put(LIST_COLUMN_ERRORS, new Integer(CmsStringUtil.splitAsList((String)report, (String)"<span class='err'>").size() - 1));
                result.put(LIST_COLUMN_WARNINGS, new Integer(CmsStringUtil.splitAsList((String)report, (String)"<span class='warn'>").size() - 1));
            } else if (report.indexOf("<span class='warn'>") > -1) {
                result.put(LIST_COLUMN_STATE, STATE_WARNING);
                result.put(LIST_COLUMN_WARNINGS, new Integer(CmsStringUtil.splitAsList((String)report, (String)"<span class='warn'>").size() - 1));
            } else {
                result.put(LIST_COLUMN_STATE, STATE_OK);
            }
        }
        if (result.get(LIST_COLUMN_WARNINGS) == null) {
            result.put(LIST_COLUMN_WARNINGS, new Integer(0));
        }
        if (result.get(LIST_COLUMN_ERRORS) == null) {
            result.put(LIST_COLUMN_ERRORS, new Integer(0));
        }
        return result;
    }
}

