/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.editors.fckeditor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsHtmlConverter;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.editors.CmsEditorDisplayOptions;
import org.opencms.workplace.editors.CmsSimplePageEditor;
import org.opencms.workplace.editors.Messages;
import org.opencms.workplace.galleries.A_CmsGallery;

public class CmsFCKEditor
extends CmsSimplePageEditor {
    public static final String SUFFIX_STYLESXML = "_style.xml";
    private static final String EDITOR_TYPE = "fckeditor";

    public CmsFCKEditor(CmsJspActionElement jsp) {
        super(jsp);
    }

    public String buildGalleryButtonRow(CmsEditorDisplayOptions options, Properties displayOptions) {
        StringBuffer result = new StringBuffer();
        Map galleryMap = OpenCms.getWorkplaceManager().getGalleries();
        ArrayList<A_CmsGallery> galleries = new ArrayList<A_CmsGallery>(galleryMap.size());
        HashMap<A_CmsGallery, String> typeMap = new HashMap<A_CmsGallery, String>(galleryMap.size());
        Iterator i = galleryMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String key = (String)entry.getKey();
            A_CmsGallery currGallery = (A_CmsGallery)entry.getValue();
            galleries.add(currGallery);
            typeMap.put(currGallery, key);
        }
        Collections.sort(galleries);
        for (int k = 0; k < galleries.size(); ++k) {
            A_CmsGallery currGallery = (A_CmsGallery)galleries.get(k);
            String galleryType = (String)typeMap.get(currGallery);
            if (!options.showElement("gallery." + CmsStringUtil.substitute((String)galleryType, (String)"gallery", (String)""), displayOptions)) continue;
            if (result.length() == 0) {
                result.append(", '-'");
            }
            result.append(", 'oc-" + galleryType + "'");
        }
        return result.toString();
    }

    public String buildGalleryButtons(CmsEditorDisplayOptions options, int buttonStyle, Properties displayOptions) {
        StringBuffer result = new StringBuffer(1024);
        Iterator i = OpenCms.getWorkplaceManager().getGalleries().keySet().iterator();
        while (i.hasNext()) {
            String galleryType = (String)i.next();
            String galleryName = CmsStringUtil.substitute((String)galleryType, (String)"gallery", (String)"");
            result.append("\n\nvar ").append(galleryType).append("Command = function() { this.Name = \"").append(galleryType).append("\"; }\n");
            result.append(galleryType).append("Command.prototype.GetState = function() { return FCK_TRISTATE_OFF ; }\n");
            result.append(galleryType).append("Command.prototype.Execute = function() {\n");
            result.append("\topenGallery(\"").append(galleryType).append("\");\n");
            result.append("}\n");
            result.append("FCKCommands.RegisterCommand(\"oc-").append(galleryType).append("\", new ").append(galleryType).append("Command());\n");
            result.append("FCKToolbarItems.RegisterItem(\"oc-").append(galleryType).append("\", ");
            result.append("new FCKToolbarButton(\"oc-").append(galleryType).append("\", \"");
            result.append(this.key(Messages.getGalleryKey((String)galleryName))).append("\"));");
        }
        return result.toString();
    }

    public String getEditorResourceUri() {
        return CmsFCKEditor.getSkinUri() + "editors/" + EDITOR_TYPE + "/";
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        if (CmsStringUtil.isNotEmpty((String)request.getParameter("resource"))) {
            super.initWorkplaceRequestValues(settings, request);
        }
    }

    protected String prepareContent(boolean save) {
        String conversionSetting;
        if (save && CmsStringUtil.isEmptyOrWhitespaceOnly((String)(conversionSetting = CmsHtmlConverter.getConversionSettings((CmsObject)this.getCms(), (CmsResource)this.m_file)))) {
            String content = this.getParamContent();
            CmsHtmlConverter converter = new CmsHtmlConverter(this.getEncoding(), "xhtml");
            content = converter.convertToStringSilent(content);
            this.setParamContent(content);
        }
        return super.prepareContent(true);
    }
}

