/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.editors.fckeditor;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.editors.fckeditor.Messages;
import org.opencms.file.CmsResource;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.loader.CmsImageScaler;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsDialog;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.galleries.A_CmsGallery;
import org.opencms.workplace.galleries.CmsImageGallery;

public class CmsFCKEditorDialogImage
extends CmsDialog {
    public static final String DIALOG_GETACTIVEIMAGE = "getactiveimage";
    public static final String DIALOG_GETGALLERIES = "getgalleries";
    public static final String PARAM_IMGURL = "imgurl";
    public static final String PROPERTY_COPYRIGHT = "Copyright";
    public static final String RETURNVALUE_NONE = "none";
    private static final Log LOG = CmsLog.getLog((Object)CmsFCKEditorDialogImage.class);
    private CmsImageGallery m_gallery;
    private String m_paramImgUrl;

    public CmsFCKEditorDialogImage(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsFCKEditorDialogImage(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void displayDialog() {
        if (DIALOG_GETGALLERIES.equals(this.getParamAction())) {
            this.buildHtmlGallerySelectBox();
        } else if ("list".equals(this.getParamAction())) {
            this.buildJSGalleryItems();
        } else if (DIALOG_GETACTIVEIMAGE.equals(this.getParamAction())) {
            this.buildJSActiveImage();
        }
    }

    public CmsImageGallery getImageGallery() {
        if (this.m_gallery == null) {
            A_CmsGallery aGallery = A_CmsGallery.createInstance((String)"imagegallery", (CmsJspActionElement)this.getJsp());
            this.m_gallery = (CmsImageGallery)aGallery;
        }
        return this.m_gallery;
    }

    public String getParamImgUrl() {
        return this.m_paramImgUrl;
    }

    public void setParamImgUrl(String paramImgUrl) {
        this.m_paramImgUrl = paramImgUrl;
    }

    protected void buildHtmlGallerySelectBox() {
        block2: {
            JspWriter out = this.getJsp().getJspContext().getOut();
            try {
                out.print(this.getImageGallery().buildGallerySelectBox());
            }
            catch (IOException e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error((Object)Messages.get().getBundle().key("LOG_ERR_WRITE_OUT_0"), (Throwable)e);
            }
        }
    }

    protected void buildJSActiveImage() {
        block8: {
            JspWriter out = this.getJsp().getJspContext().getOut();
            String imgUrl = this.getParamImgUrl();
            if (imgUrl.startsWith(OpenCms.getSiteManager().getWorkplaceServer())) {
                imgUrl = imgUrl.substring(OpenCms.getSiteManager().getWorkplaceServer().length());
            }
            if (imgUrl.startsWith(OpenCms.getSystemInfo().getOpenCmsContext())) {
                imgUrl = imgUrl.substring(OpenCms.getSystemInfo().getOpenCmsContext().length());
            }
            try {
                if (this.getCms().existsResource(imgUrl)) {
                    try {
                        out.print("activeImage = ");
                        out.print((Object)this.buildJSImageObject(this.getCms().readResource(imgUrl)));
                    }
                    catch (CmsException e) {}
                } else {
                    out.print(RETURNVALUE_NONE);
                }
            }
            catch (IOException e) {
                if (!LOG.isErrorEnabled()) break block8;
                LOG.error((Object)Messages.get().getBundle().key("LOG_ERR_WRITE_OUT_0"), (Throwable)e);
            }
        }
    }

    protected void buildJSGalleryItems() {
        block3: {
            JspWriter out = this.getJsp().getJspContext().getOut();
            List items = this.getImageGallery().getGalleryItems();
            Iterator i = items.iterator();
            try {
                while (i.hasNext()) {
                    CmsResource res = (CmsResource)i.next();
                    out.print("gItems[gItems.length] = ");
                    out.print((Object)this.buildJSImageObject(res));
                }
            }
            catch (IOException e) {
                if (!LOG.isErrorEnabled()) break block3;
                LOG.error((Object)Messages.get().getBundle().key("LOG_ERR_WRITE_OUT_0"), (Throwable)e);
            }
        }
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.fillParamValues(request);
    }

    private StringBuffer buildJSImageObject(CmsResource res) {
        StringBuffer result = new StringBuffer(512);
        String sitePath = this.getCms().getRequestContext().getSitePath(res);
        OpenCms.getSystemInfo().getOpenCmsContext();
        CmsImageScaler scaler = new CmsImageScaler(this.getCms(), res);
        result.append("new ImgFile(");
        result.append("'");
        result.append(sitePath);
        result.append("', ");
        result.append("'");
        result.append(this.getJsp().link(sitePath));
        result.append("', ");
        result.append("'");
        String scaleParams = "";
        if (this.getImageGallery().getDefaultScaleParams() != null) {
            scaleParams = this.getImageGallery().getDefaultScaleParams().toRequestParam();
        }
        result.append(this.getJsp().link(sitePath + scaleParams));
        result.append("', ");
        result.append("'");
        result.append(CmsStringUtil.escapeJavaScript((String)this.getJsp().property("Title", sitePath, res.getName())));
        result.append("', ");
        result.append("'");
        if (scaler.isValid()) {
            result.append(scaler.getWidth());
        } else {
            result.append("?");
        }
        result.append("', ");
        result.append("'");
        if (scaler.isValid()) {
            result.append(scaler.getHeight());
        } else {
            result.append("?");
        }
        result.append("', ");
        result.append("'");
        result.append(res.getLength() / 1024);
        result.append(" ");
        result.append(this.key("GUI_LABEL_KILOBYTES_0"));
        result.append("', ");
        result.append("'");
        result.append(this.getMessages().getDateTime(res.getDateCreated()));
        result.append("', ");
        result.append("'");
        result.append(this.getMessages().getDateTime(res.getDateLastModified()));
        result.append("', ");
        result.append("'");
        result.append(res.getStructureId());
        result.append("', ");
        result.append("'");
        String type = "";
        int dotIndex = res.getName().lastIndexOf(46);
        if (dotIndex != -1) {
            type = res.getName().substring(dotIndex + 1).toLowerCase();
        }
        result.append(type);
        result.append("', ");
        result.append("'");
        result.append(res.getStructureId().hashCode());
        result.append("', ");
        result.append(res.getState());
        String copyright = this.getJsp().property(PROPERTY_COPYRIGHT, sitePath, null);
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)copyright)) {
            result.append(", '");
            result.append(CmsStringUtil.escapeJavaScript((String)copyright));
            result.append("'");
        }
        result.append(");\n");
        return result;
    }
}

