/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.editors.fckeditor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.fileupload.FileItem;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.opencms.db.CmsDbSqlException;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceAlreadyExistsException;
import org.opencms.file.types.CmsResourceTypeImage;
import org.opencms.flex.CmsFlexController;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPermissionViolationException;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsDialog;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.xml.CmsXmlUtils;

public class CmsFCKEditorFileBrowser
extends CmsDialog {
    public static final int ACTION_CREATEFOLDER = 502;
    public static final int ACTION_FILEUPLOAD = 503;
    public static final int ACTION_GETFOLDERS = 500;
    public static final int ACTION_GETFOLDERS_FILES = 501;
    public static final String ATTR_COMMAND = "command";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_NUMBER = "number";
    public static final String ATTR_PATH = "path";
    public static final String ATTR_RESOURCETYPE = "resourceType";
    public static final String ATTR_SIZE = "size";
    public static final String ATTR_URL = "url";
    public static final String COMMAND_CREATEFOLDER = "CreateFolder";
    public static final String COMMAND_FILEUPLOAD = "FileUpload";
    public static final String COMMAND_GETFOLDERS = "GetFolders";
    public static final String COMMAND_GETFOLDERS_FILES = "GetFoldersAndFiles";
    public static final String CONTENTTYPE_HTML = "text/html";
    public static final String CONTENTTYPE_XML = "text/xml";
    public static final String DIALOG_TYPE = "FCKeditor_file_browser";
    public static final String ERROR_CREATEFOLDER_EXISTS = "101";
    public static final String ERROR_CREATEFOLDER_INVALIDNAME = "102";
    public static final String ERROR_CREATEFOLDER_NOPERMISSIONS = "103";
    public static final String ERROR_CREATEFOLDER_OK = "0";
    public static final String ERROR_CREATEFOLDER_UNKNOWNERROR = "110";
    public static final String ERROR_UPLOAD_INVALID = "202";
    public static final String ERROR_UPLOAD_OK = "0";
    public static final String NODE_CONNECTOR = "Connector";
    public static final String NODE_CURRENTFOLDER = "CurrentFolder";
    public static final String NODE_ERROR = "Error";
    public static final String NODE_FILE = "File";
    public static final String NODE_FILES = "Files";
    public static final String NODE_FOLDER = "Folder";
    public static final String NODE_FOLDERS = "Folders";
    public static final String PARAM_COMMAND = "Command";
    public static final String PARAM_CURRENTFOLDER = "CurrentFolder";
    public static final String PARAM_NEWFOLDERNAME = "NewFolderName";
    public static final String PARAM_SERVERPATH = "ServerPath";
    public static final String PARAM_TYPE = "Type";
    public static final String TYPE_FILE = "File";
    public static final String TYPE_FLASH = "Flash";
    public static final String TYPE_IMAGE = "Image";
    public static final String TYPE_MEDIA = "Media";
    private Document m_document;
    private List m_multiPartFileItems;
    private String m_paramCommand;
    private String m_paramCurrentFolder;
    private String m_paramNewFolderName;
    private String m_paramServerPath;
    private String m_paramType;

    public CmsFCKEditorFileBrowser(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsFCKEditorFileBrowser(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public String displayDialog() {
        switch (this.getAction()) {
            case 502: {
                return this.createFolder();
            }
            case 503: {
                return this.uploadFile();
            }
            case 500: {
                return this.getFolders(false);
            }
        }
        return this.getFolders(true);
    }

    public void fillParamValues(HttpServletRequest request) {
        if (null == request.getAttribute("__CmsWorkplace.MULTIPART")) {
            this.m_multiPartFileItems = CmsRequestUtil.readMultipartFileItems((HttpServletRequest)request);
            if (this.m_multiPartFileItems != null) {
                CmsRequestUtil.readParameterMapFromMultiPart((String)this.getCms().getRequestContext().getEncoding(), (List)this.m_multiPartFileItems);
                request.setAttribute("__CmsWorkplace.MULTIPART", (Object)Boolean.TRUE);
            }
        }
        this.setParamCommand(this.decodeParamValue(PARAM_COMMAND, request.getParameter(PARAM_COMMAND)));
        this.setParamCurrentFolder(this.decodeParamValue("CurrentFolder", request.getParameter("CurrentFolder")));
        this.setParamNewFolderName(this.decodeParamValue(PARAM_NEWFOLDERNAME, request.getParameter(PARAM_NEWFOLDERNAME)));
        this.setParamServerPath(this.decodeParamValue(PARAM_SERVERPATH, request.getParameter(PARAM_SERVERPATH)));
        this.setParamType(this.decodeParamValue(PARAM_TYPE, request.getParameter(PARAM_TYPE)));
    }

    public String getParamCommand() {
        return this.m_paramCommand;
    }

    public String getParamCurrentFolder() {
        return this.m_paramCurrentFolder;
    }

    public String getParamNewFolderName() {
        return this.m_paramNewFolderName;
    }

    public String getParamServerPath() {
        return this.m_paramServerPath;
    }

    public String getParamType() {
        return this.m_paramType;
    }

    public void setParamCommand(String paramCommand) {
        this.m_paramCommand = paramCommand;
    }

    public void setParamCurrentFolder(String paramCurrentFolder) {
        this.m_paramCurrentFolder = CmsStringUtil.isEmpty((String)paramCurrentFolder) ? "/" : paramCurrentFolder;
    }

    public void setParamNewFolderName(String paramNewFolderName) {
        this.m_paramNewFolderName = paramNewFolderName;
    }

    public void setParamServerPath(String paramServerPath) {
        this.m_paramServerPath = CmsStringUtil.isEmpty((String)paramServerPath) ? OpenCms.getSystemInfo().getOpenCmsContext() + this.getParamCurrentFolder() : OpenCms.getSystemInfo().getOpenCmsContext() + paramServerPath;
    }

    public void setParamType(String paramType) {
        this.m_paramType = CmsStringUtil.isEmpty((String)paramType) ? "" : paramType;
    }

    protected String createFolder() {
        this.createXMLHead();
        Element error = this.getDocument().getRootElement().addElement(NODE_ERROR);
        try {
            this.getCms().createResource(this.getParamCurrentFolder() + this.getParamNewFolderName(), 0);
            error.addAttribute(ATTR_NUMBER, "0");
        }
        catch (Exception e) {
            if (e instanceof CmsVfsResourceAlreadyExistsException) {
                error.addAttribute(ATTR_NUMBER, ERROR_CREATEFOLDER_EXISTS);
            }
            if (e instanceof CmsIllegalArgumentException) {
                error.addAttribute(ATTR_NUMBER, ERROR_CREATEFOLDER_INVALIDNAME);
            }
            if (e instanceof CmsPermissionViolationException) {
                error.addAttribute(ATTR_NUMBER, ERROR_CREATEFOLDER_NOPERMISSIONS);
            }
            error.addAttribute(ATTR_NUMBER, ERROR_CREATEFOLDER_UNKNOWNERROR);
        }
        try {
            return CmsXmlUtils.marshal((Document)this.getDocument(), (String)"UTF-8");
        }
        catch (CmsException e) {
            return "";
        }
    }

    protected void createXMLHead() {
        Element connector = this.getDocument().addElement(NODE_CONNECTOR);
        connector.addAttribute(ATTR_COMMAND, this.getParamCommand());
        connector.addAttribute(ATTR_RESOURCETYPE, this.getParamType());
        Element currFolder = connector.addElement("CurrentFolder");
        currFolder.addAttribute(ATTR_PATH, this.getParamCurrentFolder());
        currFolder.addAttribute(ATTR_URL, this.getParamServerPath());
    }

    protected Document getDocument() {
        if (this.m_document == null) {
            this.m_document = DocumentHelper.createDocument();
        }
        return this.m_document;
    }

    protected String getFolders(boolean includeFiles) {
        CmsResourceFilter filter;
        this.createXMLHead();
        Element folders = this.getDocument().getRootElement().addElement(NODE_FOLDERS);
        Element files = null;
        if (includeFiles) {
            filter = CmsResourceFilter.DEFAULT.addRequireVisible();
            files = this.getDocument().getRootElement().addElement(NODE_FILES);
        } else {
            filter = CmsResourceFilter.DEFAULT_FOLDERS.addRequireVisible();
        }
        try {
            List resources = this.getCms().readResources(this.getParamCurrentFolder(), filter, false);
            Iterator i = resources.iterator();
            while (i.hasNext()) {
                CmsResource res = (CmsResource)i.next();
                if (res.isFolder()) {
                    Element folder = folders.addElement(NODE_FOLDER);
                    String folderName = CmsResource.getName((String)res.getRootPath());
                    folderName = CmsStringUtil.substitute((String)folderName, (String)"/", (String)"");
                    folder.addAttribute(ATTR_NAME, folderName);
                    continue;
                }
                boolean showFile = true;
                if (TYPE_IMAGE.equals(this.getParamType())) {
                    boolean bl = showFile = res.getTypeId() == CmsResourceTypeImage.getStaticTypeId();
                }
                if (!showFile || files == null) continue;
                Element file = files.addElement("File");
                file.addAttribute(ATTR_NAME, CmsResource.getName((String)res.getRootPath()));
                file.addAttribute(ATTR_SIZE, "" + res.getLength() / 1024);
            }
            return CmsXmlUtils.marshal((Document)this.getDocument(), (String)"UTF-8");
        }
        catch (CmsException e) {
            return "";
        }
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.fillParamValues(request);
        this.setParamDialogtype(DIALOG_TYPE);
        if (COMMAND_FILEUPLOAD.equals(this.getParamCommand())) {
            this.setAction(503);
        } else if (COMMAND_CREATEFOLDER.equals(this.getParamCommand())) {
            this.setAction(502);
        } else if (COMMAND_GETFOLDERS.equals(this.getParamCommand())) {
            this.setAction(500);
        } else {
            this.setAction(501);
        }
        CmsFlexController controller = CmsFlexController.getController((ServletRequest)this.getJsp().getRequest());
        HttpServletResponse res = controller.getTopResponse();
        CmsRequestUtil.setNoCacheHeaders((HttpServletResponse)res);
        String contentType = CONTENTTYPE_XML;
        if (this.getAction() == 503) {
            contentType = CONTENTTYPE_HTML;
        }
        res.setContentType(contentType);
    }

    protected String uploadFile() {
        String errorCode;
        block13: {
            errorCode = "0";
            try {
                Iterator i = this.m_multiPartFileItems.iterator();
                FileItem fi = null;
                while (i.hasNext() && (fi = (FileItem)i.next()).getName() == null) {
                }
                if (fi != null) {
                    String newResname;
                    String fileName = fi.getName();
                    long size = fi.getSize();
                    long maxFileSizeBytes = OpenCms.getWorkplaceManager().getFileBytesMaxUploadSize(this.getCms());
                    if (maxFileSizeBytes > 0L && size > maxFileSizeBytes) {
                        throw new Exception();
                    }
                    byte[] content = fi.get();
                    fi.delete();
                    String title = newResname = CmsResource.getName((String)fileName.replace('\\', '/'));
                    if (title.lastIndexOf(46) != -1) {
                        title = title.substring(0, title.lastIndexOf(46));
                    }
                    ArrayList<CmsProperty> properties = new ArrayList<CmsProperty>(1);
                    CmsProperty titleProp = new CmsProperty();
                    titleProp.setName("Title");
                    if (OpenCms.getWorkplaceManager().isDefaultPropertiesOnStructure()) {
                        titleProp.setStructureValue(title);
                    } else {
                        titleProp.setResourceValue(title);
                    }
                    properties.add(titleProp);
                    int resTypeId = OpenCms.getResourceManager().getDefaultTypeForName(newResname).getTypeId();
                    newResname = this.getParamCurrentFolder() + newResname;
                    if (!this.getCms().existsResource(newResname, CmsResourceFilter.IGNORE_EXPIRATION)) {
                        try {
                            this.getCms().createResource(newResname, resTypeId, content, properties);
                            break block13;
                        }
                        catch (CmsDbSqlException sqlExc) {
                            this.getCms().lockResource(newResname);
                            this.getCms().deleteResource(newResname, CmsResource.DELETE_PRESERVE_SIBLINGS);
                            throw sqlExc;
                        }
                    }
                    this.checkLock(newResname);
                    CmsFile file = this.getCms().readFile(newResname, CmsResourceFilter.IGNORE_EXPIRATION);
                    byte[] contents = file.getContents();
                    try {
                        this.getCms().replaceResource(newResname, resTypeId, content, null);
                        break block13;
                    }
                    catch (CmsDbSqlException sqlExc) {
                        file.setContents(contents);
                        this.getCms().writeFile(file);
                        throw sqlExc;
                    }
                }
                throw new Exception();
            }
            catch (Throwable e) {
                errorCode = ERROR_UPLOAD_INVALID;
            }
        }
        StringBuffer result = new StringBuffer(256);
        result.append("<html><head><script type=\"text/javascript\">\n");
        result.append("window.parent.frames[\"frmUpload\"].OnUploadCompleted(");
        result.append(errorCode);
        result.append(");\n");
        result.append("</script></head></html>");
        return result.toString();
    }
}

