/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.editors.fckeditor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsEncoder;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.A_CmsHtmlWidget;
import org.opencms.widgets.CmsHtmlWidgetOption;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.widgets.I_CmsWidgetDialog;
import org.opencms.widgets.I_CmsWidgetParameter;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.editors.I_CmsEditorCssHandler;
import org.opencms.workplace.galleries.A_CmsGallery;
import org.opencms.xml.types.I_CmsXmlContentValue;

public class CmsFCKEditorWidget
extends A_CmsHtmlWidget {
    public static final String PARAM_CONFIGURATION = "config";

    public CmsFCKEditorWidget() {
        this("");
    }

    public CmsFCKEditorWidget(CmsHtmlWidgetOption configuration) {
        super(configuration);
    }

    public CmsFCKEditorWidget(String configuration) {
        super(configuration);
    }

    public static boolean buildOpenCmsButtonRow(StringBuffer toolbar, String widgetOptionsString) {
        boolean buttonRendered = false;
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)widgetOptionsString)) {
            CmsHtmlWidgetOption option = new CmsHtmlWidgetOption(widgetOptionsString);
            StringBuffer custom = new StringBuffer(512);
            if (option.showSourceEditor()) {
                custom.append("\"Source\"");
                buttonRendered = true;
            }
            boolean showFormatSelect = false;
            if (option.showFormatSelect()) {
                if (buttonRendered) {
                    custom.append(",\"-\",");
                }
                custom.append("\"FontFormat\"");
                buttonRendered = true;
                showFormatSelect = true;
            }
            if (option.showStylesXml()) {
                if (!showFormatSelect && buttonRendered) {
                    custom.append(",\"-\",");
                } else if (buttonRendered) {
                    custom.append(",");
                }
                custom.append("\"Style\"");
                buttonRendered = true;
            }
            boolean showLink = false;
            if (option.showLinkDialog()) {
                if (buttonRendered) {
                    custom.append(",");
                }
                custom.append("\"oc-link\"");
                buttonRendered = true;
                showLink = true;
            }
            if (option.showAnchorDialog()) {
                if (buttonRendered) {
                    custom.append(",");
                }
                custom.append("\"Anchor\"");
                buttonRendered = true;
                showLink = true;
            }
            if (showLink) {
                custom.append(", \"Unlink\"");
            }
            Map galleryMap = OpenCms.getWorkplaceManager().getGalleries();
            ArrayList<A_CmsGallery> galleries = new ArrayList<A_CmsGallery>(galleryMap.size());
            HashMap<A_CmsGallery, String> typeMap = new HashMap<A_CmsGallery, String>(galleryMap.size());
            Iterator i = galleryMap.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                String key = (String)entry.getKey();
                A_CmsGallery currGallery = (A_CmsGallery)entry.getValue();
                galleries.add(currGallery);
                typeMap.put(currGallery, key);
            }
            Collections.sort(galleries);
            StringBuffer galleryResult = new StringBuffer(8);
            boolean showGallery = false;
            for (int k = 0; k < galleries.size(); ++k) {
                A_CmsGallery currGallery = (A_CmsGallery)galleries.get(k);
                String galleryType = (String)typeMap.get(currGallery);
                if (!option.getDisplayGalleries().contains(galleryType)) continue;
                if (galleryResult.length() > 0) {
                    galleryResult.append(", ");
                }
                galleryResult.append("\"oc-");
                galleryResult.append(galleryType);
                galleryResult.append("\"");
                showGallery = true;
            }
            if (showGallery) {
                if (buttonRendered) {
                    custom.append("],[");
                }
                custom.append(galleryResult);
                buttonRendered = true;
            }
            if (option.showImageDialog()) {
                if (buttonRendered) {
                    custom.append(",\"-\",");
                }
                custom.append("\"OcmsImage\"");
                buttonRendered = true;
            }
            if (option.showTableDialog()) {
                if (buttonRendered) {
                    custom.append(",\"-\",");
                }
                custom.append("\"Table\"");
                buttonRendered = true;
            }
            if (buttonRendered) {
                custom.insert(0, ",[");
                toolbar.append(custom);
            }
        }
        return buttonRendered;
    }

    protected static boolean showButton(String buttonName, List widgetOptions) {
        return widgetOptions.contains(buttonName);
    }

    public String getDialogIncludes(CmsObject cms, I_CmsWidgetDialog widgetDialog) {
        StringBuffer result = new StringBuffer(128);
        result.append(this.getJSIncludeFile(CmsWorkplace.getSkinUri() + "editors/fckeditor/fckeditor.js"));
        result.append("\n");
        result.append(this.getJSIncludeFile(CmsWorkplace.getSkinUri() + "components/widgets/fckeditor.js"));
        return result.toString();
    }

    public String getDialogInitCall(CmsObject cms, I_CmsWidgetDialog widgetDialog) {
        return "\tinitFCKeditor();\n";
    }

    public String getDialogInitMethod(CmsObject cms, I_CmsWidgetDialog widgetDialog) {
        StringBuffer result = new StringBuffer(64);
        result.append("function initFCKeditor() {\n");
        result.append("\tif (navigator.userAgent.toLowerCase().indexOf(\"msie\") != -1) {\n");
        result.append("\t\tsetTimeout(\"generateEditors();\", 50);\n");
        result.append("\t} else {");
        result.append("\t\tgenerateEditors();\n");
        result.append("\t}\n");
        result.append("}\n");
        return result.toString();
    }

    public String getDialogWidget(CmsObject cms, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        String id = param.getId();
        String value = param.getStringValue(cms);
        StringBuffer result = new StringBuffer(4096);
        result.append("<td class=\"xmlTd\">");
        result.append("<textarea class=\"xmlInput maxwidth\" name=\"ta_");
        result.append(id);
        result.append("\" id=\"ta_");
        result.append(id);
        result.append("\" style=\"height: ");
        result.append(this.getHtmlWidgetOption().getEditorHeight());
        result.append(";\" rows=\"20\" cols=\"60\">");
        result.append(CmsEncoder.escapeXml((String)value));
        result.append("</textarea>");
        result.append("<input type=\"hidden\" name=\"");
        result.append(id);
        result.append("\" id=\"");
        result.append(id);
        result.append("\" value=\"");
        result.append(CmsEncoder.encode((String)value));
        result.append("\">");
        result.append("<script type=\"text/javascript\">\n");
        result.append("var editor = new FCKeditor(\"ta_").append(id).append("\");\n");
        result.append("editor.BasePath = \"").append(CmsWorkplace.getSkinUri()).append("editors/fckeditor/\";\n");
        boolean cssConfigured = false;
        String cssPath = "";
        if (this.getHtmlWidgetOption().useCss()) {
            cssPath = this.getHtmlWidgetOption().getCssPath();
            this.getHtmlWidgetOption().setCssPath(null);
            cssConfigured = true;
        } else if (OpenCms.getWorkplaceManager().getEditorCssHandlers().size() > 0) {
            Iterator i = OpenCms.getWorkplaceManager().getEditorCssHandlers().iterator();
            try {
                I_CmsXmlContentValue contentValue = (I_CmsXmlContentValue)param;
                String editedResource = cms.getSitePath((CmsResource)contentValue.getDocument().getFile());
                while (i.hasNext()) {
                    I_CmsEditorCssHandler handler = (I_CmsEditorCssHandler)i.next();
                    if (!handler.matches(cms, editedResource)) continue;
                    cssPath = handler.getUriStyleSheet(cms, editedResource);
                    if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)cssPath)) {
                        cssConfigured = true;
                    }
                    break;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (cssConfigured) {
            result.append("editor.Config[\"EditorAreaCSS\"] = \"");
            result.append(OpenCms.getLinkManager().substituteLink(cms, cssPath));
            result.append("\";\n");
        }
        if (this.getHtmlWidgetOption().showStylesXml()) {
            result.append("editor.Config[\"StylesXmlPath\"] = \"");
            result.append(OpenCms.getLinkManager().substituteLink(cms, this.getHtmlWidgetOption().getStylesXmlPath()));
            result.append("\";\n");
            this.getHtmlWidgetOption().setStylesXmlPath("true");
        }
        if (this.getHtmlWidgetOption().isFullPage()) {
            result.append("editor.Config[\"FullPage\"] = true;\n");
        }
        result.append("editor.Width = \"100%\";\n");
        result.append("editor.Height = \"").append(this.getHtmlWidgetOption().getEditorHeight()).append("\";\n");
        result.append("editor.ToolbarSet = \"OpenCmsWidget\";\n");
        StringBuffer configJs = new StringBuffer(128);
        configJs.append("/system/workplace/editors/");
        configJs.append("fckeditor/configwidget.js");
        configJs.append("?");
        configJs.append(PARAM_CONFIGURATION);
        configJs.append("=");
        configJs.append(CmsHtmlWidgetOption.createConfigurationString((CmsHtmlWidgetOption)this.getHtmlWidgetOption()));
        result.append("editor.Config[\"CustomConfigurationsPath\"] = \"");
        result.append(OpenCms.getLinkManager().substituteLink(cms, configJs.toString()));
        result.append("\";\n");
        result.append("editorInstances[editorInstances.length] = editor;\n");
        result.append("contentFields[contentFields.length] = document.getElementById(\"").append(id).append("\");\n");
        result.append("</script>\n");
        result.append("</td>");
        return result.toString();
    }

    public I_CmsWidget newInstance() {
        return new CmsFCKEditorWidget(this.getHtmlWidgetOption());
    }
}

