/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.frontend.templateone.form;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.logging.Log;
import org.opencms.frontend.templateone.form.A_CmsField;
import org.opencms.frontend.templateone.form.CmsCheckboxField;
import org.opencms.frontend.templateone.form.CmsEmailField;
import org.opencms.frontend.templateone.form.CmsEmptyField;
import org.opencms.frontend.templateone.form.CmsFileUploadField;
import org.opencms.frontend.templateone.form.CmsHiddenField;
import org.opencms.frontend.templateone.form.CmsPrivacyField;
import org.opencms.frontend.templateone.form.CmsRadioButtonField;
import org.opencms.frontend.templateone.form.CmsSelectionField;
import org.opencms.frontend.templateone.form.CmsTextField;
import org.opencms.frontend.templateone.form.CmsTextareaField;
import org.opencms.frontend.templateone.form.Messages;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;

public final class CmsFieldFactory {
    public static final String CUSTOM_FORM_FIELD_PROPERTIES = OpenCms.getSystemInfo().getAbsoluteRfsPathRelativeToWebInf("classes" + File.separatorChar + "custom_form_field.properties");
    private static final Log LOG = CmsLog.getLog((Object)CmsFieldFactory.class);
    private static CmsFieldFactory sharedInstance = null;
    private Map m_registeredFieldTypes;

    private CmsFieldFactory() {
        block5: {
            this.m_registeredFieldTypes = new HashMap();
            this.registerFieldType(CmsCheckboxField.getStaticType(), CmsCheckboxField.class.getName());
            this.registerFieldType(CmsEmailField.getStaticType(), CmsEmailField.class.getName());
            this.registerFieldType(CmsFileUploadField.getStaticType(), CmsFileUploadField.class.getName());
            this.registerFieldType(CmsHiddenField.getStaticType(), CmsHiddenField.class.getName());
            this.registerFieldType(CmsRadioButtonField.getStaticType(), CmsRadioButtonField.class.getName());
            this.registerFieldType(CmsSelectionField.getStaticType(), CmsSelectionField.class.getName());
            this.registerFieldType(CmsTextField.getStaticType(), CmsTextField.class.getName());
            this.registerFieldType(CmsTextareaField.getStaticType(), CmsTextareaField.class.getName());
            this.registerFieldType(CmsEmptyField.getStaticType(), CmsEmptyField.class.getName());
            this.registerFieldType(CmsPrivacyField.getStaticType(), CmsPrivacyField.class.getName());
            File propertyFile = null;
            try {
                propertyFile = new File(CUSTOM_FORM_FIELD_PROPERTIES);
                if (propertyFile.exists()) {
                    ExtendedProperties fieldProperties = new ExtendedProperties();
                    fieldProperties.load((InputStream)new FileInputStream(propertyFile));
                    Iterator i = fieldProperties.keySet().iterator();
                    while (i.hasNext()) {
                        String[] values;
                        String key = (String)i.next();
                        if (!"FIELDS".equalsIgnoreCase(key) || (values = fieldProperties.getStringArray(key)) == null || values.length == 0) continue;
                        int n = values.length;
                        for (int j = 0; j < n; ++j) {
                            String field = values[j];
                            int index = field.indexOf(":");
                            if (index == -1) continue;
                            String fieldType = field.substring(0, index);
                            String fieldClass = field.substring(index + 1, field.length());
                            this.registerFieldType(fieldType, fieldClass);
                        }
                    }
                }
            }
            catch (IOException e) {
                if (!LOG.isErrorEnabled()) break block5;
                LOG.error((Object)Messages.get().getBundle().key("LOG_ERR_READING_CUSTOM_FORM_FIELD_PROPERTIES_1", (Object)(propertyFile == null ? CUSTOM_FORM_FIELD_PROPERTIES : propertyFile.getAbsolutePath())), (Throwable)e);
            }
        }
    }

    public static synchronized CmsFieldFactory getSharedInstance() {
        if (sharedInstance == null) {
            sharedInstance = new CmsFieldFactory();
        }
        return sharedInstance;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.m_registeredFieldTypes != null) {
                this.m_registeredFieldTypes.clear();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.finalize();
    }

    protected A_CmsField getField(String type) {
        A_CmsField field;
        block2: {
            field = null;
            try {
                String className = (String)this.m_registeredFieldTypes.get(type);
                field = (A_CmsField)Class.forName(className).newInstance();
            }
            catch (Throwable t) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error((Object)Messages.get().getBundle().key("LOG_ERR_FIELD_INSTANTIATION_1", (Object)type), t);
            }
        }
        return field;
    }

    private Object registerFieldType(String type, String className) {
        return this.m_registeredFieldTypes.put(type, className);
    }
}

