/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.frontend.templateone.form;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsPropertyDefinition;
import org.opencms.file.CmsRequestContext;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.frontend.templateone.form.Messages;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.loader.CmsLoaderException;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.CmsSelectWidget;
import org.opencms.widgets.CmsSelectWidgetOption;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.widgets.I_CmsWidgetDialog;
import org.opencms.widgets.I_CmsWidgetParameter;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.types.I_CmsXmlContentValue;

public class CmsSelectWidgetXmlcontentType
extends CmsSelectWidget {
    public static final String CONFIGURATION_OPTION_DISPLAY_MACRO = "displayOptionMacro";
    public static final String CONFIGURATION_OPTION_SORT_MACRO = "sortMacro";
    public static final String CONFIGURATION_RESOURCETYPENAME = "resourcetypeName";
    public static final String CONFIGURATION_TOPFOLDER = "folder";
    private static final Log LOG = CmsLog.getLog((Object)CmsSelectWidgetXmlcontentType.class);
    protected CmsObject m_macroCmsObject;
    protected CmsMacroResolver m_macroResolver;
    private String m_displayOptionMacro;
    private Map m_filterProperties = new HashMap();
    private CmsResource m_resourceFolder;
    private int m_resourceTypeID;
    private String m_sortMacro;

    public CmsSelectWidgetXmlcontentType() {
        this("");
    }

    public CmsSelectWidgetXmlcontentType(String configuration) {
        super(configuration);
    }

    public String getDisplayOptionMacro() {
        return this.m_displayOptionMacro;
    }

    public CmsResource getResourceFolder() {
        return this.m_resourceFolder;
    }

    public int getResourceTypeID() {
        return this.m_resourceTypeID;
    }

    public I_CmsWidget newInstance() {
        return new CmsSelectWidgetXmlcontentType(this.getConfiguration());
    }

    protected List parseSelectOptions(CmsObject cms, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) throws CmsIllegalArgumentException {
        AbstractList selectOptions;
        Locale dialogContentLocale = ((I_CmsXmlContentValue)param).getLocale();
        if (this.m_macroCmsObject == null) {
            try {
                this.m_macroCmsObject = OpenCms.initCmsObject((CmsObject)cms);
                this.m_macroCmsObject.getRequestContext().setSiteRoot("/");
            }
            catch (CmsException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)Messages.get().getBundle().key("ERR_SELECTWIDGET_INTERNAL_CONFIGURATION_2", new Object[]{((Object)((Object)this)).getClass().getName(), this.getConfiguration()}));
                }
                return Collections.EMPTY_LIST;
            }
        }
        if (this.m_macroResolver == null) {
            this.m_macroResolver = new CmsMacroResolver();
            this.m_macroResolver.setCmsObject(this.m_macroCmsObject);
            this.m_macroResolver.setKeepEmptyMacros(true);
        }
        if ((selectOptions = this.getSelectOptions()) == null) {
            List pOptions;
            block15: {
                String configuration = this.getConfiguration();
                if (configuration == null) {
                    configuration = param.getDefault(cms);
                }
                try {
                    this.parseConfigurationInternal(configuration, cms, param);
                    TreeSet<CmsResourceSelectWidgetOption> sortOptions = new TreeSet<CmsResourceSelectWidgetOption>(new CmsResourceSelectWidgetOptionComparator(this.m_macroCmsObject, this.m_sortMacro));
                    CmsResourceFilter filter = CmsResourceFilter.DEFAULT.addRequireType(this.getResourceTypeID());
                    CmsRequestContext context = cms.getRequestContext();
                    String oldSiteroot = context.getSiteRoot();
                    context.setSiteRoot("/");
                    List resources = cms.readResources(this.m_resourceFolder.getRootPath(), filter, true);
                    context.setSiteRoot(oldSiteroot);
                    if (resources.size() == 0 && LOG.isErrorEnabled()) {
                        LOG.error((Object)Messages.get().getBundle().key("LOG_ERR_SELECTWIDGET_NO_RESOURCES_FOUND_3", (Object)configuration, (Object)this.m_resourceFolder.getRootPath(), (Object)OpenCms.getResourceManager().getResourceType(this.getResourceTypeID()).getTypeName()));
                    }
                    Iterator itResources = resources.iterator();
                    while (itResources.hasNext()) {
                        CmsResource resource = (CmsResource)itResources.next();
                        Locale resourceLocale = CmsLocaleManager.getLocale((String)cms.readPropertyObject(resource, "locale", true).getValue());
                        if (!dialogContentLocale.equals(resourceLocale) || !this.hasFilterProperty(resource, cms)) continue;
                        this.m_macroCmsObject.getRequestContext().setUri(resource.getRootPath());
                        this.m_macroResolver.setResourceName(resource.getName());
                        this.m_macroResolver.setMessages(widgetDialog.getMessages());
                        String displayName = this.m_macroResolver.resolveMacros(this.getDisplayOptionMacro());
                        displayName = CmsStringUtil.isEmptyOrWhitespaceOnly((String)displayName) ? this.resolveXpathMacros(cms, resource, this.getDisplayOptionMacro()) : this.resolveXpathMacros(cms, resource, displayName);
                        if (CmsStringUtil.isEmpty((String)displayName)) {
                            displayName = resource.getName();
                        }
                        if (CmsStringUtil.isEmpty((String)(displayName = this.resolveXpathMacros(cms, resource, displayName)))) continue;
                        CmsResourceSelectWidgetOption option = new CmsResourceSelectWidgetOption(resource, false, displayName);
                        sortOptions.add(option);
                    }
                    selectOptions = new LinkedList(sortOptions);
                }
                catch (Exception e) {
                    if (!LOG.isErrorEnabled()) break block15;
                    LOG.error((Object)Messages.get().getBundle().key("ERR_SELECTWIDGET_CONFIGURATION_2", ((Object)((Object)this)).getClass(), (Object)configuration), (Throwable)e);
                }
            }
            if (selectOptions == Collections.EMPTY_LIST || selectOptions == null) {
                selectOptions = new ArrayList();
            }
            if ((pOptions = this.getSelectOptions()) != null) {
                pOptions.clear();
            }
            Iterator it = selectOptions.iterator();
            while (it.hasNext()) {
                this.addSelectOption((CmsSelectWidgetOption)it.next());
            }
        }
        return selectOptions;
    }

    private boolean hasFilterProperty(CmsResource resource, CmsObject cms) throws CmsException {
        boolean result = false;
        if (this.m_filterProperties.size() > 0) {
            Iterator itFilterProperties = this.m_filterProperties.entrySet().iterator();
            while (itFilterProperties.hasNext()) {
                Map.Entry entry = itFilterProperties.next();
                CmsProperty property = cms.readPropertyObject(resource, (String)entry.getKey(), true);
                if (property == CmsProperty.getNullProperty() || !property.getValue().equals(entry.getValue())) continue;
                result = true;
                break;
            }
        } else {
            result = true;
        }
        return result;
    }

    private void parseConfigurationInternal(String configuration, CmsObject cms, I_CmsWidgetParameter param) {
        CmsFile file = ((I_CmsXmlContentValue)param).getDocument().getFile();
        this.m_macroCmsObject.getRequestContext().setUri(file.getRootPath());
        List mappings = CmsStringUtil.splitAsList((String)configuration, (char)'|');
        Iterator itMappings = mappings.iterator();
        boolean displayMacroFound = false;
        boolean sortMacroFound = false;
        boolean folderFound = false;
        boolean typeFound = false;
        while (itMappings.hasNext()) {
            CmsPropertyDefinition propDef;
            String mapping = (String)itMappings.next();
            String[] keyValue = CmsStringUtil.splitAsArray((String)mapping, (char)'=');
            if (keyValue.length != 2) {
                throw new CmsIllegalArgumentException(Messages.get().container("ERR_SELECTWIDGET_CONFIGURATION_KEYVALUE_LENGTH_1", (Object)mapping));
            }
            String key = keyValue[0].trim();
            String value = keyValue[1].trim();
            this.m_macroResolver.setResourceName(file.getName());
            if (CONFIGURATION_OPTION_DISPLAY_MACRO.equals(key)) {
                if (displayMacroFound) {
                    throw new CmsIllegalArgumentException(Messages.get().container("ERR_SELECTWIDGET_CONFIGURATION_KEY_DUPLICATE_2", (Object)key, (Object)configuration));
                }
                this.m_displayOptionMacro = value;
                displayMacroFound = true;
                continue;
            }
            if (CONFIGURATION_OPTION_SORT_MACRO.equals(key)) {
                if (sortMacroFound) {
                    throw new CmsIllegalArgumentException(Messages.get().container("ERR_SELECTWIDGET_CONFIGURATION_KEY_DUPLICATE_2", (Object)key, (Object)configuration));
                }
                this.m_sortMacro = value;
                sortMacroFound = true;
                continue;
            }
            if (CONFIGURATION_RESOURCETYPENAME.equals(key)) {
                if (typeFound) {
                    throw new CmsIllegalArgumentException(Messages.get().container("ERR_SELECTWIDGET_CONFIGURATION_KEY_DUPLICATE_2", (Object)key, (Object)configuration));
                }
                try {
                    this.m_resourceTypeID = OpenCms.getResourceManager().getResourceType(value).getTypeId();
                }
                catch (CmsLoaderException e) {
                    throw new CmsIllegalArgumentException(org.opencms.file.Messages.get().container("ERR_UNKNOWN_RESOURCE_TYPE_1", (Object)value), (Throwable)e);
                }
                typeFound = true;
                continue;
            }
            if (CONFIGURATION_TOPFOLDER.equals(key)) {
                if (folderFound) {
                    throw new CmsIllegalArgumentException(Messages.get().container("ERR_SELECTWIDGET_CONFIGURATION_KEY_DUPLICATE_2", (Object)key, (Object)configuration));
                }
                value = this.m_macroResolver.resolveMacros(value);
                try {
                    CmsRequestContext context = cms.getRequestContext();
                    String oldSiteRoot = context.getSiteRoot();
                    context.setSiteRoot("/");
                    CmsResource resource = cms.readResource(value);
                    context.setSiteRoot(oldSiteRoot);
                    if (resource.isFile()) {
                        throw new CmsIllegalArgumentException(Messages.get().container("ERR_SELECTWIDGET_CONFIGURATION_RESOURCE_NOFOLDER_2", (Object)value, (Object)configuration));
                    }
                    this.m_resourceFolder = resource;
                }
                catch (CmsException e) {
                    throw new CmsIllegalArgumentException(Messages.get().container("ERR_SELECTWIDGET_CONFIGURATION_RESOURCE_INVALID_2", (Object)value, (Object)configuration), (Throwable)e);
                }
                folderFound = true;
                continue;
            }
            try {
                propDef = cms.readPropertyDefinition(key);
            }
            catch (CmsException e) {
                throw new CmsIllegalArgumentException(Messages.get().container("ERR_SELECTWIDGET_CONFIGURATION_KEY_UNKNOWN_2", (Object)key, (Object)((Object)((Object)this)).getClass().getName()), (Throwable)e);
            }
            if (propDef != null) {
                value = this.m_macroResolver.resolveMacros(value);
                this.m_filterProperties.put(key, value);
                continue;
            }
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_SELECTWIDGET_CONFIGURATION_KEY_UNKNOWN_2", (Object)key, (Object)((Object)((Object)this)).getClass().getName()));
        }
        if (!displayMacroFound) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_SELECTWIDGET_CONFIGURATION_KEY_MISSING_3", (Object)CONFIGURATION_OPTION_DISPLAY_MACRO, (Object)configuration, (Object)((Object)((Object)this)).getClass().getName()));
        }
        if (!folderFound) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_SELECTWIDGET_CONFIGURATION_KEY_MISSING_3", (Object)CONFIGURATION_TOPFOLDER, (Object)configuration, (Object)((Object)((Object)this)).getClass().getName()));
        }
        if (!typeFound) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_SELECTWIDGET_CONFIGURATION_KEY_MISSING_3", (Object)CONFIGURATION_RESOURCETYPENAME, (Object)configuration, (Object)((Object)((Object)this)).getClass().getName()));
        }
    }

    private String resolveXpathMacros(CmsObject cms, CmsResource resource, String value) throws CmsException {
        StringBuffer result = new StringBuffer();
        int startmacro = value.indexOf("%(xpath.");
        int stopmacro = 0;
        if (startmacro != -1) {
            CmsXmlContent xmlcontent = CmsXmlContentFactory.unmarshal((CmsObject)cms, (CmsFile)cms.readFile(resource));
            Locale locale = CmsLocaleManager.getLocale((String)cms.readPropertyObject((CmsResource)xmlcontent.getFile(), "locale", true).getValue());
            while (startmacro != -1) {
                block5: {
                    stopmacro = value.indexOf(41);
                    if (stopmacro == 0) {
                        // empty if block
                    }
                    result.append(value.substring(0, startmacro));
                    String xpath = value.substring(startmacro + 8, stopmacro);
                    try {
                        result.append(xmlcontent.getValue(xpath, locale).getPlainText(cms));
                    }
                    catch (Exception ex) {
                        if (!LOG.isErrorEnabled()) break block5;
                        LOG.error((Object)Messages.get().getBundle().key("LOG_ERR_SELECTWIDGET_XPATH_INVALID_4", new Object[]{xpath, locale.toString(), xmlcontent.getFile().getRootPath(), ex.getLocalizedMessage()}));
                    }
                }
                value = value.substring(stopmacro + 1);
                startmacro = value.indexOf("%(xpath.");
            }
        }
        result.append(value);
        return result.toString();
    }

    private static final class CmsResourceSelectWidgetOptionComparator
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = -4078389792834878256L;
        private String m_comparatorMacro;
        private CmsObject m_macroCmsObjectInner;
        private CmsMacroResolver m_macroResolverInner;

        CmsResourceSelectWidgetOptionComparator(CmsObject cms, String comparatorMacro) throws CmsException {
            this.m_comparatorMacro = CmsStringUtil.isEmpty((String)comparatorMacro) ? "%(opencms.filename)" : comparatorMacro;
            this.m_macroCmsObjectInner = OpenCms.initCmsObject((CmsObject)cms);
            this.m_macroCmsObjectInner.getRequestContext().setSiteRoot("/");
            this.m_macroResolverInner = new CmsMacroResolver();
            this.m_macroResolverInner.setCmsObject(this.m_macroCmsObjectInner);
        }

        public int compare(Object o1, Object o2) {
            CmsResourceSelectWidgetOption option1 = (CmsResourceSelectWidgetOption)((Object)o1);
            CmsResourceSelectWidgetOption option2 = (CmsResourceSelectWidgetOption)((Object)o2);
            CmsResource resource1 = option1.getResource();
            CmsResource resource2 = option2.getResource();
            CmsRequestContext requestContext = this.m_macroCmsObjectInner.getRequestContext();
            requestContext.setUri(resource1.getRootPath());
            this.m_macroResolverInner.setResourceName(resource1.getName());
            String sort1 = this.m_macroResolverInner.resolveMacros(this.m_comparatorMacro);
            requestContext.setUri(resource2.getRootPath());
            this.m_macroResolverInner.setResourceName(resource2.getName());
            String sort2 = this.m_macroResolverInner.resolveMacros(this.m_comparatorMacro);
            return sort1.compareTo(sort2);
        }
    }

    private static final class CmsResourceSelectWidgetOption
    extends CmsSelectWidgetOption {
        private CmsResource m_resource;

        public CmsResourceSelectWidgetOption(CmsResource resource) {
            this(resource, false);
        }

        public CmsResourceSelectWidgetOption(CmsResource resource, boolean isDefault) {
            this(resource, isDefault, resource.getName());
        }

        public CmsResourceSelectWidgetOption(CmsResource resource, boolean isDefault, String optionText) {
            this(resource, isDefault, optionText, null);
        }

        public CmsResourceSelectWidgetOption(CmsResource resource, boolean isDefault, String optionText, String helpText) {
            super(resource.getRootPath(), isDefault, optionText, helpText);
            this.m_resource = resource;
        }

        CmsResource getResource() {
            return this.m_resource;
        }
    }
}

