/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.workplace;

import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.configuration.CmsSystemConfiguration;
import org.opencms.db.CmsLoginMessage;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.OpenCms;
import org.opencms.widgets.CmsCalendarWidget;
import org.opencms.widgets.CmsCheckboxWidget;
import org.opencms.widgets.CmsTextareaWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.workplace.CmsWidgetDialog;
import org.opencms.workplace.CmsWidgetDialogParameter;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.tools.workplace.Messages;

public class CmsEditLoginMessageDialog
extends CmsWidgetDialog {
    public static final String KEY_PREFIX = "loginmsg";
    public static final String[] PAGES = new String[]{"page1"};
    private CmsLoginMessage m_loginMessage;

    public CmsEditLoginMessageDialog(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsEditLoginMessageDialog(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionCommit() {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        try {
            OpenCms.getLoginManager().setLoginMessage(this.getCms(), this.m_loginMessage);
            OpenCms.writeConfiguration((Class)CmsSystemConfiguration.class);
            this.setDialogObject(null);
        }
        catch (Throwable t) {
            errors.add(t);
        }
        this.setCommitErrors(errors);
    }

    protected String createDialogHtml(String dialog) {
        StringBuffer result = new StringBuffer(1024);
        result.append(this.createWidgetTableStart());
        result.append(this.createWidgetErrorHeader());
        result.append(this.dialogBlockStart(this.key("GUI_EDITOR_LABEL_ACTIVATE_BLOCK_0")));
        result.append(this.createWidgetTableStart());
        result.append(this.createDialogRowsHtml(0, 0));
        result.append(this.createWidgetTableEnd());
        result.append(this.dialogBlockEnd());
        result.append(this.dialogBlockStart(this.key("GUI_EDITOR_LABEL_CONFIGURATION_BLOCK_0")));
        result.append(this.createWidgetTableStart());
        result.append(this.createDialogRowsHtml(1, 4));
        result.append(this.createWidgetTableEnd());
        result.append(this.dialogBlockEnd());
        result.append(this.createWidgetTableEnd());
        return result.toString();
    }

    protected void defineWidgets() {
        this.initLoginMessageObject();
        this.setKeyPrefix(KEY_PREFIX);
        CmsLoginMessage def = new CmsLoginMessage();
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_loginMessage, "enabled", PAGES[0], (I_CmsWidget)new CmsCheckboxWidget()));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_loginMessage, "message", PAGES[0], (I_CmsWidget)new CmsTextareaWidget()));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_loginMessage, "loginForbidden", PAGES[0], (I_CmsWidget)new CmsCheckboxWidget()));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_loginMessage, "timeStart", String.valueOf(def.getTimeStart()), PAGES[0], (I_CmsWidget)new CmsCalendarWidget(), 0, 1));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_loginMessage, "timeEnd", String.valueOf(def.getTimeEnd()), PAGES[0], (I_CmsWidget)new CmsCalendarWidget(), 0, 1));
    }

    protected String[] getPageArray() {
        return PAGES;
    }

    protected void initLoginMessageObject() {
        Object o = this.getDialogObject();
        if (o == null || !(o instanceof CmsLoginMessage)) {
            o = OpenCms.getLoginManager().getLoginMessage();
        }
        this.m_loginMessage = o != null ? (CmsLoginMessage)((CmsLoginMessage)o).clone() : new CmsLoginMessage();
    }

    protected void initMessages() {
        this.addMessages(Messages.get().getBundleName());
        super.initMessages();
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        super.initWorkplaceRequestValues(settings, request);
        this.setDialogObject(this.m_loginMessage);
    }
}

