/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.workplace.broadcast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsUser;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalStateException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.CmsDisplayWidget;
import org.opencms.widgets.CmsTextareaWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.workplace.CmsWidgetDialog;
import org.opencms.workplace.CmsWidgetDialogParameter;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.tools.workplace.Messages;
import org.opencms.workplace.tools.workplace.broadcast.CmsMessageInfo;

public class CmsSendPopupGroupsDialog
extends CmsWidgetDialog {
    public static final String KEY_PREFIX = "message";
    public static final String[] PAGES = new String[]{"page1"};
    public static final String PARAM_GROUPS = "groups";
    private static final Log LOG = CmsLog.getLog((Object)CmsSendPopupGroupsDialog.class);
    protected CmsMessageInfo m_msgInfo;
    private String m_paramGroups;
    private List m_users;

    public CmsSendPopupGroupsDialog(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsSendPopupGroupsDialog(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionCommit() {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        if (this.getUsers().isEmpty()) {
            this.setCommitErrors(Collections.singletonList(new CmsIllegalStateException(org.opencms.workplace.tools.workplace.broadcast.Messages.get().container("ERR_NO_SELECTED_USER_WITH_EMAIL_0"))));
            return;
        }
        try {
            Iterator itUsers = this.getUsers().iterator();
            while (itUsers.hasNext()) {
                CmsUser user = (CmsUser)itUsers.next();
                OpenCms.getSessionManager().sendBroadcast(this.getCms().getRequestContext().currentUser(), this.m_msgInfo.getMsg(), user);
            }
        }
        catch (Throwable t) {
            errors.add(t);
        }
        this.setCommitErrors(errors);
    }

    public List getGroups() {
        return CmsStringUtil.splitAsList((String)this.getParamGroups(), (String)"|");
    }

    public String getParamGroups() {
        return this.m_paramGroups;
    }

    public void setParamGroups(String paramGroups) {
        this.m_paramGroups = paramGroups;
    }

    protected String createDialogHtml(String dialog) {
        StringBuffer result = new StringBuffer(1024);
        result.append(this.createWidgetTableStart());
        result.append(this.createWidgetErrorHeader());
        if (dialog.equals(PAGES[0])) {
            result.append(this.dialogBlockStart(this.key("GUI_MESSAGE_EDITOR_LABEL_HEADER_BLOCK_0")));
            result.append(this.createWidgetTableStart());
            result.append(this.createDialogRowsHtml(0, 1));
            result.append(this.createWidgetTableEnd());
            result.append(this.dialogBlockEnd());
            result.append(this.dialogBlockStart(this.key("GUI_MESSAGE_EDITOR_LABEL_CONTENT_BLOCK_0")));
            result.append(this.createWidgetTableStart());
            result.append(this.createDialogRowsHtml(2, 2));
            result.append(this.createWidgetTableEnd());
            result.append(this.dialogBlockEnd());
        }
        result.append(this.createWidgetTableEnd());
        return result.toString();
    }

    protected void defineWidgets() {
        this.initMessageObject();
        this.setKeyPrefix(KEY_PREFIX);
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_msgInfo, "from", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_msgInfo, "to", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_msgInfo, "msg", PAGES[0], (I_CmsWidget)new CmsTextareaWidget(12)));
    }

    protected String[] getPageArray() {
        return PAGES;
    }

    protected String getToNames() {
        StringBuffer result = new StringBuffer(256);
        Iterator itUsers = this.getUsers().iterator();
        while (itUsers.hasNext()) {
            CmsUser user = (CmsUser)itUsers.next();
            result.append(user.getFullName());
            if (!itUsers.hasNext()) continue;
            result.append("; ");
        }
        return result.toString();
    }

    protected void initMessageObject() {
        try {
            this.m_msgInfo = CmsStringUtil.isEmpty((String)this.getParamAction()) || "initial".equals(this.getParamAction()) ? new CmsMessageInfo() : (CmsMessageInfo)this.getDialogObject();
        }
        catch (Exception e) {
            this.m_msgInfo = new CmsMessageInfo();
        }
        this.m_msgInfo.setFrom(this.getCms().getRequestContext().currentUser().getFullName());
        this.m_msgInfo.setTo(this.getToNames());
    }

    protected void initMessages() {
        this.addMessages(org.opencms.workplace.tools.workplace.broadcast.Messages.get().getBundleName());
        this.addMessages(Messages.get().getBundleName());
        super.initMessages();
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        super.initWorkplaceRequestValues(settings, request);
        this.setDialogObject(this.m_msgInfo);
    }

    protected void validateParamaters() throws Exception {
        if (this.getUsers() == null || this.getUsers().isEmpty()) {
            throw new Exception();
        }
    }

    private List getUsers() {
        if (this.m_users == null) {
            List manageableUsers;
            block7: {
                this.m_users = new ArrayList();
                manageableUsers = new ArrayList();
                try {
                    manageableUsers = OpenCms.getRoleManager().getManageableUsers(this.getCms(), "", true);
                }
                catch (CmsException e) {
                    if (!LOG.isErrorEnabled()) break block7;
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            Iterator itGroups = this.getGroups().iterator();
            while (itGroups.hasNext()) {
                String groupName = (String)itGroups.next();
                try {
                    Iterator itUsers = this.getCms().getUsersOfGroup(groupName, true).iterator();
                    while (itUsers.hasNext()) {
                        CmsUser user = (CmsUser)itUsers.next();
                        if (OpenCms.getSessionManager().getSessionInfos(user.getId()).isEmpty() || !manageableUsers.contains(user)) continue;
                        this.m_users.add(user);
                    }
                }
                catch (CmsException e) {
                }
            }
        }
        return this.m_users;
    }
}

