/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.workplace.broadcast;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.file.CmsUser;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsSessionInfo;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.list.A_CmsListDialog;
import org.opencms.workplace.list.CmsListColumnAlignEnum;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListDateMacroFormatter;
import org.opencms.workplace.list.CmsListDefaultAction;
import org.opencms.workplace.list.CmsListDirectAction;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListItemActionIconComparator;
import org.opencms.workplace.list.CmsListItemDetails;
import org.opencms.workplace.list.CmsListItemDetailsFormatter;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListMultiAction;
import org.opencms.workplace.list.CmsListOrderEnum;
import org.opencms.workplace.list.CmsListTimeIntervalFormatter;
import org.opencms.workplace.list.I_CmsListDirectAction;
import org.opencms.workplace.list.I_CmsListFormatter;
import org.opencms.workplace.list.I_CmsListItemComparator;
import org.opencms.workplace.tools.workplace.Messages;

public class CmsSessionsList
extends A_CmsListDialog {
    public static final String LIST_ACTION_MESSAGE = "am";
    public static final String LIST_ACTION_PENDING_DISABLED = "apd";
    public static final String LIST_ACTION_PENDING_ENABLED = "ape";
    public static final String LIST_COLUMN_CREATION = "cc";
    public static final String LIST_COLUMN_INACTIVE = "ci";
    public static final String LIST_COLUMN_MESSAGE = "cm";
    public static final String LIST_COLUMN_ORGUNIT = "cou";
    public static final String LIST_COLUMN_PENDING = "cp";
    public static final String LIST_COLUMN_PROJECT = "cj";
    public static final String LIST_COLUMN_SITE = "cs";
    public static final String LIST_COLUMN_USER = "cu";
    public static final String LIST_DEFACTION_MESSAGE = "dm";
    public static final String LIST_DETAIL_EMAIL = "de";
    public static final String LIST_ID = "ls";
    public static final String LIST_MACTION_EMAIL = "me";
    public static final String LIST_MACTION_MESSAGE = "mm";
    public static final String PATH_BUTTONS = "tools/workplace/buttons/";

    public CmsSessionsList(CmsJspActionElement jsp) {
        super(jsp, LIST_ID, org.opencms.workplace.tools.workplace.broadcast.Messages.get().container("GUI_SESSIONS_LIST_NAME_0"), LIST_COLUMN_USER, CmsListOrderEnum.ORDER_ASCENDING, LIST_COLUMN_USER);
    }

    public CmsSessionsList(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void executeListMultiActions() throws IOException, ServletException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sessionids", this.getParamSelItems());
        params.put("action", "initial");
        if (this.getParamListAction().equals(LIST_MACTION_MESSAGE)) {
            this.getToolManager().jspForwardTool((CmsWorkplace)this, "/workplace/broadcast/message", params);
        } else if (this.getParamListAction().equals(LIST_MACTION_EMAIL)) {
            this.getToolManager().jspForwardTool((CmsWorkplace)this, "/workplace/broadcast/email", params);
        } else {
            this.throwListUnsupportedActionException();
        }
    }

    public void executeListSingleActions() throws IOException, ServletException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sessionids", this.getSelectedItem().getId());
        params.put("action", "initial");
        if (this.getParamListAction().equals(LIST_ACTION_MESSAGE) || this.getParamListAction().equals(LIST_DEFACTION_MESSAGE)) {
            this.getToolManager().jspForwardTool((CmsWorkplace)this, "/workplace/broadcast/message", params);
        } else {
            this.throwListUnsupportedActionException();
        }
        this.listSave();
    }

    protected void fillDetails(String detailId) {
        List sessions = this.getList().getAllContent();
        Iterator i = sessions.iterator();
        while (i.hasNext()) {
            CmsListItem item = (CmsListItem)i.next();
            CmsSessionInfo session = OpenCms.getSessionManager().getSessionInfo(new CmsUUID(item.getId()));
            StringBuffer html = new StringBuffer(32);
            if (!detailId.equals(LIST_DETAIL_EMAIL)) continue;
            try {
                CmsUser user = this.getCms().readUser(session.getUserId());
                html.append(user.getEmail());
            }
            catch (CmsException e) {
                // empty catch block
            }
            item.set(detailId, (Object)html.toString());
        }
    }

    protected List getListItems() throws CmsException {
        List manageableUsers = OpenCms.getRoleManager().getManageableUsers(this.getCms(), "", true);
        ArrayList<CmsListItem> ret = new ArrayList<CmsListItem>();
        List sessionInfos = OpenCms.getSessionManager().getSessionInfos();
        Iterator itSessions = sessionInfos.iterator();
        while (itSessions.hasNext()) {
            CmsSessionInfo sessionInfo = (CmsSessionInfo)itSessions.next();
            CmsListItem item = this.getList().newItem(sessionInfo.getSessionId().toString());
            CmsUser user = this.getCms().readUser(sessionInfo.getUserId());
            if (!manageableUsers.contains(user)) continue;
            item.set(LIST_COLUMN_USER, (Object)user.getFullName());
            item.set(LIST_COLUMN_ORGUNIT, (Object)OpenCms.getOrgUnitManager().readOrganizationalUnit(this.getCms(), user.getOuFqn()).getDisplayName(this.getLocale()));
            item.set(LIST_COLUMN_CREATION, (Object)new Date(sessionInfo.getTimeCreated()));
            item.set(LIST_COLUMN_INACTIVE, (Object)new Long(System.currentTimeMillis() - sessionInfo.getTimeUpdated()));
            try {
                item.set(LIST_COLUMN_PROJECT, (Object)this.getCms().readProject(sessionInfo.getProject()).getName());
            }
            catch (Exception e) {
                // empty catch block
            }
            item.set(LIST_COLUMN_SITE, (Object)sessionInfo.getSiteRoot());
            ret.add(item);
        }
        try {
            if (OpenCms.getOrgUnitManager().getOrganizationalUnits(this.getCms(), "", true).isEmpty()) {
                this.getList().getMetadata().getColumnDefinition(LIST_COLUMN_ORGUNIT).setVisible(false);
                this.getList().getMetadata().getColumnDefinition(LIST_COLUMN_USER).setWidth("40%");
            } else {
                this.getList().getMetadata().getColumnDefinition(LIST_COLUMN_ORGUNIT).setVisible(true);
                this.getList().getMetadata().getColumnDefinition(LIST_COLUMN_USER).setWidth("20%");
            }
        }
        catch (CmsException e) {
            // empty catch block
        }
        return ret;
    }

    protected void initMessages() {
        this.addMessages(org.opencms.workplace.tools.workplace.broadcast.Messages.get().getBundleName());
        this.addMessages(Messages.get().getBundleName());
        super.initMessages();
    }

    protected void setColumns(CmsListMetadata metadata) {
        CmsListColumnDefinition messageCol = new CmsListColumnDefinition(LIST_COLUMN_MESSAGE);
        messageCol.setName(org.opencms.workplace.tools.workplace.broadcast.Messages.get().container("GUI_SESSIONS_LIST_COLS_MESSAGE_0"));
        messageCol.setHelpText(org.opencms.workplace.tools.workplace.broadcast.Messages.get().container("GUI_SESSIONS_LIST_COLS_MESSAGE_HELP_0"));
        messageCol.setWidth("20");
        messageCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        messageCol.setSorteable(false);
        CmsListDirectAction messageAction = new CmsListDirectAction(LIST_ACTION_MESSAGE);
        messageAction.setName(org.opencms.workplace.tools.workplace.broadcast.Messages.get().container("GUI_SESSIONS_LIST_ACTION_MESSAGE_NAME_0"));
        messageAction.setHelpText(org.opencms.workplace.tools.workplace.broadcast.Messages.get().container("GUI_SESSIONS_LIST_ACTION_MESSAGE_HELP_0"));
        messageAction.setIconPath("tools/workplace/buttons/send_message.png");
        messageCol.addDirectAction((I_CmsListDirectAction)messageAction);
        metadata.addColumn(messageCol);
        CmsListColumnDefinition pendingCol = new CmsListColumnDefinition(LIST_COLUMN_PENDING);
        pendingCol.setName(org.opencms.workplace.tools.workplace.broadcast.Messages.get().container("GUI_SESSIONS_LIST_COLS_PENDING_0"));
        pendingCol.setWidth("20");
        pendingCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        pendingCol.setListItemComparator((I_CmsListItemComparator)new CmsListItemActionIconComparator());
        CmsListDirectAction pendingAction = new CmsListDirectAction(LIST_ACTION_PENDING_ENABLED){

            public boolean isVisible() {
                if (this.getItem() != null) {
                    return !OpenCms.getSessionManager().getBroadcastQueue(this.getItem().getId()).isEmpty();
                }
                return super.isVisible();
            }
        };
        pendingAction.setName(org.opencms.workplace.tools.workplace.broadcast.Messages.get().container("GUI_SESSIONS_LIST_ACTION_PENDING_NAME_0"));
        pendingAction.setHelpText(org.opencms.workplace.tools.workplace.broadcast.Messages.get().container("GUI_SESSIONS_LIST_ACTION_PENDING_HELP_0"));
        pendingAction.setIconPath("tools/workplace/buttons/message_pending.png");
        pendingAction.setEnabled(false);
        pendingCol.addDirectAction((I_CmsListDirectAction)pendingAction);
        CmsListDirectAction notPendingAction = new CmsListDirectAction(LIST_ACTION_PENDING_DISABLED){

            public boolean isVisible() {
                if (this.getItem() != null) {
                    return OpenCms.getSessionManager().getBroadcastQueue(this.getItem().getId()).isEmpty();
                }
                return super.isVisible();
            }
        };
        notPendingAction.setName(org.opencms.workplace.tools.workplace.broadcast.Messages.get().container("GUI_SESSIONS_LIST_ACTION_NOTPENDING_NAME_0"));
        notPendingAction.setHelpText(org.opencms.workplace.tools.workplace.broadcast.Messages.get().container("GUI_SESSIONS_LIST_ACTION_NOTPENDING_HELP_0"));
        notPendingAction.setIconPath("tools/workplace/buttons/message_notpending.png");
        notPendingAction.setEnabled(false);
        pendingCol.addDirectAction((I_CmsListDirectAction)notPendingAction);
        metadata.addColumn(pendingCol);
        CmsListColumnDefinition userCol = new CmsListColumnDefinition(LIST_COLUMN_USER);
        userCol.setName(org.opencms.workplace.tools.workplace.broadcast.Messages.get().container("GUI_SESSIONS_LIST_COLS_USER_0"));
        CmsListDefaultAction messageEditAction = new CmsListDefaultAction(LIST_DEFACTION_MESSAGE);
        messageEditAction.setName(org.opencms.workplace.tools.workplace.broadcast.Messages.get().container("GUI_SESSIONS_LIST_ACTION_MESSAGE_NAME_0"));
        messageEditAction.setHelpText(org.opencms.workplace.tools.workplace.broadcast.Messages.get().container("GUI_SESSIONS_LIST_ACTION_MESSAGE_HELP_0"));
        userCol.addDefaultAction(messageEditAction);
        metadata.addColumn(userCol);
        CmsListColumnDefinition ouCol = new CmsListColumnDefinition(LIST_COLUMN_ORGUNIT);
        ouCol.setName(org.opencms.workplace.tools.workplace.broadcast.Messages.get().container("GUI_SESSIONS_LIST_COLS_ORGUNIT_0"));
        ouCol.setWidth("30%");
        metadata.addColumn(ouCol);
        CmsListColumnDefinition creationCol = new CmsListColumnDefinition(LIST_COLUMN_CREATION);
        creationCol.setName(org.opencms.workplace.tools.workplace.broadcast.Messages.get().container("GUI_SESSIONS_LIST_COLS_CREATION_0"));
        creationCol.setWidth("16%");
        creationCol.setFormatter(CmsListDateMacroFormatter.getDefaultDateFormatter());
        metadata.addColumn(creationCol);
        CmsListColumnDefinition inactiveCol = new CmsListColumnDefinition(LIST_COLUMN_INACTIVE);
        inactiveCol.setName(org.opencms.workplace.tools.workplace.broadcast.Messages.get().container("GUI_SESSIONS_LIST_COLS_INACTIVE_0"));
        inactiveCol.setWidth("10%");
        inactiveCol.setFormatter((I_CmsListFormatter)new CmsListTimeIntervalFormatter());
        metadata.addColumn(inactiveCol);
        CmsListColumnDefinition projectCol = new CmsListColumnDefinition(LIST_COLUMN_PROJECT);
        projectCol.setName(org.opencms.workplace.tools.workplace.broadcast.Messages.get().container("GUI_SESSIONS_LIST_COLS_PROJECT_0"));
        projectCol.setWidth("12%");
        metadata.addColumn(projectCol);
        CmsListColumnDefinition siteCol = new CmsListColumnDefinition(LIST_COLUMN_SITE);
        siteCol.setName(org.opencms.workplace.tools.workplace.broadcast.Messages.get().container("GUI_SESSIONS_LIST_COLS_SITE_0"));
        siteCol.setWidth("12%");
        metadata.addColumn(siteCol);
    }

    protected void setIndependentActions(CmsListMetadata metadata) {
        CmsListItemDetails emailDetail = new CmsListItemDetails(LIST_DETAIL_EMAIL);
        emailDetail.setAtColumn(LIST_COLUMN_USER);
        emailDetail.setVisible(false);
        emailDetail.setFormatter((I_CmsListFormatter)new CmsListItemDetailsFormatter(org.opencms.workplace.tools.workplace.broadcast.Messages.get().container("GUI_SESSIONS_LABEL_EMAIL_0")));
        emailDetail.setShowActionName(org.opencms.workplace.tools.workplace.broadcast.Messages.get().container("GUI_SESSIONS_DETAIL_SHOW_EMAIL_NAME_0"));
        emailDetail.setShowActionHelpText(org.opencms.workplace.tools.workplace.broadcast.Messages.get().container("GUI_SESSIONS_DETAIL_SHOW_EMAIL_HELP_0"));
        emailDetail.setHideActionName(org.opencms.workplace.tools.workplace.broadcast.Messages.get().container("GUI_SESSIONS_DETAIL_HIDE_EMAIL_NAME_0"));
        emailDetail.setHideActionHelpText(org.opencms.workplace.tools.workplace.broadcast.Messages.get().container("GUI_SESSIONS_DETAIL_HIDE_EMAIL_HELP_0"));
        metadata.addItemDetails(emailDetail);
    }

    protected void setMultiActions(CmsListMetadata metadata) {
        CmsListMultiAction messageMultiAction = new CmsListMultiAction(LIST_MACTION_MESSAGE);
        messageMultiAction.setName(org.opencms.workplace.tools.workplace.broadcast.Messages.get().container("GUI_SESSIONS_LIST_MACTION_MESSAGE_NAME_0"));
        messageMultiAction.setHelpText(org.opencms.workplace.tools.workplace.broadcast.Messages.get().container("GUI_SESSIONS_LIST_MACTION_MESSAGE_HELP_0"));
        messageMultiAction.setConfirmationMessage(org.opencms.workplace.tools.workplace.broadcast.Messages.get().container("GUI_SESSIONS_LIST_MACTION_MESSAGE_CONF_0"));
        messageMultiAction.setIconPath("tools/workplace/buttons/multi_send_message.png");
        metadata.addMultiAction(messageMultiAction);
        CmsListMultiAction emailMultiAction = new CmsListMultiAction(LIST_MACTION_EMAIL);
        emailMultiAction.setName(org.opencms.workplace.tools.workplace.broadcast.Messages.get().container("GUI_SESSIONS_LIST_MACTION_EMAIL_NAME_0"));
        emailMultiAction.setHelpText(org.opencms.workplace.tools.workplace.broadcast.Messages.get().container("GUI_SESSIONS_LIST_MACTION_EMAIL_HELP_0"));
        emailMultiAction.setConfirmationMessage(org.opencms.workplace.tools.workplace.broadcast.Messages.get().container("GUI_SESSIONS_LIST_MACTION_EMAIL_CONF_0"));
        emailMultiAction.setIconPath("tools/workplace/buttons/multi_send_email.png");
        metadata.addMultiAction(emailMultiAction);
    }
}

