/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.workplace.rfsfile;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.flex.CmsFlexController;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.security.CmsRoleViolationException;
import org.opencms.util.CmsRfsFileViewer;
import org.opencms.workplace.CmsWidgetDialog;
import org.opencms.workplace.tools.workplace.rfsfile.Messages;

public class CmsRfsFileDisposalDialog
extends CmsWidgetDialog {
    public static final String[] PAGES = new String[]{"page1"};
    private File m_downloadFile;

    public CmsRfsFileDisposalDialog(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsRfsFileDisposalDialog(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionCommit() {
    }

    public String dialogButtonsCustom() {
        return this.dialogButtons(new int[]{2}, new String[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void generateOutput() throws IOException {
        block12: {
            BufferedInputStream in;
            ServletOutputStream outStream;
            block11: {
                HttpServletResponse res = CmsFlexController.getController((ServletRequest)this.getJsp().getRequest()).getTopResponse();
                res.setContentType("application/octet-stream");
                res.setHeader("Content-Disposition", "attachment; filename=\"" + this.getDownloadFile().getName() + "\"");
                res.setContentLength((int)this.getDownloadFile().length());
                outStream = res.getOutputStream();
                in = new BufferedInputStream(new FileInputStream(this.getDownloadFile()));
                int bit = ((InputStream)in).read();
                while (bit >= 0) {
                    outStream.write(bit);
                    bit = ((InputStream)in).read();
                }
                Object var6_6 = null;
                if (outStream == null) break block11;
                try {
                    outStream.flush();
                    outStream.close();
                }
                catch (SocketException soe2) {
                    // empty catch block
                }
            }
            ((InputStream)in).close();
            {
                break block12;
                catch (SocketException soe) {
                    Object var6_7 = null;
                    if (outStream != null) {
                        try {
                            outStream.flush();
                            outStream.close();
                        }
                        catch (SocketException soe2) {
                            // empty catch block
                        }
                    }
                    ((InputStream)in).close();
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (outStream != null) {
                    try {
                        outStream.flush();
                        outStream.close();
                    }
                    catch (SocketException soe2) {
                        // empty catch block
                    }
                }
                ((InputStream)in).close();
                throw throwable;
            }
        }
    }

    protected void checkRole() throws CmsRoleViolationException {
        OpenCms.getRoleManager().checkRole(this.getCms(), CmsRole.WORKPLACE_MANAGER);
    }

    protected String createDialogHtml(String dialog) {
        StringBuffer result = new StringBuffer(1024);
        result.append(this.createWidgetTableStart());
        result.append(this.createWidgetErrorHeader());
        if (dialog.equals(PAGES[0])) {
            result.append("<script type=\"text/javascript\">\n");
            result.append("function download(){\n");
            result.append("\twindow.open(\"").append(this.getJsp().link(this.getDownloadPath())).append("\", \"rfsfile\");\n");
            result.append("}\n");
            result.append("window.setTimeout(\"download()\",500);\n");
            result.append("</script>\n");
            result.append(this.dialogBlockStart(this.key("GUI_WORLKPLACE_LOGVIEW_DODOWNLOAD_HEADER_1", new Object[]{this.getDownloadFile().getName()})));
            result.append(this.key("GUI_WORLKPLACE_LOGVIEW_DODOWNLOAD_MESSAGE_0"));
            result.append(" <a href='javascript:download()'>");
            result.append(this.key("GUI_WORLKPLACE_LOGVIEW_DODOWNLOAD_LINKTXT_0"));
            result.append("</a>.");
            result.append(this.dialogBlockEnd());
        }
        result.append(this.createWidgetTableEnd());
        return result.toString();
    }

    protected void defineWidgets() {
    }

    protected File getDownloadFile() throws CmsRuntimeException {
        if (this.m_downloadFile == null) {
            CmsRfsFileViewer fileView = OpenCms.getWorkplaceManager().getFileViewSettings();
            this.m_downloadFile = new File(fileView.getFilePath());
            try {
                this.m_downloadFile = this.m_downloadFile.getCanonicalFile();
            }
            catch (IOException ioex) {
                throw new CmsRuntimeException(Messages.get().container("ERR_FILE_ACCESS_0"), (Throwable)ioex);
            }
        }
        return this.m_downloadFile;
    }

    protected String getDownloadPath() {
        return "/system/workplace/admin/workplace/logfileview/downloadTrigger.jsp";
    }

    protected String[] getPageArray() {
        return PAGES;
    }

    protected void initMessages() {
        super.initMessages();
        this.addMessages(Messages.get().getBundleName());
    }

    protected void validateParamaters() throws Exception {
        OpenCms.getRoleManager().checkRole(this.getCms(), CmsRole.WORKPLACE_MANAGER);
    }
}

