/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.workplace.rfsfile;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsDateUtil;
import org.opencms.util.CmsRfsFileViewer;
import org.opencms.widgets.CmsDisplayWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.workplace.CmsWidgetDialog;
import org.opencms.workplace.CmsWidgetDialogParameter;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.tools.workplace.rfsfile.Messages;

public class CmsRfsFileDownloadDialog
extends CmsWidgetDialog {
    public static final String KEY_PREFIX = "workplace.download";
    public static final String[] PAGES = new String[]{"page1"};
    private File m_downloadFile;
    private String m_filedate;
    private String m_filename;
    private String m_filepath;
    private String m_filesize;

    public CmsRfsFileDownloadDialog(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsRfsFileDownloadDialog(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionCommit() throws IOException, ServletException {
        ArrayList errors = new ArrayList();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("closelink", this.getParamCloseLink());
        params.put("style", "new");
        this.getToolManager().jspForwardPage((CmsWorkplace)this, "/system/workplace/admin/workplace/logfileview/dodownload.jsp", params);
        this.setCommitErrors(errors);
    }

    public String dialogButtonsCustom() {
        return this.dialogButtons(new int[]{0, 1}, new String[2]);
    }

    public String getFiledate() {
        return this.m_filedate;
    }

    public String getFilename() {
        return this.m_filename;
    }

    public String getFilepath() {
        return this.m_filepath;
    }

    public String getFilesize() {
        return this.m_filesize;
    }

    public void setFiledate(String filedate) {
        this.m_filedate = filedate;
    }

    public void setFilename(String filename) {
        this.m_filename = filename;
    }

    public void setFilepath(String filepath) {
        this.m_filepath = filepath;
    }

    public void setFilesize(String filesize) {
        this.m_filesize = filesize;
    }

    protected String createDialogHtml(String dialog) {
        StringBuffer result = new StringBuffer(1024);
        result.append(this.createWidgetTableStart());
        result.append(this.createWidgetErrorHeader());
        if (dialog.equals(PAGES[0])) {
            result.append(this.dialogBlockStart(this.key("GUI_WORKPLACE_LOGVIEW_DOWNLOAD_START_MSG_0")));
            result.append(this.createWidgetTableStart());
            result.append(this.createDialogRowsHtml(0, 3));
            result.append(this.createWidgetTableEnd());
            result.append(this.dialogBlockEnd());
        }
        result.append(this.createWidgetTableEnd());
        return result.toString();
    }

    protected void defineWidgets() {
        this.setKeyPrefix(KEY_PREFIX);
        this.setFilename(this.getDownloadFile().getName());
        this.setFilesize("" + this.getDownloadFile().length());
        this.setFilepath(this.getDownloadFile().getAbsolutePath());
        this.setFiledate(CmsDateUtil.getDateTime((Date)new Date(this.getDownloadFile().lastModified()), (int)2, (Locale)this.getLocale()));
        this.addWidget(new CmsWidgetDialogParameter((Object)this, "filename", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
        this.addWidget(new CmsWidgetDialogParameter((Object)this, "filesize", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
        this.addWidget(new CmsWidgetDialogParameter((Object)this, "filepath", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
        this.addWidget(new CmsWidgetDialogParameter((Object)this, "filedate", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
    }

    protected File getDownloadFile() throws CmsRuntimeException {
        if (this.m_downloadFile == null) {
            CmsRfsFileViewer fileView = OpenCms.getWorkplaceManager().getFileViewSettings();
            this.m_downloadFile = new File(fileView.getFilePath());
            try {
                this.m_downloadFile = this.m_downloadFile.getCanonicalFile();
            }
            catch (IOException ioex) {
                throw new CmsRuntimeException(Messages.get().container("ERR_FILE_ACCESS_0"), (Throwable)ioex);
            }
        }
        return this.m_downloadFile;
    }

    protected String[] getPageArray() {
        return PAGES;
    }

    protected void initMessages() {
        super.initMessages();
        this.addMessages(Messages.get().getBundleName());
    }
}

