/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.workplace.rfsfile;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.configuration.CmsWorkplaceConfiguration;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsSystemInfo;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.CmsCheckboxWidget;
import org.opencms.widgets.CmsComboWidget;
import org.opencms.widgets.CmsSelectWidgetOption;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.workplace.CmsWidgetDialogParameter;
import org.opencms.workplace.tools.workplace.rfsfile.A_CmsRfsFileWidgetDialog;

public class CmsRfsFileViewSettingsDialog
extends A_CmsRfsFileWidgetDialog {
    public static final String KEY_PREFIX = "logfile";

    public CmsRfsFileViewSettingsDialog(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsRfsFileViewSettingsDialog(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionCommit() {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        try {
            OpenCms.getWorkplaceManager().setFileViewSettings(this.getCms(), this.m_logView);
            OpenCms.writeConfiguration((Class)CmsWorkplaceConfiguration.class);
            this.setDialogObject(null);
        }
        catch (Throwable t) {
            errors.add(t);
        }
        this.setCommitErrors(errors);
    }

    protected String createDialogHtml(String dialog) {
        StringBuffer result = new StringBuffer(1024);
        result.append(this.createWidgetTableStart());
        result.append(this.createWidgetErrorHeader());
        result.append(this.dialogBlockStart(this.key("GUI_WORKPLACE_LOGVIEW_SETTINGS_NAME_0")));
        result.append(this.createWidgetTableStart());
        result.append(this.createDialogRowsHtml(0, 4));
        result.append(this.createWidgetTableEnd());
        result.append(this.dialogBlockEnd());
        result.append(this.createWidgetTableEnd());
        return result.toString();
    }

    protected void defineWidgets() {
        this.setKeyPrefix(KEY_PREFIX);
        super.defineWidgets();
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_logView, "isLogfile", "page1", (I_CmsWidget)new CmsCheckboxWidget(CmsStringUtil.TRUE)));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_logView, "filePath", "page1", (I_CmsWidget)new CmsComboWidget(this.createComboConfigurationFileChoice())));
        LinkedList<CmsSelectWidgetOption> comboOptions = new LinkedList<CmsSelectWidgetOption>();
        comboOptions.add(new CmsSelectWidgetOption("100"));
        comboOptions.add(new CmsSelectWidgetOption("200"));
        comboOptions.add(new CmsSelectWidgetOption("400"));
        comboOptions.add(new CmsSelectWidgetOption("600"));
        comboOptions.add(new CmsSelectWidgetOption("800"));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_logView, "windowSize", "page1", (I_CmsWidget)new CmsComboWidget(comboOptions)));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_logView, "fileEncoding", "page1", (I_CmsWidget)new CmsComboWidget(this.createComboConfigurationEncodingChoice())));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_logView, "enabled", "page1", (I_CmsWidget)new CmsCheckboxWidget()));
    }

    private List createComboConfigurationEncodingChoice() {
        LinkedList<CmsSelectWidgetOption> result = new LinkedList<CmsSelectWidgetOption>();
        SortedMap<String, Charset> csMap = Charset.availableCharsets();
        Charset defaultCs = Charset.forName(new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding());
        Iterator<Charset> it = csMap.values().iterator();
        while (it.hasNext()) {
            Charset cs = it.next();
            if (cs == defaultCs) {
                result.add(new CmsSelectWidgetOption(cs.name(), true, null, this.key("GUI_WORKPLACE_LOGVIEW_FILE_CHARSET_DEF_HELP_0")));
                continue;
            }
            if (cs.name().startsWith("x")) continue;
            result.add(new CmsSelectWidgetOption(cs.name(), false, null, this.key("GUI_WORKPLACE_LOGVIEW_FILE_CHARSET_HELP_0")));
        }
        return result;
    }

    private List createComboConfigurationFileChoice() {
        LinkedList<CmsSelectWidgetOption> result = new LinkedList<CmsSelectWidgetOption>();
        CmsSystemInfo sysInfo = OpenCms.getSystemInfo();
        result.add(new CmsSelectWidgetOption(sysInfo.getLogFileRfsPath(), true, null, this.key("GUI_WORKPLACE_LOGVIEW_FILE_LOG_HELP_0")));
        result.add(new CmsSelectWidgetOption(sysInfo.getConfigurationFileRfsPath(), false, null, this.key("GUI_WORKPLACE_LOGVIEW_FILE_CONF_HELP_0")));
        String configPath = sysInfo.getAbsoluteRfsPathRelativeToWebInf(CmsSystemInfo.FOLDER_CONFIG);
        if (configPath != null) {
            File configFolder = new File(configPath);
            File[] configFiles = configFolder.listFiles();
            for (int i = 0; i < configFiles.length; ++i) {
                File configFile = configFiles[i];
                if (!configFile.isFile() || !configFile.getName().endsWith(".xml")) continue;
                result.add(new CmsSelectWidgetOption(configFile.getAbsolutePath(), false, null, this.key("GUI_WORKPLACE_LOGVIEW_FILE_XMLCONF_HELP_0")));
            }
        }
        return result;
    }
}

