/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.searchindex;

import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.configuration.CmsSearchConfiguration;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsIllegalStateException;
import org.opencms.main.OpenCms;
import org.opencms.search.CmsSearchIndexSource;
import org.opencms.search.CmsSearchManager;
import org.opencms.workplace.CmsWidgetDialog;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.tools.searchindex.Messages;

public abstract class A_CmsEditIndexSourceDialog
extends CmsWidgetDialog {
    public static final String KEY_PREFIX = "indexsource";
    protected static final String[] PAGES = new String[]{"page1"};
    public static final String PARAM_INDEXSOURCE = "indexsource";
    protected CmsSearchIndexSource m_indexsource;
    protected CmsSearchManager m_searchManager;
    private String m_paramIndexSource;

    public A_CmsEditIndexSourceDialog(CmsJspActionElement jsp) {
        super(jsp);
    }

    public A_CmsEditIndexSourceDialog(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    protected static void writeConfiguration() {
        OpenCms.writeConfiguration((Class)CmsSearchConfiguration.class);
    }

    public void actionCommit() {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        try {
            if (!this.m_searchManager.getSearchIndexSources().keySet().contains(this.m_indexsource.getName())) {
                this.m_searchManager.addSearchIndexSource(this.m_indexsource);
            }
            A_CmsEditIndexSourceDialog.writeConfiguration();
        }
        catch (Throwable t) {
            errors.add(t);
        }
        this.setCommitErrors(errors);
    }

    public String getParamIndexsource() {
        return this.m_paramIndexSource;
    }

    public void setParamIndexsource(String indexsource) {
        this.m_paramIndexSource = indexsource;
    }

    protected void defineWidgets() {
        this.initUserObject();
        this.setKeyPrefix("indexsource");
    }

    protected String[] getPageArray() {
        return PAGES;
    }

    protected String getToolPath() {
        return "/searchindex/indexsources/indexsource";
    }

    protected void initMessages() {
        this.addMessages(Messages.get().getBundleName());
        super.initMessages();
    }

    protected void initUserObject() {
        if (this.m_indexsource == null) {
            try {
                this.m_indexsource = this.m_searchManager.getIndexSource(this.getParamIndexsource());
                if (this.m_indexsource == null) {
                    this.m_indexsource = new CmsSearchIndexSource();
                }
            }
            catch (Exception e) {
                this.m_indexsource = new CmsSearchIndexSource();
            }
        }
    }

    protected void initWorkplaceMembers(CmsJspActionElement jsp) {
        this.m_searchManager = OpenCms.getSearchManager();
        super.initWorkplaceMembers(jsp);
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        super.initWorkplaceRequestValues(settings, request);
        HashMap<String, CmsSearchIndexSource> dialogObject = (HashMap<String, CmsSearchIndexSource>)this.getDialogObject();
        if (dialogObject == null) {
            dialogObject = new HashMap<String, CmsSearchIndexSource>();
            dialogObject.put("indexsource", this.m_indexsource);
            this.setDialogObject(dialogObject);
        }
    }

    protected boolean isNewIndexSource() {
        return "initial".equals(this.getParamAction());
    }

    protected void validateParamaters() throws Exception {
        if (!this.isNewIndexSource() && this.getParamIndexsource() == null && this.getJsp().getRequest().getParameter("name.0") == null) {
            throw new CmsIllegalStateException(Messages.get().container("ERR_SEARCHINDEX_EDIT_MISSING_PARAM_1", (Object)"indexsource"));
        }
    }
}

