/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.searchindex;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.configuration.CmsSearchConfiguration;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsIllegalStateException;
import org.opencms.main.OpenCms;
import org.opencms.search.CmsSearchManager;
import org.opencms.search.fields.CmsSearchField;
import org.opencms.search.fields.CmsSearchFieldConfiguration;
import org.opencms.workplace.CmsWidgetDialog;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.tools.searchindex.Messages;

public class A_CmsFieldConfigurationDialog
extends CmsWidgetDialog {
    public static final String KEY_PREFIX = "fieldconfiguration";
    public static final String[] PAGES = new String[]{"page1"};
    public static final String PARAM_FIELDCONFIGURATION = "fieldconfiguration";
    protected CmsSearchFieldConfiguration m_fieldconfiguration;
    protected CmsSearchManager m_searchManager;
    private String m_paramFieldConfiguration;

    public A_CmsFieldConfigurationDialog(CmsJspActionElement jsp) {
        super(jsp);
    }

    public A_CmsFieldConfigurationDialog(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    protected static void writeConfiguration() {
        OpenCms.writeConfiguration((Class)CmsSearchConfiguration.class);
    }

    public void actionCommit() {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        try {
            if (this.m_searchManager.getFieldConfiguration(this.m_fieldconfiguration.getName()) == null) {
                this.m_searchManager.addFieldConfiguration(this.m_fieldconfiguration);
            }
            if (this.checkWriteConfiguration()) {
                A_CmsFieldConfigurationDialog.writeConfiguration();
            }
        }
        catch (Throwable t) {
            errors.add(t);
        }
        this.setCommitErrors(errors);
    }

    public String getParamFieldconfiguration() {
        return this.m_paramFieldConfiguration;
    }

    public void setParamFieldconfiguration(String fieldconfiguration) {
        this.m_paramFieldConfiguration = fieldconfiguration;
    }

    protected String createDialogHtml(String dialog) {
        StringBuffer result = new StringBuffer(1024);
        result.append(this.createWidgetTableStart());
        result.append(this.createWidgetErrorHeader());
        if (dialog.equals(PAGES[0])) {
            result.append(this.dialogBlockStart(this.key("GUI_LABEL_FIELDCONFIGURATION_BLOCK_SETTINGS_0")));
            result.append(this.createWidgetTableStart());
            result.append(this.createDialogRowsHtml(0, 0));
            result.append(this.createWidgetTableEnd());
            result.append(this.dialogBlockEnd());
        }
        result.append(this.createWidgetTableEnd());
        return result.toString();
    }

    protected String defaultActionHtmlEnd() {
        return "";
    }

    protected void defineWidgets() {
        this.initUserObject();
        this.setKeyPrefix("fieldconfiguration");
    }

    protected String[] getPageArray() {
        return PAGES;
    }

    protected String getToolPath() {
        return "/searchindex/fieldconfigurations/fieldconfiguration";
    }

    protected void initMessages() {
        this.addMessages(Messages.get().getBundleName());
        super.initMessages();
    }

    protected void initUserObject() {
        if (this.m_fieldconfiguration == null) {
            try {
                this.m_fieldconfiguration = this.m_searchManager.getFieldConfiguration(this.getParamFieldconfiguration());
                if (this.m_fieldconfiguration == null) {
                    this.m_fieldconfiguration = new CmsSearchFieldConfiguration();
                }
            }
            catch (Exception e) {
                this.m_fieldconfiguration = new CmsSearchFieldConfiguration();
            }
        }
    }

    protected void initWorkplaceMembers(CmsJspActionElement jsp) {
        this.m_searchManager = OpenCms.getSearchManager();
        super.initWorkplaceMembers(jsp);
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        super.initWorkplaceRequestValues(settings, request);
        HashMap<String, CmsSearchFieldConfiguration> dialogObject = (HashMap<String, CmsSearchFieldConfiguration>)this.getDialogObject();
        if (dialogObject == null) {
            dialogObject = new HashMap<String, CmsSearchFieldConfiguration>();
            dialogObject.put("fieldconfiguration", this.m_fieldconfiguration);
            this.setDialogObject(dialogObject);
        }
    }

    protected boolean isNewFieldConfiguration() {
        return "initial".equals(this.getParamAction());
    }

    protected void validateParamaters() throws Exception {
        if (!this.isNewFieldConfiguration() && this.getParamFieldconfiguration() == null && this.getJsp().getRequest().getParameter("name.0") == null) {
            throw new CmsIllegalStateException(Messages.get().container("ERR_SEARCHINDEX_EDIT_MISSING_PARAM_1", (Object)"fieldconfiguration"));
        }
    }

    private boolean checkWriteConfiguration() {
        if (!this.m_fieldconfiguration.getFields().isEmpty()) {
            Iterator itFields = this.m_fieldconfiguration.getFields().iterator();
            while (itFields.hasNext()) {
                CmsSearchField field = (CmsSearchField)itFields.next();
                if (!field.getMappings().isEmpty()) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

