/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.searchindex;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.configuration.CmsSearchConfiguration;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsIllegalStateException;
import org.opencms.main.OpenCms;
import org.opencms.search.CmsSearchManager;
import org.opencms.search.fields.CmsSearchField;
import org.opencms.search.fields.CmsSearchFieldConfiguration;
import org.opencms.search.fields.CmsSearchFieldMapping;
import org.opencms.workplace.CmsWidgetDialog;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.tools.searchindex.Messages;

public class A_CmsMappingDialog
extends CmsWidgetDialog {
    public static final String KEY_PREFIX = "fieldconfiguration.field.mapping";
    public static final String[] PAGES = new String[]{"page1"};
    public static final String PARAM_FIELD = "field";
    public static final String PARAM_FIELDCONFIGURATION = "fieldconfiguration";
    public static final String PARAM_PARAM = "param";
    public static final String PARAM_TYPE = "type";
    protected CmsSearchField m_field;
    protected CmsSearchFieldConfiguration m_fieldconfiguration;
    protected CmsSearchFieldMapping m_mapping;
    protected CmsSearchManager m_searchManager;
    private String m_paramField;
    private String m_paramFieldConfiguration;
    private String m_paramParam;
    private String m_paramType;

    public A_CmsMappingDialog(CmsJspActionElement jsp) {
        super(jsp);
    }

    public A_CmsMappingDialog(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    protected static void writeConfiguration() {
        OpenCms.writeConfiguration((Class)CmsSearchConfiguration.class);
    }

    public void actionCommit() {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        try {
            boolean found = false;
            Iterator itMappings = this.m_field.getMappings().iterator();
            while (itMappings.hasNext()) {
                CmsSearchFieldMapping curMapping = (CmsSearchFieldMapping)itMappings.next();
                if (!curMapping.getType().toString().equals(this.m_mapping.getType().toString()) || (curMapping.getParam() != null || this.m_mapping.getParam() != null) && !curMapping.getParam().equals(this.m_mapping.getParam())) continue;
                found = true;
            }
            if (!found) {
                this.m_field.addMapping(this.m_mapping);
            }
            A_CmsMappingDialog.writeConfiguration();
        }
        catch (Throwable t) {
            errors.add(t);
        }
        this.setCommitErrors(errors);
    }

    public String getParamField() {
        return this.m_paramField;
    }

    public String getParamFieldconfiguration() {
        return this.m_paramFieldConfiguration;
    }

    public String getParamParam() {
        return this.m_paramParam;
    }

    public String getParamType() {
        return this.m_paramType;
    }

    public void setParamField(String field) {
        this.m_paramField = field;
    }

    public void setParamFieldconfiguration(String fieldconfiguration) {
        this.m_paramFieldConfiguration = fieldconfiguration;
    }

    public void setParamParam(String param) {
        this.m_paramParam = param;
    }

    public void setParamType(String type) {
        this.m_paramType = type;
    }

    protected String defaultActionHtmlEnd() {
        return "";
    }

    protected void defineWidgets() {
        this.initUserObject();
        this.setKeyPrefix(KEY_PREFIX);
    }

    protected String[] getPageArray() {
        return PAGES;
    }

    protected void initUserObject() {
        if (this.m_fieldconfiguration == null) {
            try {
                this.m_fieldconfiguration = this.m_searchManager.getFieldConfiguration(this.getParamFieldconfiguration());
                if (this.m_fieldconfiguration == null) {
                    this.m_fieldconfiguration = new CmsSearchFieldConfiguration();
                }
            }
            catch (Exception e) {
                this.m_fieldconfiguration = new CmsSearchFieldConfiguration();
            }
        }
        if (this.m_field == null) {
            try {
                Iterator itFields = this.m_fieldconfiguration.getFields().iterator();
                while (itFields.hasNext()) {
                    CmsSearchField curField = (CmsSearchField)itFields.next();
                    if (!curField.getName().equals(this.getParamField())) continue;
                    this.m_field = curField;
                    break;
                }
                if (this.m_field == null) {
                    this.m_field = new CmsSearchField();
                }
            }
            catch (Exception e) {
                this.m_field = new CmsSearchField();
            }
        }
        if (this.m_mapping == null) {
            try {
                Iterator itMappings = this.m_field.getMappings().iterator();
                while (itMappings.hasNext()) {
                    CmsSearchFieldMapping curMapping = (CmsSearchFieldMapping)itMappings.next();
                    if (!curMapping.getType().toString().equals(this.getParamType()) || (curMapping.getParam() != null || !this.getParamParam().equals("-")) && !curMapping.getParam().equals(this.getParamParam())) continue;
                    this.m_mapping = curMapping;
                    break;
                }
                if (this.m_mapping == null) {
                    this.m_mapping = new CmsSearchFieldMapping();
                }
            }
            catch (Exception e) {
                this.m_mapping = new CmsSearchFieldMapping();
            }
        }
    }

    protected void initWorkplaceMembers(CmsJspActionElement jsp) {
        this.m_searchManager = OpenCms.getSearchManager();
        super.initWorkplaceMembers(jsp);
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        super.initWorkplaceRequestValues(settings, request);
        HashMap<String, Object> dialogObject = (HashMap<String, Object>)this.getDialogObject();
        if (dialogObject == null) {
            dialogObject = new HashMap<String, Object>();
            dialogObject.put(PARAM_FIELDCONFIGURATION, this.m_fieldconfiguration);
            dialogObject.put(PARAM_FIELD, this.m_field);
            dialogObject.put(PARAM_PARAM, this.m_mapping.getParam());
            if (this.m_mapping.getType() != null) {
                dialogObject.put(PARAM_TYPE, this.m_mapping.getType().toString());
            } else {
                dialogObject.put(PARAM_TYPE, this.m_mapping.getType());
            }
            this.setDialogObject(dialogObject);
        }
    }

    protected boolean isNewMapping() {
        return "initial".equals(this.getParamAction());
    }

    protected void validateParamaters() throws Exception {
        if (!this.isNewMapping() && this.getParamField() == null && this.getJsp().getRequest().getParameter("name.0") == null) {
            throw new CmsIllegalStateException(Messages.get().container("ERR_SEARCHINDEX_EDIT_MISSING_PARAM_1", (Object)PARAM_FIELD));
        }
    }
}

