/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.searchindex;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.file.CmsProject;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.search.fields.CmsSearchFieldConfiguration;
import org.opencms.widgets.CmsDisplayWidget;
import org.opencms.widgets.CmsInputWidget;
import org.opencms.widgets.CmsSelectWidget;
import org.opencms.widgets.CmsSelectWidgetOption;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.workplace.CmsWidgetDialogParameter;
import org.opencms.workplace.tools.searchindex.A_CmsEditSearchIndexDialog;

public class CmsEditSearchIndexDialog
extends A_CmsEditSearchIndexDialog {
    public CmsEditSearchIndexDialog(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsEditSearchIndexDialog(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    protected String createDialogHtml(String dialog) {
        StringBuffer result = new StringBuffer(1024);
        result.append(this.createWidgetTableStart());
        result.append(this.createWidgetErrorHeader());
        if (dialog.equals(PAGES[0])) {
            result.append(this.dialogBlockStart(this.key("GUI_LABEL_SEARCHINDEX_BLOCK_SETTINGS_0")));
            result.append(this.createWidgetTableStart());
            result.append(this.createDialogRowsHtml(0, 4));
            result.append(this.createWidgetTableEnd());
            result.append(this.dialogBlockEnd());
        }
        result.append(this.createWidgetTableEnd());
        return result.toString();
    }

    protected void defineWidgets() {
        super.defineWidgets();
        if (this.m_index == null || this.m_index.getName() == null) {
            this.addWidget(new CmsWidgetDialogParameter((Object)this.m_index, "name", PAGES[0], (I_CmsWidget)new CmsInputWidget()));
        } else {
            this.addWidget(new CmsWidgetDialogParameter((Object)this.m_index, "name", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
        }
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_index, "rebuildMode", "", PAGES[0], (I_CmsWidget)new CmsSelectWidget(this.getRebuildModeWidgetConfiguration()), 0, 1));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_index, "localeString", "", PAGES[0], (I_CmsWidget)new CmsSelectWidget(this.getLocaleWidgetConfiguration()), 0, 1));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_index, "project", "", PAGES[0], (I_CmsWidget)new CmsSelectWidget(this.getProjectWidgetConfiguration()), 0, 1));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_index, "fieldConfigurationName", "", PAGES[0], (I_CmsWidget)new CmsSelectWidget(this.getFieldConfigurationWidgetConfiguration()), 0, 1));
    }

    private List getFieldConfigurationWidgetConfiguration() {
        ArrayList<CmsSelectWidgetOption> result = new ArrayList<CmsSelectWidgetOption>();
        List fieldConfigurations = this.m_searchManager.getFieldConfigurations();
        Iterator itFieldConfigs = fieldConfigurations.iterator();
        while (itFieldConfigs.hasNext()) {
            CmsSearchFieldConfiguration curFieldConfig = (CmsSearchFieldConfiguration)itFieldConfigs.next();
            CmsSelectWidgetOption option = new CmsSelectWidgetOption(curFieldConfig.getName(), curFieldConfig.getName().equals("standard"));
            result.add(option);
        }
        return result;
    }

    private List getLocaleWidgetConfiguration() {
        ArrayList<CmsSelectWidgetOption> result = new ArrayList<CmsSelectWidgetOption>();
        Locale indexLocale = this.m_index.getLocale();
        Iterator analyzers = this.m_searchManager.getAnalyzers().keySet().iterator();
        HashSet distinctLocales = new HashSet();
        while (analyzers.hasNext()) {
            distinctLocales.add(analyzers.next());
        }
        Iterator locales = distinctLocales.iterator();
        while (locales.hasNext()) {
            Locale locale = (Locale)locales.next();
            CmsSelectWidgetOption option = new CmsSelectWidgetOption(locale.toString(), locale.equals(indexLocale));
            result.add(option);
        }
        return result;
    }

    private List getProjectWidgetConfiguration() {
        ArrayList<CmsSelectWidgetOption> result = new ArrayList<CmsSelectWidgetOption>();
        try {
            List projects = OpenCms.getOrgUnitManager().getAllManageableProjects(this.getCms(), "", true);
            projects.add(this.getCms().readProject(CmsProject.ONLINE_PROJECT_ID));
            Iterator itProjects = projects.iterator();
            String project = this.m_index.getProject();
            while (itProjects.hasNext()) {
                String curProject = ((CmsProject)itProjects.next()).getName();
                CmsSelectWidgetOption option = new CmsSelectWidgetOption(curProject, curProject.equals(project));
                result.add(option);
            }
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
        return result;
    }

    private List getRebuildModeWidgetConfiguration() {
        ArrayList<CmsSelectWidgetOption> result = new ArrayList<CmsSelectWidgetOption>();
        String rebuildMode = this.m_index.getRebuildMode();
        CmsSelectWidgetOption option = new CmsSelectWidgetOption("auto", "auto".equals(rebuildMode));
        result.add(option);
        option = new CmsSelectWidgetOption("manual", "manual".equals(rebuildMode));
        result.add(option);
        return result;
    }
}

