/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.searchindex;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public abstract class CmsHookList
extends LinkedList {
    private Object m_peer;

    public CmsHookList(Object peer) {
        this.m_peer = peer;
    }

    public CmsHookList(Object peer, Collection c) {
        super(c);
        this.m_peer = peer;
    }

    public void add(int index, Object element) {
        super.add(index, element);
        this.onAdded(this.m_peer, index, element);
    }

    public boolean add(Object o) {
        if (super.add(o)) {
            this.onAdded(this.m_peer, o);
            return true;
        }
        return false;
    }

    public void clear() {
        this.onClear(this.m_peer);
        super.clear();
        this.onCleared(this.m_peer);
    }

    public Object get(int index) {
        Object ret = super.get(index);
        this.onGetCall(this.m_peer, index);
        return ret;
    }

    public Iterator iterator() {
        Iterator it = super.iterator();
        this.onIteratorCall(this.m_peer);
        return it;
    }

    public Object remove(int index) {
        Object ret = null;
        ret = super.remove(index);
        return ret;
    }

    protected abstract void onAdded(Object var1, int var2, Object var3);

    protected abstract void onAdded(Object var1, Object var2);

    protected abstract void onClear(Object var1);

    protected abstract void onCleared(Object var1);

    protected abstract void onGetCall(Object var1, int var2);

    protected abstract void onIteratorCall(Object var1);

    protected abstract void onRemoved(Object var1, int var2);
}

