/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.searchindex;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.opencms.file.CmsObject;
import org.opencms.main.OpenCms;
import org.opencms.report.A_CmsReportThread;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.tools.searchindex.Messages;

public class CmsIndexingReportThread
extends A_CmsReportThread {
    private Throwable m_error;
    private List m_indexNames;

    public CmsIndexingReportThread(CmsObject cms, List indexNames) {
        super(cms, Messages.get().getBundle().key("GUI_INDEXING_THREAD_NAME_0"));
        this.initHtmlReport(cms.getRequestContext().getLocale());
        this.m_indexNames = indexNames;
    }

    public Throwable getError() {
        return this.m_error;
    }

    public String getReportUpdate() {
        return this.getReport().getReportUpdate();
    }

    public void run() {
        this.getReport().println(Messages.get().container("RPT_REBUILD_SEARCH_INDEXES_BEGIN_0"), 2);
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("report", this.getReport());
            if (this.m_indexNames != null) {
                params.put("indexNames", CmsStringUtil.collectionAsString((Collection)this.m_indexNames, (String)","));
            }
            OpenCms.fireCmsEvent((int)32, params);
            this.getReport().println(Messages.get().container("RPT_REBUILD_SEARCH_INDEXES_END_0"), 2);
        }
        catch (Throwable exc) {
            this.getReport().println(org.opencms.search.Messages.get().container("RPT_SEARCH_INDEXING_FAILED_0"), 1);
            this.getReport().println(exc);
            this.m_error = exc;
        }
    }
}

