/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.searchindex;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsSearchConfiguration;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.search.CmsSearchManager;
import org.opencms.search.fields.CmsSearchField;
import org.opencms.search.fields.CmsSearchFieldConfiguration;
import org.opencms.search.fields.CmsSearchFieldMapping;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.list.CmsListColumnAlignEnum;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListDefaultAction;
import org.opencms.workplace.list.CmsListDirectAction;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListMultiAction;
import org.opencms.workplace.list.CmsListOrderEnum;
import org.opencms.workplace.list.I_CmsListDirectAction;
import org.opencms.workplace.tools.searchindex.A_CmsEmbeddedListDialog;
import org.opencms.workplace.tools.searchindex.Messages;

public class CmsMappingsList
extends A_CmsEmbeddedListDialog {
    public static final String LIST_ACTION_EDIT = "ae";
    public static final String LIST_ACTION_EDITTYPE = "aet";
    public static final String LIST_ACTION_EDITVALUE = "aev";
    public static final String LIST_COLUMN_DEFAULT = "cd";
    public static final String LIST_COLUMN_ICON = "ci";
    public static final String LIST_COLUMN_TYPE = "ct";
    public static final String LIST_COLUMN_VALUE = "cv";
    public static final String LIST_ID = "lsfcfm";
    public static final String LIST_MACTION_DELETEMAPPING = "mad";
    protected static final String LIST_ICON_MAPPING = "tools/searchindex/icons/small/fieldconfiguration-mapping.png";
    private static final Log LOG = CmsLog.getLog((Object)CmsMappingsList.class);
    private String m_paramField;
    private String m_paramFieldconfiguration;

    public CmsMappingsList(CmsJspActionElement jsp) {
        this(jsp, LIST_ID, Messages.get().container("GUI_LIST_MAPPINGS_NAME_0"));
    }

    public CmsMappingsList(CmsJspActionElement jsp, String listId, CmsMessageContainer listName) {
        this(jsp, listId, listName, LIST_COLUMN_TYPE, CmsListOrderEnum.ORDER_ASCENDING, null);
    }

    public CmsMappingsList(CmsJspActionElement jsp, String listId, CmsMessageContainer listName, String sortedColId, CmsListOrderEnum sortOrder, String searchableColId) {
        super(jsp, listId, listName, sortedColId, sortOrder, searchableColId);
    }

    public void executeListMultiActions() {
        CmsSearchManager searchManager = OpenCms.getSearchManager();
        if (this.getParamListAction().equals(LIST_MACTION_DELETEMAPPING)) {
            List fields = searchManager.getFieldConfiguration(this.m_paramFieldconfiguration).getFields();
            Iterator itFields = fields.iterator();
            while (itFields.hasNext()) {
                CmsSearchField curField = (CmsSearchField)itFields.next();
                if (!curField.getName().equals(this.m_paramField)) continue;
                ArrayList<CmsSearchFieldMapping> deleteMappings = new ArrayList<CmsSearchFieldMapping>();
                Iterator itItems = this.getSelectedItems().iterator();
                while (itItems.hasNext()) {
                    CmsListItem listItem = (CmsListItem)itItems.next();
                    Iterator itMappings = curField.getMappings().iterator();
                    while (itMappings.hasNext()) {
                        CmsSearchFieldMapping curMapping = (CmsSearchFieldMapping)itMappings.next();
                        String itemValue = (String)listItem.get(LIST_COLUMN_VALUE);
                        String itemType = (String)listItem.get(LIST_COLUMN_TYPE);
                        if (!curMapping.getType().toString().equals(itemType) || (curMapping.getParam() != null || itemValue != null) && !curMapping.getParam().equals(itemValue)) continue;
                        deleteMappings.add(curMapping);
                    }
                }
                Iterator itMappings = deleteMappings.iterator();
                while (itMappings.hasNext()) {
                    CmsSearchFieldMapping mapping = (CmsSearchFieldMapping)itMappings.next();
                    searchManager.removeSearchFieldMapping(curField, mapping);
                }
                break block0;
            }
            this.refreshList();
            this.writeConfiguration(false);
        }
        this.listSave();
    }

    public void executeListSingleActions() throws ServletException, IOException {
        CmsListItem item = this.getSelectedItem();
        HashMap<String, Object> params = new HashMap<String, Object>();
        String action = this.getParamListAction();
        params.put("field", this.m_paramField);
        params.put("fieldconfiguration", this.m_paramFieldconfiguration);
        params.put("type", item.get(LIST_COLUMN_TYPE));
        params.put("param", item.get(LIST_COLUMN_VALUE));
        params.put("action", "initial");
        params.put("style", "new");
        if (action.equals(LIST_ACTION_EDIT) || action.equals(LIST_ACTION_EDITTYPE) || action.equals(LIST_ACTION_EDITVALUE)) {
            this.getToolManager().jspForwardTool((CmsWorkplace)this, "/searchindex/fieldconfigurations/fieldconfiguration/field/editmapping", params);
        }
        this.listSave();
    }

    public String getParamField() {
        return this.m_paramField;
    }

    public String getParamFieldconfiguration() {
        return this.m_paramFieldconfiguration;
    }

    public void setParamField(String field) {
        this.m_paramField = field;
    }

    public void setParamFieldconfiguration(String fieldconfiguration) {
        this.m_paramFieldconfiguration = fieldconfiguration;
    }

    protected void fillDetails(String detailId) {
    }

    protected List getListItems() {
        ArrayList<CmsListItem> result = new ArrayList<CmsListItem>();
        List mappings = this.getMappings();
        Iterator itMappings = mappings.iterator();
        while (itMappings.hasNext()) {
            CmsSearchFieldMapping mapping = (CmsSearchFieldMapping)itMappings.next();
            CmsListItem item = this.getList().newItem(mapping.getType().toString());
            String defaultValue = mapping.getDefaultValue();
            String param = mapping.getParam();
            if (defaultValue == null) {
                defaultValue = "-";
            }
            if (param == null) {
                param = "-";
            }
            item.set(LIST_COLUMN_VALUE, (Object)param);
            item.set(LIST_COLUMN_TYPE, (Object)mapping.getType().toString());
            item.set(LIST_COLUMN_DEFAULT, (Object)defaultValue);
            result.add(item);
        }
        return result;
    }

    protected void setColumns(CmsListMetadata metadata) {
        CmsListColumnDefinition dummyCol = new CmsListColumnDefinition(LIST_COLUMN_ICON);
        dummyCol.setName(Messages.get().container("GUI_LIST_FIELD_COL_MAPPING_0"));
        dummyCol.setHelpText(Messages.get().container("GUI_LIST_MAPPING_COL_EDIT_NAME_HELP_0"));
        dummyCol.setWidth("20");
        dummyCol.setAlign(CmsListColumnAlignEnum.ALIGN_LEFT);
        dummyCol.setSorteable(false);
        CmsListDirectAction editAction = new CmsListDirectAction(LIST_ACTION_EDIT);
        editAction.setName(Messages.get().container("GUI_LIST_MAPPING_COL_EDIT_NAME_0"));
        editAction.setHelpText(Messages.get().container("GUI_LIST_MAPPING_COL_EDIT_NAME_HELP_0"));
        editAction.setIconPath(LIST_ICON_MAPPING);
        dummyCol.addDirectAction((I_CmsListDirectAction)editAction);
        metadata.addColumn(dummyCol);
        CmsListColumnDefinition valueCol = new CmsListColumnDefinition(LIST_COLUMN_VALUE);
        valueCol.setAlign(CmsListColumnAlignEnum.ALIGN_LEFT);
        valueCol.setName(Messages.get().container("GUI_LIST_MAPPING_COL_VALUE_0"));
        valueCol.setWidth("33%");
        valueCol.setSorteable(true);
        CmsListDefaultAction editValueAction = new CmsListDefaultAction(LIST_ACTION_EDITVALUE);
        editValueAction.setName(Messages.get().container("GUI_LIST_FIELD_COL_MAPPING_0"));
        editValueAction.setHelpText(Messages.get().container("GUI_LIST_MAPPING_COL_EDIT_NAME_HELP_0"));
        valueCol.addDefaultAction(editValueAction);
        metadata.addColumn(valueCol);
        CmsListColumnDefinition typeCol = new CmsListColumnDefinition(LIST_COLUMN_TYPE);
        typeCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        typeCol.setName(Messages.get().container("GUI_LIST_MAPPING_COL_TYPE_0"));
        typeCol.setWidth("33%");
        CmsListDefaultAction editTypeAction = new CmsListDefaultAction(LIST_ACTION_EDITTYPE);
        editTypeAction.setName(Messages.get().container("GUI_LIST_FIELD_COL_MAPPING_0"));
        editTypeAction.setHelpText(Messages.get().container("GUI_LIST_MAPPING_COL_EDIT_NAME_HELP_0"));
        typeCol.addDefaultAction(editTypeAction);
        metadata.addColumn(typeCol);
        CmsListColumnDefinition defaultCol = new CmsListColumnDefinition(LIST_COLUMN_DEFAULT);
        defaultCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        defaultCol.setName(Messages.get().container("GUI_LIST_MAPPING_COL_DEFAULT_0"));
        defaultCol.setWidth("33%");
        metadata.addColumn(defaultCol);
    }

    protected void setIndependentActions(CmsListMetadata metadata) {
    }

    protected void setMultiActions(CmsListMetadata metadata) {
        CmsListMultiAction deleteMultiAction = new CmsListMultiAction(LIST_MACTION_DELETEMAPPING);
        deleteMultiAction.setName(Messages.get().container("GUI_LIST_FIELD_MACTION_DELETEMAPPING_NAME_0"));
        deleteMultiAction.setHelpText(Messages.get().container("GUI_LIST_FIELD_MACTION_DELETEMAPPING_NAME_HELP_0"));
        deleteMultiAction.setConfirmationMessage(Messages.get().container("GUI_LIST_FIELD_MACTION_DELETEMAPPING_CONF_0"));
        deleteMultiAction.setIconPath("list/multi_delete.png");
        metadata.addMultiAction(deleteMultiAction);
    }

    protected void writeConfiguration(boolean refresh) {
        OpenCms.writeConfiguration((Class)CmsSearchConfiguration.class);
        if (refresh) {
            this.refreshList();
        }
    }

    private List getMappings() {
        CmsSearchManager manager = OpenCms.getSearchManager();
        CmsSearchFieldConfiguration fieldConfig = manager.getFieldConfiguration(this.getParamFieldconfiguration());
        List result = null;
        if (fieldConfig != null) {
            Iterator itFields = fieldConfig.getFields().iterator();
            while (itFields.hasNext()) {
                CmsSearchField field = (CmsSearchField)itFields.next();
                if (!field.getName().equals(this.getParamField())) continue;
                result = field.getMappings();
            }
        } else {
            result = new ArrayList(0);
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("ERR_SEARCHINDEX_EDIT_MISSING_PARAM_1", (Object)"fieldconfiguration"));
            }
        }
        return result;
    }
}

