/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.searchindex;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsRuntimeException;
import org.opencms.report.I_CmsReportThread;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.list.A_CmsListReport;
import org.opencms.workplace.tools.CmsToolManager;
import org.opencms.workplace.tools.searchindex.CmsIndexingReportThread;
import org.opencms.workplace.tools.searchindex.Messages;

public class CmsRebuildReport
extends A_CmsListReport {
    public static final String PARAM_INDEXES = "indexes";
    private String m_paramIndexes;

    public CmsRebuildReport(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsRebuildReport(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        super(context, req, res);
    }

    public String getParamIndexes() {
        return this.m_paramIndexes;
    }

    public I_CmsReportThread initializeThread() throws CmsRuntimeException {
        if (this.getParamIndexes() == null) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_SEARCHINDEX_EDIT_MISSING_PARAM_1", (Object)PARAM_INDEXES));
        }
        List indexes = this.extractIndexNames();
        CmsIndexingReportThread thread = new CmsIndexingReportThread(this.getCms(), indexes);
        return thread;
    }

    public void setParamIndexes(String paramIndexes) {
        this.m_paramIndexes = paramIndexes;
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        super.initWorkplaceRequestValues(settings, request);
        List indexes = this.extractIndexNames();
        if (indexes.size() == 1) {
            HashMap params = new HashMap();
            params.put("indexname", indexes.get(0));
            this.setParamCloseLink(CmsToolManager.linkForToolPath((CmsJspActionElement)this.getJsp(), (String)"/searchindex/singleindex", params));
        } else {
            this.setParamCloseLink(CmsToolManager.linkForToolPath((CmsJspActionElement)this.getJsp(), (String)"/searchindex"));
        }
    }

    private List extractIndexNames() {
        ArrayList<String> modules = new ArrayList<String>();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)this.getParamIndexes())) {
            StringTokenizer tok = new StringTokenizer(this.getParamIndexes(), ",");
            while (tok.hasMoreTokens()) {
                String module = tok.nextToken();
                modules.add(module);
            }
        }
        return modules;
    }
}

