/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.searchindex;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsSearchConfiguration;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.search.CmsSearchDocumentType;
import org.opencms.search.CmsSearchIndexSource;
import org.opencms.search.CmsSearchManager;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.list.A_CmsListDialog;
import org.opencms.workplace.list.CmsListColumnAlignEnum;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListDefaultAction;
import org.opencms.workplace.list.CmsListDirectAction;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListItemDetails;
import org.opencms.workplace.list.CmsListItemDetailsFormatter;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListMultiAction;
import org.opencms.workplace.list.CmsListOrderEnum;
import org.opencms.workplace.list.I_CmsListDirectAction;
import org.opencms.workplace.list.I_CmsListFormatter;
import org.opencms.workplace.tools.searchindex.Messages;

public class CmsSearchIndexSourceControlList
extends A_CmsListDialog {
    public static final String LIST_ACTION_DELETE = "ade";
    public static final String LIST_ACTION_DOCUMENTS = "ado";
    public static final String LIST_ACTION_EDIT = "ae";
    public static final String LIST_ACTION_OVERVIEW_INDEXSOURCE = "aois";
    public static final String LIST_ACTION_OVERVIEW_INDEXSOURCE2 = "aois2";
    public static final String LIST_ACTION_RESOURCES = "ar";
    public static final String LIST_COLUMN_DELETE = "cde";
    public static final String LIST_COLUMN_DOCUMENTS = "cdo";
    public static final String LIST_COLUMN_EDIT = "ce";
    public static final String LIST_COLUMN_INDEXER = "ca";
    public static final String LIST_COLUMN_NAME = "cn";
    public static final String LIST_COLUMN_RESOURCES = "cr";
    public static final String LIST_DETAIL_DOCTYPES = "dd";
    public static final String LIST_DETAIL_RESOURCES = "dr";
    public static final String LIST_ID = "lssisc";
    public static final String LIST_MACTION_DELETESOURCE = "mad";
    protected static final String ICON_FOLDER = "tools/searchindex/icons/small/indexsource-resources.png";
    private static final Log LOG = CmsLog.getLog((Object)CmsSearchIndexSourceControlList.class);

    public CmsSearchIndexSourceControlList(CmsJspActionElement jsp) {
        this(jsp, LIST_ID, Messages.get().container("GUI_LIST_INDEXSOURCES_NAME_0"));
    }

    public CmsSearchIndexSourceControlList(CmsJspActionElement jsp, String listId, CmsMessageContainer listName) {
        this(jsp, listId, listName, LIST_COLUMN_NAME, CmsListOrderEnum.ORDER_ASCENDING, null);
    }

    public CmsSearchIndexSourceControlList(CmsJspActionElement jsp, String listId, CmsMessageContainer listName, String sortedColId, CmsListOrderEnum sortOrder, String searchableColId) {
        super(jsp, listId, listName, sortedColId, sortOrder, searchableColId);
    }

    public CmsSearchIndexSourceControlList(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void executeListMultiActions() {
        CmsSearchManager searchManager = OpenCms.getSearchManager();
        if (this.getParamListAction().equals(LIST_MACTION_DELETESOURCE)) {
            Iterator itItems = this.getSelectedItems().iterator();
            while (itItems.hasNext()) {
                CmsListItem listItem = (CmsListItem)itItems.next();
                CmsSearchIndexSource idxsource = searchManager.getIndexSource((String)listItem.get(LIST_COLUMN_NAME));
                searchManager.removeSearchIndexSource(idxsource);
            }
            this.refreshList();
            this.writeConfiguration(false);
        }
        this.listSave();
    }

    public void executeListSingleActions() throws IOException, ServletException {
        String indexSource = this.getSelectedItem().getId();
        HashMap<String, String> params = new HashMap<String, String>();
        String action = this.getParamListAction();
        if (action.equals(LIST_ACTION_EDIT)) {
            params.put("indexsource", indexSource);
            params.put("style", "new");
            this.getToolManager().jspForwardTool((CmsWorkplace)this, "/searchindex/indexsources/indexsource/edit", params);
        } else if (action.equals(LIST_ACTION_DELETE)) {
            params.put("indexsource", indexSource);
            params.put("action", "initial");
            params.put("style", "new");
            this.getToolManager().jspForwardTool((CmsWorkplace)this, "/searchindex/indexsources/indexsource/delete", params);
        } else if (action.equals(LIST_ACTION_RESOURCES)) {
            params.put("indexsource", indexSource);
            params.put("action", "initial");
            params.put("style", "new");
            this.getToolManager().jspForwardTool((CmsWorkplace)this, "/searchindex/indexsources/indexsource/resources", params);
        } else if (action.equals(LIST_ACTION_DOCUMENTS)) {
            params.put("indexsource", indexSource);
            params.put("action", "initial");
            params.put("style", "new");
            this.getToolManager().jspForwardTool((CmsWorkplace)this, "/searchindex/indexsources/indexsource/doctypes", params);
        } else if (action.equals(LIST_ACTION_OVERVIEW_INDEXSOURCE)) {
            params.put("indexsource", indexSource);
            params.put("action", "initial");
            params.put("style", "new");
            this.getToolManager().jspForwardTool((CmsWorkplace)this, "/searchindex/indexsources/indexsource", params);
        }
        this.listSave();
    }

    protected void fillDetails(String detailId) {
        CmsListItem item;
        List items = this.getList().getAllContent();
        Iterator itItems = items.iterator();
        if (detailId.equals(LIST_DETAIL_DOCTYPES)) {
            while (itItems.hasNext()) {
                item = (CmsListItem)itItems.next();
                this.fillDetailDocTypes(item, detailId);
            }
        }
        if (detailId.equals(LIST_DETAIL_RESOURCES)) {
            while (itItems.hasNext()) {
                item = (CmsListItem)itItems.next();
                this.fillDetailResources(item, detailId);
            }
        }
    }

    protected List getListItems() {
        ArrayList<CmsListItem> result = new ArrayList<CmsListItem>();
        List sources = this.searchIndexSources();
        Iterator itSources = sources.iterator();
        while (itSources.hasNext()) {
            try {
                String value;
                CmsSearchIndexSource source = (CmsSearchIndexSource)itSources.next();
                CmsListItem item = this.getList().newItem(source.getName());
                item.set(LIST_COLUMN_NAME, (Object)source.getName());
                try {
                    value = source.getIndexer().getClass().getName();
                }
                catch (Throwable f) {
                    value = "null";
                }
                item.set(LIST_COLUMN_INDEXER, (Object)value);
                result.add(item);
            }
            catch (Throwable g) {
                CmsMessageContainer msg = Messages.get().container("LOG_ERR_LIST_ITEM_SKIPPED_2", (Object)this.getList().getName().key(this.getLocale()), (Object)"Name");
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)msg.key(this.getLocale()));
            }
        }
        return result;
    }

    protected void initMessages() {
        this.addMessages(Messages.get().getBundleName());
        super.initMessages();
    }

    protected void setColumns(CmsListMetadata metadata) {
        CmsListColumnDefinition editCol = new CmsListColumnDefinition(LIST_COLUMN_EDIT);
        editCol.setName(Messages.get().container("GUI_LIST_INDEXSOURCE_COL_EDIT_NAME_0"));
        editCol.setHelpText(Messages.get().container("GUI_LIST_INDEXSOURCE_COL_EDIT_NAME_HELP_0"));
        editCol.setWidth("5");
        editCol.setAlign(CmsListColumnAlignEnum.ALIGN_LEFT);
        editCol.setSorteable(false);
        CmsListDirectAction editAction = new CmsListDirectAction(LIST_ACTION_EDIT);
        editAction.setName(Messages.get().container("GUI_LIST_INDEXSOURCE_ACTION_EDIT_NAME_0"));
        editAction.setHelpText(Messages.get().container("GUI_LIST_INDEXSOURCE_COL_EDIT_NAME_HELP_0"));
        editAction.setIconPath("tools/searchindex/icons/small/indexsource.png");
        editCol.addDirectAction((I_CmsListDirectAction)editAction);
        metadata.addColumn(editCol);
        CmsListColumnDefinition resCol = new CmsListColumnDefinition(LIST_COLUMN_RESOURCES);
        resCol.setName(Messages.get().container("GUI_LIST_INDEXSOURCE_COL_RESOURCES_NAME_0"));
        resCol.setHelpText(Messages.get().container("GUI_LIST_INDEXSOURCE_COL_RESOURCES_NAME_HELP_0"));
        resCol.setWidth("5");
        resCol.setAlign(CmsListColumnAlignEnum.ALIGN_LEFT);
        resCol.setSorteable(false);
        CmsListDirectAction resAction = new CmsListDirectAction(LIST_ACTION_RESOURCES);
        resAction.setName(Messages.get().container("GUI_LIST_SEARCHINDEX_ACTION_RESOURCES_NAME_0"));
        resAction.setHelpText(Messages.get().container("GUI_LIST_INDEXSOURCE_COL_RESOURCES_NAME_HELP_0"));
        resAction.setIconPath(ICON_FOLDER);
        resCol.addDirectAction((I_CmsListDirectAction)resAction);
        metadata.addColumn(resCol);
        CmsListColumnDefinition docCol = new CmsListColumnDefinition(LIST_COLUMN_DOCUMENTS);
        docCol.setName(Messages.get().container("GUI_LIST_INDEXSOURCE_COL_DOCUMENTS_NAME_0"));
        docCol.setHelpText(Messages.get().container("GUI_LIST_INDEXSOURCE_COL_DOCUMENTS_NAME_HELP_0"));
        docCol.setWidth("5");
        docCol.setAlign(CmsListColumnAlignEnum.ALIGN_LEFT);
        docCol.setSorteable(false);
        CmsListDirectAction docAction = new CmsListDirectAction(LIST_ACTION_DOCUMENTS);
        docAction.setName(Messages.get().container("GUI_LIST_SEARCHINDEX_ACTION_DOCUMENTS_NAME_0"));
        docAction.setHelpText(Messages.get().container("GUI_LIST_INDEXSOURCE_COL_DOCUMENTS_NAME_HELP_0"));
        docAction.setIconPath("tools/searchindex/icons/small/indexsource-doctype.png");
        docCol.addDirectAction((I_CmsListDirectAction)docAction);
        metadata.addColumn(docCol);
        CmsListColumnDefinition deleteCol = new CmsListColumnDefinition(LIST_COLUMN_DELETE);
        deleteCol.setName(Messages.get().container("GUI_LIST_SEARCHINDEX_COL_DELETE_NAME_0"));
        deleteCol.setHelpText(Messages.get().container("GUI_LIST_SEARCHINDEX_COL_DELETE_HELP_0"));
        deleteCol.setWidth("10");
        deleteCol.setAlign(CmsListColumnAlignEnum.ALIGN_LEFT);
        deleteCol.setSorteable(false);
        CmsListDirectAction deleteAction = new CmsListDirectAction(LIST_ACTION_DELETE);
        deleteAction.setName(Messages.get().container("GUI_LIST_SEARCHINDEX_ACTION_DELETE_NAME_0"));
        deleteAction.setHelpText(Messages.get().container("GUI_LIST_SEARCHINDEX_ACTION_DELETE_HELP_0"));
        deleteAction.setIconPath("list/delete.png");
        deleteCol.addDirectAction((I_CmsListDirectAction)deleteAction);
        metadata.addColumn(deleteCol);
        CmsListColumnDefinition nameCol = new CmsListColumnDefinition(LIST_COLUMN_NAME);
        nameCol.setAlign(CmsListColumnAlignEnum.ALIGN_LEFT);
        nameCol.setName(Messages.get().container("GUI_LIST_SEARCHINDEX_COL_NAME_0"));
        nameCol.setWidth("50%");
        CmsListDefaultAction defEditAction = new CmsListDefaultAction(LIST_ACTION_OVERVIEW_INDEXSOURCE);
        defEditAction.setName(Messages.get().container("GUI_LIST_INDEXSOURCE_COL_OVERVIEW_NAME_0"));
        defEditAction.setHelpText(Messages.get().container("GUI_LIST_INDEXSOURCE_COL_OVERVIEW_NAME_HELP_0"));
        nameCol.addDefaultAction(defEditAction);
        metadata.addColumn(nameCol);
        CmsListColumnDefinition analyzerCol = new CmsListColumnDefinition(LIST_COLUMN_INDEXER);
        analyzerCol.setAlign(CmsListColumnAlignEnum.ALIGN_LEFT);
        analyzerCol.setName(Messages.get().container("GUI_LIST_INDEXSOURCE_COL_INDEXER_0"));
        analyzerCol.setWidth("45%");
        metadata.addColumn(analyzerCol);
    }

    protected void setIndependentActions(CmsListMetadata metadata) {
        CmsListItemDetails doctypeDetails = new CmsListItemDetails(LIST_DETAIL_DOCTYPES);
        doctypeDetails.setAtColumn(LIST_COLUMN_NAME);
        doctypeDetails.setVisible(false);
        doctypeDetails.setShowActionName(Messages.get().container("GUI_LIST_INDEXSOURCE_DETAIL_DOCTYPE_SHOW_0"));
        doctypeDetails.setShowActionHelpText(Messages.get().container("GUI_LIST_INDEXSOURCE_DETAIL_DOCTYPE_SHOW_HELP_0"));
        doctypeDetails.setHideActionName(Messages.get().container("GUI_LIST_INDEXSOURCE_DETAIL_DOCTYPE_HIDE_0"));
        doctypeDetails.setHideActionHelpText(Messages.get().container("GUI_LIST_INDEXSOURCE_DETAIL_DOCTYPE_HIDE_HELP_0"));
        doctypeDetails.setName(Messages.get().container("GUI_LIST_INDEXSOURCE_DETAIL_DOCTYPE_NAME_0"));
        doctypeDetails.setFormatter((I_CmsListFormatter)new CmsListItemDetailsFormatter(Messages.get().container("GUI_LIST_INDEXSOURCE_DETAIL_DOCTYPE_NAME_0")));
        metadata.addItemDetails(doctypeDetails);
        CmsListItemDetails resourceDetails = new CmsListItemDetails(LIST_DETAIL_RESOURCES);
        resourceDetails.setAtColumn(LIST_COLUMN_NAME);
        resourceDetails.setVisible(false);
        resourceDetails.setShowActionName(Messages.get().container("GUI_LIST_INDEXSOURCE_DETAIL_RESOURCE_SHOW_0"));
        resourceDetails.setShowActionHelpText(Messages.get().container("GUI_LIST_INDEXSOURCE_DETAIL_RESOURCE_SHOW_HELP_0"));
        resourceDetails.setHideActionName(Messages.get().container("GUI_LIST_INDEXSOURCE_DETAIL_RESOURCE_HIDE_0"));
        resourceDetails.setHideActionHelpText(Messages.get().container("GUI_LIST_INDEXSOURCE_DETAIL_RESOURCE_HIDE_HELP_0"));
        resourceDetails.setName(Messages.get().container("GUI_LIST_INDEXSOURCE_DETAIL_RESOURCE_NAME_0"));
        resourceDetails.setFormatter((I_CmsListFormatter)new CmsListItemDetailsFormatter(Messages.get().container("GUI_LIST_INDEXSOURCE_DETAIL_RESOURCE_NAME_0")));
        metadata.addItemDetails(resourceDetails);
    }

    protected void setMultiActions(CmsListMetadata metadata) {
        CmsListMultiAction deleteMultiAction = new CmsListMultiAction(LIST_MACTION_DELETESOURCE);
        deleteMultiAction.setName(Messages.get().container("GUI_LIST_INDEXSOURCE_MACTION_DELETESOURCE_NAME_0"));
        deleteMultiAction.setHelpText(Messages.get().container("GUI_LIST_INDEXSOURCE_MACTION_DELETESOURCE_NAME_HELP_0"));
        deleteMultiAction.setConfirmationMessage(Messages.get().container("GUI_LIST_INDEXSOURCE_MACTION_DELETESOURCE_CONF_0"));
        deleteMultiAction.setIconPath("list/multi_minus.png");
        metadata.addMultiAction(deleteMultiAction);
    }

    protected void writeConfiguration(boolean refresh) {
        OpenCms.writeConfiguration((Class)CmsSearchConfiguration.class);
        if (refresh) {
            this.refreshList();
        }
    }

    private void fillDetailDocTypes(CmsListItem item, String detailId) {
        CmsSearchManager searchManager = OpenCms.getSearchManager();
        StringBuffer html = new StringBuffer();
        String idxSourceName = (String)item.get(LIST_COLUMN_NAME);
        CmsSearchIndexSource idxSource = searchManager.getIndexSource(idxSourceName);
        List docTypes = idxSource.getDocumentTypes();
        Iterator itDocTypes = docTypes.iterator();
        html.append("<ul>\n");
        while (itDocTypes.hasNext()) {
            CmsSearchDocumentType docType = searchManager.getDocumentTypeConfig(itDocTypes.next().toString());
            if (docType == null) continue;
            html.append("  <li>\n").append("  ").append(docType.getName()).append("\n");
            html.append("  </li>");
        }
        html.append("</ul>\n");
        item.set(detailId, (Object)html.toString());
    }

    private void fillDetailResources(CmsListItem item, String detailId) {
        CmsSearchManager searchManager = OpenCms.getSearchManager();
        StringBuffer html = new StringBuffer();
        String idxSourceName = (String)item.get(LIST_COLUMN_NAME);
        CmsSearchIndexSource idxSource = searchManager.getIndexSource(idxSourceName);
        List resources = idxSource.getResourcesNames();
        Iterator itResources = resources.iterator();
        html.append("<ul>\n");
        while (itResources.hasNext()) {
            html.append("  <li>\n").append("  ").append(itResources.next().toString()).append("\n");
            html.append("  </li>");
        }
        html.append("</ul>\n");
        item.set(detailId, (Object)html.toString());
    }

    private List searchIndexSources() {
        CmsSearchManager manager = OpenCms.getSearchManager();
        return new LinkedList(manager.getSearchIndexSources().values());
    }
}

