/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.searchindex;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.configuration.CmsSearchConfiguration;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsIllegalStateException;
import org.opencms.main.OpenCms;
import org.opencms.search.CmsSearchIndexSource;
import org.opencms.search.CmsSearchManager;
import org.opencms.workplace.list.CmsListColumnAlignEnum;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListDirectAction;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListOrderEnum;
import org.opencms.workplace.list.I_CmsListDirectAction;
import org.opencms.workplace.tools.searchindex.A_CmsEmbeddedListDialog;
import org.opencms.workplace.tools.searchindex.Messages;

public class CmsSearchResourcesList
extends A_CmsEmbeddedListDialog {
    public static final String LIST_ACTION_NONE = "an";
    public static final String LIST_COLUMN_ICON = "ci";
    public static final String LIST_COLUMN_PATH = "cp";
    public static final String LIST_ID = "lssr";
    private String m_paramIndexsource;

    public CmsSearchResourcesList(CmsJspActionElement jsp) {
        this(jsp, LIST_ID, Messages.get().container("GUI_LIST_SEARCHRESOURCES_NAME_0"));
    }

    public CmsSearchResourcesList(CmsJspActionElement jsp, String listId, CmsMessageContainer listName) {
        this(jsp, listId, listName, LIST_COLUMN_PATH, CmsListOrderEnum.ORDER_ASCENDING, null);
    }

    public CmsSearchResourcesList(CmsJspActionElement jsp, String listId, CmsMessageContainer listName, String sortedColId, CmsListOrderEnum sortOrder, String searchableColId) {
        super(jsp, listId, listName, sortedColId, sortOrder, searchableColId);
    }

    public CmsSearchResourcesList(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void executeListMultiActions() {
    }

    public void executeListSingleActions() {
    }

    public String getParamIndexsource() {
        return this.m_paramIndexsource;
    }

    public void setParamIndexsource(String indexsource) {
        this.m_paramIndexsource = indexsource;
    }

    protected void fillDetails(String detailId) {
    }

    protected List getListItems() {
        ArrayList<CmsListItem> result = new ArrayList<CmsListItem>();
        List resources = this.resources();
        Iterator itResources = resources.iterator();
        while (itResources.hasNext()) {
            String path = (String)itResources.next();
            CmsListItem item = this.getList().newItem(path);
            item.set(LIST_COLUMN_PATH, (Object)path);
            result.add(item);
        }
        return result;
    }

    protected void initMessages() {
        this.addMessages(Messages.get().getBundleName());
        super.initMessages();
    }

    protected void setColumns(CmsListMetadata metadata) {
        CmsListColumnDefinition dummyCol = new CmsListColumnDefinition(LIST_COLUMN_ICON);
        dummyCol.setName(Messages.get().container("GUI_LIST_RESOURCES_NAME_0"));
        dummyCol.setHelpText(Messages.get().container("GUI_LIST_RESOURCES_NAME_HELP_0"));
        dummyCol.setWidth("20");
        dummyCol.setAlign(CmsListColumnAlignEnum.ALIGN_LEFT);
        dummyCol.setSorteable(false);
        CmsListDirectAction dummyAction = new CmsListDirectAction(LIST_ACTION_NONE);
        dummyAction.setName(Messages.get().container("GUI_LIST_INDEXSOURCE_COL_ICON_NAME_0"));
        dummyAction.setHelpText(Messages.get().container("GUI_LIST_INDEXSOURCE_COL_ICON_NAME_HELP_0"));
        dummyAction.setIconPath("tools/searchindex/icons/small/indexsource-resources.png");
        dummyCol.addDirectAction((I_CmsListDirectAction)dummyAction);
        metadata.addColumn(dummyCol);
        CmsListColumnDefinition pathCol = new CmsListColumnDefinition(LIST_COLUMN_PATH);
        pathCol.setAlign(CmsListColumnAlignEnum.ALIGN_LEFT);
        pathCol.setName(Messages.get().container("GUI_LIST_SEARCHINDEX_COL_NAME_0"));
        pathCol.setWidth("100%");
        metadata.addColumn(pathCol);
    }

    protected void setIndependentActions(CmsListMetadata metadata) {
    }

    protected void setMultiActions(CmsListMetadata metadata) {
    }

    protected void validateParamaters() throws Exception {
        if (this.getParamIndexsource() == null) {
            throw new CmsIllegalStateException(Messages.get().container("ERR_SEARCHINDEX_EDIT_MISSING_PARAM_1", (Object)"indexsource"));
        }
    }

    protected void writeConfiguration(boolean refresh) {
        OpenCms.writeConfiguration((Class)CmsSearchConfiguration.class);
        if (refresh) {
            this.refreshList();
        }
    }

    private List resources() {
        CmsSearchManager manager = OpenCms.getSearchManager();
        CmsSearchIndexSource indexsource = manager.getIndexSource(this.getParamIndexsource());
        List result = indexsource.getResourcesNames();
        return result;
    }
}

