/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.accounts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.opencms.file.CmsGroup;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.widgets.CmsCheckboxWidget;
import org.opencms.widgets.CmsDisplayWidget;
import org.opencms.widgets.CmsGroupWidget;
import org.opencms.widgets.CmsInputWidget;
import org.opencms.widgets.CmsTextareaWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.workplace.CmsWidgetDialog;
import org.opencms.workplace.CmsWidgetDialogParameter;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.tools.CmsToolManager;
import org.opencms.workplace.tools.accounts.A_CmsUsersList;
import org.opencms.workplace.tools.accounts.Messages;

public abstract class A_CmsEditGroupDialog
extends CmsWidgetDialog {
    public static final String KEY_PREFIX = "group";
    public static final String[] PAGES = new String[]{"page1"};
    public static final String PARAM_GROUPID = "groupid";
    public static final String PARAM_GROUPNAME = "groupname";
    protected CmsGroup m_group;
    private String m_paramGroupid;
    private String m_paramOufqn;
    private String m_parentGroup;

    public A_CmsEditGroupDialog(CmsJspActionElement jsp) {
        super(jsp);
    }

    public void actionCommit() {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        try {
            if (this.m_group.getId() == null) {
                CmsGroup newGroup = this.getCms().createGroup(this.m_paramOufqn + this.m_group.getSimpleName(), this.m_group.getDescription(), this.m_group.isEnabled() ? 0 : 1, this.getParentGroup());
                newGroup.setProjectManager(this.m_group.isProjectManager());
                newGroup.setProjectCoWorker(this.m_group.isProjectCoWorker());
                this.m_group = newGroup;
            } else if (this.getParentGroup() != null) {
                this.m_group.setParentId(this.getCms().readGroup(this.getParentGroup()).getId());
            } else {
                this.m_group.setParentId(CmsUUID.getNullUUID());
            }
            this.getCms().writeGroup(this.m_group);
            Map objects = (Map)this.getSettings().getListObject();
            if (objects != null) {
                objects.remove(this.getListClass());
                objects.remove(A_CmsUsersList.class.getName());
            }
        }
        catch (Throwable t) {
            errors.add(t);
        }
        if (errors.isEmpty() && this.isNewGroup() && this.getParamCloseLink() != null && this.getParamCloseLink().indexOf("path=" + this.getListRootPath()) > -1) {
            HashMap<String, Object> argMap = new HashMap<String, Object>();
            argMap.put(PARAM_GROUPID, this.m_group.getId());
            argMap.put(PARAM_GROUPNAME, this.m_group.getName());
            argMap.put("oufqn", this.m_paramOufqn);
            this.setParamCloseLink(CmsToolManager.linkForToolPath((CmsJspActionElement)this.getJsp(), (String)(this.getListRootPath() + "/edit"), argMap));
        }
        this.setCommitErrors(errors);
    }

    public String getAssignedOu() {
        try {
            return OpenCms.getOrgUnitManager().readOrganizationalUnit(this.getCms(), this.getParamOufqn()).getDescription(this.getLocale()) + " (" + "/" + this.getParamOufqn() + ")";
        }
        catch (CmsException e) {
            return null;
        }
    }

    public String getDescription() {
        return this.m_group.getDescription(this.getLocale());
    }

    public String getName() {
        return this.m_group.getSimpleName();
    }

    public String getParamGroupid() {
        return this.m_paramGroupid;
    }

    public String getParamOufqn() {
        return this.m_paramOufqn;
    }

    public String getParentGroup() {
        return this.m_parentGroup;
    }

    public void setAssignedOu(String assignedOu) {
        assignedOu.length();
    }

    public void setDescription(String description) {
        this.m_group.setDescription(description);
    }

    public void setName(String name) {
        this.m_group.setName(name);
    }

    public void setParamGroupid(String userId) {
        this.m_paramGroupid = userId;
    }

    public void setParamOufqn(String ouFqn) {
        if (ouFqn == null) {
            ouFqn = "";
        }
        this.m_paramOufqn = ouFqn;
    }

    public void setParentGroup(String parentGroup) {
        if (CmsStringUtil.isEmpty((String)parentGroup) || parentGroup.equals("null") || parentGroup.equals("none")) {
            parentGroup = null;
        }
        if (parentGroup != null) {
            try {
                this.getCms().readGroup(parentGroup);
            }
            catch (CmsException e) {
                throw new CmsIllegalArgumentException(e.getMessageContainer());
            }
        }
        this.m_parentGroup = parentGroup;
    }

    protected String createDialogHtml(String dialog) {
        StringBuffer result = new StringBuffer(1024);
        result.append(this.createWidgetTableStart());
        result.append(this.createWidgetErrorHeader());
        if (dialog.equals(PAGES[0])) {
            result.append(this.dialogBlockStart(this.key("GUI_GROUP_EDITOR_LABEL_IDENTIFICATION_BLOCK_0")));
            result.append(this.createWidgetTableStart());
            result.append(this.createDialogRowsHtml(0, 4));
            result.append(this.createWidgetTableEnd());
            result.append(this.dialogBlockEnd());
            boolean webuserOu = false;
            try {
                webuserOu = OpenCms.getOrgUnitManager().readOrganizationalUnit(this.getCms(), this.getParamOufqn()).hasFlagWebuser();
            }
            catch (CmsException e) {
                // empty catch block
            }
            if (!webuserOu) {
                result.append(this.dialogBlockStart(this.key("GUI_GROUP_EDITOR_LABEL_FLAGS_BLOCK_0")));
                result.append(this.createWidgetTableStart());
                result.append(this.createDialogRowsHtml(5, 6));
                result.append(this.createWidgetTableEnd());
                result.append(this.dialogBlockEnd());
            }
        }
        result.append(this.createWidgetTableEnd());
        return result.toString();
    }

    protected void defineWidgets() {
        this.initGroupObject();
        boolean webuserOu = false;
        try {
            webuserOu = OpenCms.getOrgUnitManager().readOrganizationalUnit(this.getCms(), this.getParamOufqn()).hasFlagWebuser();
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
        this.setKeyPrefix(KEY_PREFIX);
        if (this.m_group.getId() == null && this.isEditable(this.m_group)) {
            this.addWidget(new CmsWidgetDialogParameter((Object)this, "name", PAGES[0], (I_CmsWidget)new CmsInputWidget()));
        } else {
            this.addWidget(new CmsWidgetDialogParameter((Object)this, "name", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
        }
        if (this.isEditable(this.m_group)) {
            this.addWidget(new CmsWidgetDialogParameter((Object)this, "description", PAGES[0], (I_CmsWidget)new CmsTextareaWidget()));
            this.addWidget(new CmsWidgetDialogParameter((Object)this, "parentGroup", PAGES[0], (I_CmsWidget)new CmsGroupWidget(null, null, this.getParamOufqn())));
            this.addWidget(new CmsWidgetDialogParameter((Object)this, "assignedOu", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
            this.addWidget(new CmsWidgetDialogParameter((Object)this.m_group, "enabled", PAGES[0], (I_CmsWidget)new CmsCheckboxWidget()));
            if (!webuserOu) {
                this.addWidget(new CmsWidgetDialogParameter((Object)this.m_group, "projectManager", PAGES[0], (I_CmsWidget)new CmsCheckboxWidget()));
                this.addWidget(new CmsWidgetDialogParameter((Object)this.m_group, "projectCoWorker", PAGES[0], (I_CmsWidget)new CmsCheckboxWidget()));
            }
        } else {
            this.addWidget(new CmsWidgetDialogParameter((Object)this, "description", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
            this.addWidget(new CmsWidgetDialogParameter((Object)this, "parentGroup", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
            this.addWidget(new CmsWidgetDialogParameter((Object)this, "assignedOu", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
            this.addWidget(new CmsWidgetDialogParameter((Object)this.m_group, "enabled", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
            if (!webuserOu) {
                this.addWidget(new CmsWidgetDialogParameter((Object)this.m_group, "projectManager", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
                this.addWidget(new CmsWidgetDialogParameter((Object)this.m_group, "projectCoWorker", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
            }
        }
    }

    protected abstract String getListClass();

    protected abstract String getListRootPath();

    protected String[] getPageArray() {
        return PAGES;
    }

    protected void initGroupObject() {
        Object o = null;
        try {
            if (CmsStringUtil.isEmpty((String)this.getParamAction()) || "initial".equals(this.getParamAction())) {
                this.m_group = this.getCms().readGroup(new CmsUUID(this.getParamGroupid()));
            } else {
                o = this.getDialogObject();
                this.m_group = (CmsGroup)o;
                this.m_group.getId();
            }
            if (this.m_group.getParentId() != null && !this.m_group.getParentId().isNullUUID()) {
                this.setParentGroup(this.getCms().getParent(this.m_group.getName()).getName());
            }
        }
        catch (Exception e) {
            this.m_group = new CmsGroup();
            this.setParentGroup(null);
        }
    }

    protected void initMessages() {
        this.addMessages(Messages.get().getBundleName());
        super.initMessages();
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        super.initWorkplaceRequestValues(settings, request);
        this.setDialogObject(this.m_group);
    }

    protected abstract boolean isEditable(CmsGroup var1);

    protected void validateParamaters() throws Exception {
        OpenCms.getRoleManager().checkRole(this.getCms(), CmsRole.ACCOUNT_MANAGER.forOrgUnit(this.getParamOufqn()));
        if (!this.isNewGroup()) {
            this.getCms().readGroup(new CmsUUID(this.getParamGroupid())).getName();
        }
    }

    private boolean isNewGroup() {
        return this.getCurrentToolPath().equals(this.getListRootPath() + "/new");
    }
}

