/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.accounts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.opencms.db.CmsUserSettings;
import org.opencms.file.CmsUser;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.security.CmsPasswordInfo;
import org.opencms.security.CmsRole;
import org.opencms.site.CmsSite;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.widgets.CmsCheckboxWidget;
import org.opencms.widgets.CmsDisplayWidget;
import org.opencms.widgets.CmsGroupWidget;
import org.opencms.widgets.CmsInputWidget;
import org.opencms.widgets.CmsPasswordWidget;
import org.opencms.widgets.CmsSelectWidget;
import org.opencms.widgets.CmsSelectWidgetOption;
import org.opencms.widgets.CmsTextareaWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.workplace.CmsWidgetDialog;
import org.opencms.workplace.CmsWidgetDialogParameter;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.tools.CmsToolManager;
import org.opencms.workplace.tools.accounts.Messages;

public abstract class A_CmsEditUserDialog
extends CmsWidgetDialog {
    public static final String KEY_PREFIX = "user";
    public static final String[] PAGES = new String[]{"page1"};
    public static final String PARAM_USERID = "userid";
    private static final String PWD_OBJECT = "PWD_INFO";
    private static final String USER_OBJECT = "USER";
    protected CmsUser m_user;
    private String m_group;
    private String m_language;
    private String m_paramOufqn;
    private String m_paramUserid;
    private CmsPasswordInfo m_pwdInfo;
    private String m_site;

    public A_CmsEditUserDialog(CmsJspActionElement jsp) {
        super(jsp);
    }

    public void actionCommit() {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        try {
            if (this.isNewUser()) {
                this.m_pwdInfo.validate();
                CmsUser newUser = this.createUser(this.m_paramOufqn + this.m_user.getSimpleName(), this.m_pwdInfo.getNewPwd(), this.m_user.getDescription(), this.m_user.getAdditionalInfo());
                newUser.setFirstname(this.m_user.getFirstname());
                newUser.setLastname(this.m_user.getLastname());
                newUser.setEmail(this.m_user.getEmail());
                newUser.setAddress(this.m_user.getAddress());
                this.m_user = newUser;
            } else if (CmsStringUtil.isNotEmpty((String)this.m_pwdInfo.getNewPwd())) {
                this.m_pwdInfo.validate();
                this.getCms().setPassword(this.m_user.getName(), this.m_pwdInfo.getNewPwd());
            }
            if (this.isNewUser() && CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)this.getGroup())) {
                this.getCms().readGroup(this.getGroup());
            }
            this.writeUser(this.m_user);
            if (this.isNewUser() && CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)this.getGroup())) {
                this.getCms().addUserToGroup(this.m_user.getName(), this.getGroup());
            }
            CmsUserSettings settings = new CmsUserSettings(this.m_user);
            settings.setLocale(CmsLocaleManager.getLocale((String)this.getLanguage()));
            settings.setStartSite(this.getSite());
            if (this.isNewUser()) {
                try {
                    String prj = this.getCms().readProject(this.getParamOufqn() + OpenCms.getWorkplaceManager().getDefaultUserSettings().getStartProject()).getName();
                    settings.setStartProject(prj);
                }
                catch (CmsException e) {
                    settings.setStartProject(OpenCms.getWorkplaceManager().getDefaultUserSettings().getStartProject());
                }
            }
            settings.save(this.getCms());
            Map objects = (Map)this.getSettings().getListObject();
            if (objects != null) {
                objects.remove(this.getListClass());
            }
        }
        catch (Throwable t) {
            errors.add(t);
        }
        if (errors.isEmpty() && this.isNewUser() && this.getParamCloseLink() != null && this.getParamCloseLink().indexOf("path=" + this.getListRootPath()) > -1) {
            HashMap<String, Object> argMap = new HashMap<String, Object>();
            argMap.put(PARAM_USERID, this.m_user.getId());
            argMap.put("oufqn", this.m_paramOufqn);
            this.setParamCloseLink(CmsToolManager.linkForToolPath((CmsJspActionElement)this.getJsp(), (String)(this.getListRootPath() + "/edit"), argMap));
        }
        this.setCommitErrors(errors);
    }

    public String getAssignedOu() {
        try {
            CmsOrganizationalUnit ou = OpenCms.getOrgUnitManager().readOrganizationalUnit(this.getCms(), this.getParamOufqn());
            return ou.getDisplayName(this.getLocale());
        }
        catch (CmsException e) {
            return null;
        }
    }

    public String getDescription() {
        return this.m_user.getDescription(this.getLocale());
    }

    public String getGroup() {
        return this.m_group;
    }

    public String getLanguage() {
        return this.m_language;
    }

    public String getName() {
        if (this.m_user.getSimpleName().endsWith("/")) {
            return "";
        }
        return this.m_user.getSimpleName();
    }

    public String getParamOufqn() {
        return this.m_paramOufqn;
    }

    public String getParamUserid() {
        return this.m_paramUserid;
    }

    public CmsPasswordInfo getPwdInfo() {
        return this.m_pwdInfo;
    }

    public String getSite() {
        return this.m_site;
    }

    public boolean isSelfManagement() {
        return !this.m_user.isManaged();
    }

    public void setAssignedOu(String assignedOu) {
        assignedOu.length();
    }

    public void setDescription(String description) {
        this.m_user.setDescription(description);
    }

    public void setGroup(String group) {
        this.m_group = group;
    }

    public void setLanguage(String language) {
        this.m_language = language;
    }

    public void setName(String name) {
        this.m_user.setName(this.getParamOufqn() + name);
    }

    public void setParamOufqn(String ouFqn) {
        if (ouFqn == null) {
            ouFqn = "";
        }
        this.m_paramOufqn = ouFqn;
    }

    public void setParamUserid(String userId) {
        this.m_paramUserid = userId;
    }

    public void setSelfManagement(boolean selfManagement) {
        this.m_user.setManaged(!selfManagement);
    }

    public void setSite(String site) {
        this.m_site = site;
    }

    protected String createDialogHtml(String dialog) {
        StringBuffer result = new StringBuffer(1024);
        result.append(this.createWidgetTableStart());
        result.append(this.createWidgetErrorHeader());
        if (dialog.equals(PAGES[0])) {
            int row;
            boolean webuserOu = false;
            try {
                webuserOu = OpenCms.getOrgUnitManager().readOrganizationalUnit(this.getCms(), this.getParamOufqn()).hasFlagWebuser();
            }
            catch (CmsException e) {
                // empty catch block
            }
            result.append(this.dialogBlockStart(this.key("GUI_USER_EDITOR_LABEL_IDENTIFICATION_BLOCK_0")));
            result.append(this.createWidgetTableStart());
            result.append(this.createDialogRowsHtml(0, 5));
            result.append(this.createWidgetTableEnd());
            result.append(this.dialogBlockEnd());
            result.append(this.dialogBlockStart(this.key("GUI_USER_EDITOR_LABEL_ADDRESS_BLOCK_0")));
            result.append(this.createWidgetTableStart());
            result.append(this.createDialogRowsHtml(6, 9));
            result.append(this.createWidgetTableEnd());
            result.append(this.dialogBlockEnd());
            int n = row = this.isNewUser() ? 12 : 11;
            if (!webuserOu) {
                if (this.getSites().isEmpty()) {
                    --row;
                }
                result.append(this.dialogBlockStart(this.key("GUI_USER_EDITOR_LABEL_SETTINGS_BLOCK_0")));
                result.append(this.createWidgetTableStart());
                result.append(this.createDialogRowsHtml(10, row));
                result.append(this.createWidgetTableEnd());
                result.append(this.dialogBlockEnd());
            } else {
                row = 9;
            }
            ++row;
            result.append(this.dialogBlockStart(this.key("GUI_USER_EDITOR_LABEL_AUTHENTIFICATION_BLOCK_0")));
            result.append(this.createWidgetTableStart());
            if (this.isPwdChangeAllowed(this.m_user)) {
                result.append(this.createDialogRowsHtml(row, row + 3));
            } else {
                result.append(this.createDialogRowsHtml(row, row + 1));
            }
            result.append(this.createWidgetTableEnd());
            result.append(this.dialogBlockEnd());
        }
        result.append(this.createWidgetTableEnd());
        return result.toString();
    }

    protected abstract CmsUser createUser(String var1, String var2, String var3, Map var4) throws CmsException;

    protected void defineWidgets() {
        this.initUserObject();
        boolean webuserOu = false;
        try {
            webuserOu = OpenCms.getOrgUnitManager().readOrganizationalUnit(this.getCms(), this.getParamOufqn()).hasFlagWebuser();
        }
        catch (CmsException e) {
            webuserOu = this.m_user.isWebuser();
        }
        this.setKeyPrefix(KEY_PREFIX);
        if (this.isNewUser() && this.isEditable(this.m_user)) {
            this.addWidget(new CmsWidgetDialogParameter((Object)this, "name", PAGES[0], (I_CmsWidget)new CmsInputWidget()));
        } else {
            this.addWidget(new CmsWidgetDialogParameter((Object)this, "name", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
        }
        if (this.isEditable(this.m_user)) {
            this.addWidget(new CmsWidgetDialogParameter((Object)this, "description", "", PAGES[0], (I_CmsWidget)new CmsTextareaWidget(), 0, 1));
            this.addWidget(new CmsWidgetDialogParameter((Object)this.m_user, "lastname", PAGES[0], (I_CmsWidget)new CmsInputWidget()));
            this.addWidget(new CmsWidgetDialogParameter((Object)this.m_user, "firstname", PAGES[0], (I_CmsWidget)new CmsInputWidget()));
            this.addWidget(new CmsWidgetDialogParameter((Object)this.m_user, "email", PAGES[0], (I_CmsWidget)new CmsInputWidget()));
            this.addWidget(new CmsWidgetDialogParameter((Object)this, "assignedOu", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
            this.addWidget(new CmsWidgetDialogParameter((Object)this.m_user, "address", "", PAGES[0], (I_CmsWidget)new CmsInputWidget(), 0, 1));
            this.addWidget(new CmsWidgetDialogParameter((Object)this.m_user, "zipcode", "", PAGES[0], (I_CmsWidget)new CmsInputWidget(), 0, 1));
            this.addWidget(new CmsWidgetDialogParameter((Object)this.m_user, "city", "", PAGES[0], (I_CmsWidget)new CmsInputWidget(), 0, 1));
            this.addWidget(new CmsWidgetDialogParameter((Object)this.m_user, "country", "", PAGES[0], (I_CmsWidget)new CmsInputWidget(), 0, 1));
            if (!webuserOu) {
                this.addWidget(new CmsWidgetDialogParameter((Object)this, "language", PAGES[0], (I_CmsWidget)new CmsSelectWidget(this.getLanguages())));
                if (!this.getSites().isEmpty()) {
                    this.addWidget(new CmsWidgetDialogParameter((Object)this, "site", PAGES[0], (I_CmsWidget)new CmsSelectWidget(this.getSites())));
                }
                if (this.isNewUser()) {
                    this.addWidget(new CmsWidgetDialogParameter((Object)this, "group", PAGES[0], (I_CmsWidget)new CmsGroupWidget(null, null, this.getParamOufqn())));
                }
            }
        } else {
            this.addWidget(new CmsWidgetDialogParameter((Object)this, "description", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
            this.addWidget(new CmsWidgetDialogParameter((Object)this.m_user, "lastname", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
            this.addWidget(new CmsWidgetDialogParameter((Object)this.m_user, "firstname", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
            this.addWidget(new CmsWidgetDialogParameter((Object)this.m_user, "email", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
            this.addWidget(new CmsWidgetDialogParameter((Object)this, "assignedOu", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
            this.addWidget(new CmsWidgetDialogParameter((Object)this.m_user, "address", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
            this.addWidget(new CmsWidgetDialogParameter((Object)this.m_user, "zipcode", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
            this.addWidget(new CmsWidgetDialogParameter((Object)this.m_user, "city", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
            this.addWidget(new CmsWidgetDialogParameter((Object)this.m_user, "country", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
            if (!webuserOu) {
                this.addWidget(new CmsWidgetDialogParameter((Object)this, "language", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
                if (!this.getSites().isEmpty()) {
                    this.addWidget(new CmsWidgetDialogParameter((Object)this, "site", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
                }
            }
        }
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_user, "enabled", PAGES[0], (I_CmsWidget)new CmsCheckboxWidget()));
        this.addWidget(new CmsWidgetDialogParameter((Object)this, "selfManagement", PAGES[0], (I_CmsWidget)new CmsCheckboxWidget()));
        if (this.isPwdChangeAllowed(this.m_user)) {
            this.addWidget(new CmsWidgetDialogParameter((Object)this.m_pwdInfo, "newPwd", PAGES[0], (I_CmsWidget)new CmsPasswordWidget()));
            this.addWidget(new CmsWidgetDialogParameter((Object)this.m_pwdInfo, "confirmation", PAGES[0], (I_CmsWidget)new CmsPasswordWidget()));
        }
    }

    protected abstract String getListClass();

    protected abstract String getListRootPath();

    protected String[] getPageArray() {
        return PAGES;
    }

    protected void initMessages() {
        this.addMessages(Messages.get().getBundleName());
        super.initMessages();
    }

    protected void initUserObject() {
        Object o = null;
        try {
            if (CmsStringUtil.isEmpty((String)this.getParamAction()) || "initial".equals(this.getParamAction())) {
                this.m_user = this.getCms().readUser(new CmsUUID(this.getParamUserid()));
                this.m_pwdInfo = new CmsPasswordInfo();
                CmsUserSettings settings = new CmsUserSettings(this.m_user);
                this.m_language = settings.getLocale().toString();
                this.m_site = settings.getStartSite();
                return;
            }
            o = this.getDialogObject();
            Map dialogObject = (Map)o;
            this.m_user = (CmsUser)dialogObject.get(USER_OBJECT);
            this.m_pwdInfo = (CmsPasswordInfo)dialogObject.get(PWD_OBJECT);
            CmsUserSettings settings = new CmsUserSettings(this.m_user);
            this.m_language = settings.getLocale().toString();
            this.m_site = settings.getStartSite();
            this.m_user.getId();
            return;
        }
        catch (Exception e) {
            this.m_user = new CmsUser();
            this.m_pwdInfo = new CmsPasswordInfo();
            this.m_group = "";
            try {
                this.m_group = this.getCms().readGroup(this.getParamOufqn() + OpenCms.getDefaultUsers().getGroupUsers()).getName();
            }
            catch (CmsException cmsException) {
                // empty catch block
            }
            this.m_language = CmsLocaleManager.getDefaultLocale().toString();
            this.m_site = OpenCms.getSiteManager().getDefaultSite().getSiteRoot();
            return;
        }
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        super.initWorkplaceRequestValues(settings, request);
        HashMap<String, Object> dialogObject = new HashMap<String, Object>();
        dialogObject.put(USER_OBJECT, this.m_user);
        dialogObject.put(PWD_OBJECT, this.m_pwdInfo);
        this.setDialogObject(dialogObject);
    }

    protected abstract boolean isEditable(CmsUser var1);

    protected boolean isNewUser() {
        return this.getCurrentToolPath().equals(this.getListRootPath() + "/new");
    }

    protected boolean isPwdChangeAllowed(CmsUser user) {
        return user.isUser();
    }

    protected void validateParamaters() throws Exception {
        OpenCms.getRoleManager().checkRole(this.getCms(), CmsRole.ACCOUNT_MANAGER.forOrgUnit(this.getParamOufqn()));
        if (!this.isNewUser()) {
            this.getCms().readUser(new CmsUUID(this.getParamUserid())).getName();
        }
    }

    protected abstract void writeUser(CmsUser var1) throws CmsException;

    private List getLanguages() {
        ArrayList<CmsSelectWidgetOption> locales = new ArrayList<CmsSelectWidgetOption>();
        Locale defLocale = null;
        if (this.m_user != null && CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)this.m_user.getName())) {
            defLocale = new CmsUserSettings(this.m_user).getLocale();
        }
        if (defLocale == null) {
            defLocale = this.getCms().getRequestContext().getLocale();
        }
        Iterator itLocales = OpenCms.getLocaleManager().getAvailableLocales().iterator();
        while (itLocales.hasNext()) {
            Locale locale = (Locale)itLocales.next();
            boolean selected = locale.equals(defLocale);
            locales.add(new CmsSelectWidgetOption(locale.toString(), selected, locale.getDisplayName(this.getLocale()), null));
        }
        return locales;
    }

    private List getSites() {
        ArrayList<CmsSelectWidgetOption> sites = new ArrayList<CmsSelectWidgetOption>();
        List sitesList = OpenCms.getSiteManager().getAvailableSites(this.getCms(), true, this.getParamOufqn());
        String defSite = null;
        if (this.m_user != null && CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)this.m_user.getName())) {
            defSite = new CmsUserSettings(this.m_user).getStartSite();
        }
        if (defSite == null) {
            defSite = this.getCms().getRequestContext().getSiteRoot();
        }
        if (!defSite.endsWith("/")) {
            defSite = defSite + "/";
        }
        Iterator itSites = sitesList.iterator();
        while (itSites.hasNext()) {
            CmsSite site = (CmsSite)itSites.next();
            String siteRoot = site.getSiteRoot();
            if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)siteRoot) && sitesList.size() > 1 && CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)this.m_user.getName()) && !OpenCms.getRoleManager().hasRole(this.getCms(), this.m_user.getName(), CmsRole.DEVELOPER)) continue;
            if (!siteRoot.endsWith("/")) {
                siteRoot = siteRoot + "/";
            }
            boolean selected = defSite.equals(siteRoot);
            sites.add(new CmsSelectWidgetOption(siteRoot, selected, site.getTitle(), null));
        }
        return sites;
    }
}

