/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.accounts;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.jsp.JspException;
import org.opencms.file.CmsUser;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.list.A_CmsListDialog;
import org.opencms.workplace.list.CmsListColumnAlignEnum;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListIndependentAction;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListItemDetails;
import org.opencms.workplace.list.CmsListItemDetailsFormatter;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListOrderEnum;
import org.opencms.workplace.list.I_CmsListAction;
import org.opencms.workplace.list.I_CmsListFormatter;
import org.opencms.workplace.tools.accounts.A_CmsUsersList;
import org.opencms.workplace.tools.accounts.CmsGroupsList;
import org.opencms.workplace.tools.accounts.Messages;

public abstract class A_CmsGroupUsersList
extends A_CmsListDialog {
    public static final String LIST_ACTION_ICON = "ai";
    public static final String LIST_ACTION_STATE = "as";
    public static final String LIST_COLUMN_FULLNAME = "cf";
    public static final String LIST_COLUMN_ICON = "ci";
    public static final String LIST_COLUMN_LOGIN = "cl";
    public static final String LIST_COLUMN_NAME = "cn";
    public static final String LIST_COLUMN_ORGUNIT = "co";
    public static final String LIST_COLUMN_STATE = "cs";
    public static final String LIST_DETAIL_OTHEROU = "doo";
    private Boolean m_hasUsersInOtherOus;
    private String m_paramGroupid;
    private String m_paramGroupname;
    private String m_paramOufqn;

    protected A_CmsGroupUsersList(CmsJspActionElement jsp, String listId, CmsMessageContainer listName, boolean searchable) {
        super(jsp, listId, listName, LIST_COLUMN_LOGIN, CmsListOrderEnum.ORDER_ASCENDING, searchable ? LIST_COLUMN_NAME : null);
    }

    public void actionDialog() throws JspException, ServletException, IOException {
        this.updateGroupList();
        super.actionDialog();
    }

    public String getParamGroupid() {
        return this.m_paramGroupid;
    }

    public String getParamGroupname() {
        return this.m_paramGroupname;
    }

    public String getIconPath(CmsListItem item) {
        try {
            CmsUser user = this.getCms().readUser((String)item.get(LIST_COLUMN_LOGIN));
            if (user.getOuFqn().equals(this.getParamOufqn())) {
                return "tools/accounts/buttons/user.png";
            }
            return "tools/accounts/buttons/user_other_ou.png";
        }
        catch (CmsException e) {
            return "tools/accounts/buttons/user.png";
        }
    }

    public String getParamOufqn() {
        return this.m_paramOufqn;
    }

    public boolean hasUsersInOtherOus() {
        if (this.m_hasUsersInOtherOus == null) {
            this.m_hasUsersInOtherOus = Boolean.FALSE;
            try {
                Iterator itUsers = this.getUsers(true).iterator();
                while (itUsers.hasNext()) {
                    CmsUser user = (CmsUser)itUsers.next();
                    if (user.getOuFqn().equals(this.getParamOufqn())) continue;
                    this.m_hasUsersInOtherOus = Boolean.TRUE;
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.m_hasUsersInOtherOus;
    }

    public void setParamGroupid(String userId) {
        this.m_paramGroupid = userId;
    }

    public void setParamOufqn(String ouFqn) {
        if (ouFqn == null) {
            ouFqn = "";
        }
        this.m_paramOufqn = ouFqn;
    }

    public void updateGroupList() {
        Map objects = (Map)this.getSettings().getListObject();
        if (objects != null) {
            objects.remove(CmsGroupsList.class.getName());
            objects.remove(A_CmsUsersList.class.getName());
        }
    }

    protected void fillDetails(String detailId) {
    }

    protected List getListItems() throws CmsException {
        ArrayList<CmsListItem> ret = new ArrayList<CmsListItem>();
        boolean withOtherOus = this.hasUsersInOtherOus() && this.getList().getMetadata().getItemDetailDefinition(LIST_DETAIL_OTHEROU) != null && this.getList().getMetadata().getItemDetailDefinition(LIST_DETAIL_OTHEROU).isVisible();
        Iterator itUsers = this.getUsers(withOtherOus).iterator();
        while (itUsers.hasNext()) {
            CmsUser user = (CmsUser)itUsers.next();
            CmsListItem item = this.getList().newItem(user.getId().toString());
            this.setUserData(user, item);
            ret.add(item);
        }
        return ret;
    }

    protected void setUserData(CmsUser user, CmsListItem item) {
        item.set(LIST_COLUMN_LOGIN, (Object)user.getName());
        item.set(LIST_COLUMN_NAME, (Object)user.getSimpleName());
        item.set(LIST_COLUMN_ORGUNIT, (Object)("/" + user.getOuFqn()));
        item.set(LIST_COLUMN_FULLNAME, (Object)user.getFullName());
    }

    protected abstract List getUsers(boolean var1) throws CmsException;

    protected void initializeDetail(String detailId) {
        super.initializeDetail(detailId);
        if (detailId.equals(LIST_DETAIL_OTHEROU)) {
            boolean visible = this.hasUsersInOtherOus() && this.getList().getMetadata().getItemDetailDefinition(LIST_DETAIL_OTHEROU).isVisible();
            this.getList().getMetadata().getColumnDefinition(LIST_COLUMN_ORGUNIT).setVisible(visible);
            this.getList().getMetadata().getColumnDefinition(LIST_COLUMN_ORGUNIT).setPrintable(visible);
        }
    }

    protected void initMessages() {
        this.addMessages(Messages.get().getBundleName());
        super.initMessages();
    }

    protected void setColumns(CmsListMetadata metadata) {
        CmsListColumnDefinition iconCol = new CmsListColumnDefinition(LIST_COLUMN_ICON);
        iconCol.setName(Messages.get().container("GUI_USERS_LIST_COLS_ICON_0"));
        iconCol.setHelpText(Messages.get().container("GUI_USERS_LIST_COLS_ICON_HELP_0"));
        iconCol.setWidth("20");
        iconCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        iconCol.setSorteable(false);
        this.setIconAction(iconCol);
        metadata.addColumn(iconCol);
        this.setStateActionCol(metadata);
        CmsListColumnDefinition loginCol = new CmsListColumnDefinition(LIST_COLUMN_LOGIN);
        loginCol.setVisible(false);
        metadata.addColumn(loginCol);
        CmsListColumnDefinition nameCol = new CmsListColumnDefinition(LIST_COLUMN_NAME);
        nameCol.setName(Messages.get().container("GUI_USERS_LIST_COLS_LOGIN_0"));
        nameCol.setWidth("35%");
        this.setDefaultAction(nameCol);
        metadata.addColumn(nameCol);
        CmsListColumnDefinition orgunitCol = new CmsListColumnDefinition(LIST_COLUMN_ORGUNIT);
        orgunitCol.setName(Messages.get().container("GUI_USERS_LIST_COLS_ORGUNIT_0"));
        orgunitCol.setVisible(false);
        metadata.addColumn(orgunitCol);
        CmsListColumnDefinition fullnameCol = new CmsListColumnDefinition(LIST_COLUMN_FULLNAME);
        fullnameCol.setName(Messages.get().container("GUI_USERS_LIST_COLS_FULLNAME_0"));
        fullnameCol.setWidth("65%");
        fullnameCol.setTextWrapping(true);
        metadata.addColumn(fullnameCol);
    }

    protected abstract void setDefaultAction(CmsListColumnDefinition var1);

    protected abstract void setIconAction(CmsListColumnDefinition var1);

    protected void setIndependentActions(CmsListMetadata metadata) {
        CmsListItemDetails otherOuDetails = new CmsListItemDetails(LIST_DETAIL_OTHEROU);
        otherOuDetails.setVisible(false);
        otherOuDetails.setHideAction((I_CmsListAction)new CmsListIndependentAction(LIST_DETAIL_OTHEROU){

            public String getIconPath() {
                return "list/details_hide.png";
            }

            public boolean isVisible() {
                return ((A_CmsGroupUsersList)this.getWp()).hasUsersInOtherOus();
            }
        });
        otherOuDetails.setShowAction((I_CmsListAction)new CmsListIndependentAction(LIST_DETAIL_OTHEROU){

            public String getIconPath() {
                return "list/details_show.png";
            }

            public boolean isVisible() {
                return ((A_CmsGroupUsersList)this.getWp()).hasUsersInOtherOus();
            }
        });
        otherOuDetails.setShowActionName(Messages.get().container("GUI_USERS_DETAIL_SHOW_OTHEROU_NAME_0"));
        otherOuDetails.setShowActionHelpText(Messages.get().container("GUI_USERS_DETAIL_SHOW_OTHEROU_HELP_0"));
        otherOuDetails.setHideActionName(Messages.get().container("GUI_USERS_DETAIL_HIDE_OTHEROU_NAME_0"));
        otherOuDetails.setHideActionHelpText(Messages.get().container("GUI_USERS_DETAIL_HIDE_OTHEROU_HELP_0"));
        otherOuDetails.setName(Messages.get().container("GUI_USERS_DETAIL_OTHEROU_NAME_0"));
        otherOuDetails.setFormatter((I_CmsListFormatter)new CmsListItemDetailsFormatter(Messages.get().container("GUI_USERS_DETAIL_OTHEROU_NAME_0")));
        metadata.addItemDetails(otherOuDetails);
    }

    protected abstract void setStateActionCol(CmsListMetadata var1);

    protected void validateParamaters() throws Exception {
        this.m_paramGroupname = this.getCms().readGroup(new CmsUUID(this.getParamGroupid())).getName();
    }
}

