/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.accounts;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletException;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsUser;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsAccessControlEntry;
import org.opencms.security.CmsRole;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.list.A_CmsListDialog;
import org.opencms.workplace.list.CmsListColumnAlignEnum;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListDefaultAction;
import org.opencms.workplace.list.CmsListDirectAction;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListItemActionIconComparator;
import org.opencms.workplace.list.CmsListItemDetails;
import org.opencms.workplace.list.CmsListItemDetailsFormatter;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListMultiAction;
import org.opencms.workplace.list.CmsListOrderEnum;
import org.opencms.workplace.list.CmsListSearchAction;
import org.opencms.workplace.list.I_CmsListDirectAction;
import org.opencms.workplace.list.I_CmsListFormatter;
import org.opencms.workplace.list.I_CmsListItemComparator;
import org.opencms.workplace.tools.accounts.Messages;

public abstract class A_CmsGroupsList
extends A_CmsListDialog {
    public static final String LIST_ACTION_ACTIVATE = "aa";
    public static final String LIST_ACTION_DEACTIVATE = "ac";
    public static final String LIST_ACTION_DELETE = "ad";
    public static final String LIST_ACTION_EDIT = "ae";
    public static final String LIST_ACTION_USERS = "au";
    public static final String LIST_COLUMN_ACTIVATE = "ca";
    public static final String LIST_COLUMN_DELETE = "cd";
    public static final String LIST_COLUMN_DESCRIPTION = "cc";
    public static final String LIST_COLUMN_DISPLAY = "cdn";
    public static final String LIST_COLUMN_EDIT = "ce";
    public static final String LIST_COLUMN_NAME = "cn";
    public static final String LIST_COLUMN_USERS = "cu";
    public static final String LIST_DEFACTION_EDIT = "de";
    public static final String LIST_DETAIL_CHILDREN = "dc";
    public static final String LIST_DETAIL_PARENT = "dp";
    public static final String LIST_DETAIL_SET_PERM = "dsp";
    public static final String LIST_DETAIL_USERS = "du";
    public static final String LIST_MACTION_ACTIVATE = "ma";
    public static final String LIST_MACTION_DEACTIVATE = "mc";
    public static final String LIST_MACTION_DELETE = "md";
    private static Set m_deleteActionIds = new HashSet();
    private static Set m_editActionIds = new HashSet();
    private String m_paramOufqn;

    public A_CmsGroupsList(CmsJspActionElement jsp, String listId, CmsMessageContainer listName) {
        super(jsp, listId, listName, LIST_COLUMN_DISPLAY, CmsListOrderEnum.ORDER_ASCENDING, null);
    }

    public void executeListMultiActions() throws CmsRuntimeException {
        if (this.getParamListAction().equals(LIST_MACTION_DELETE)) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("groupid", this.getParamSelItems());
            params.put("action", "initial");
            try {
                this.getToolManager().jspForwardTool((CmsWorkplace)this, this.getCurrentToolPath() + "/delete", params);
            }
            catch (Exception e) {
                throw new CmsRuntimeException(Messages.get().container("ERR_DELETE_SELECTED_GROUPS_0"), (Throwable)e);
            }
        } else if (this.getParamListAction().equals(LIST_MACTION_ACTIVATE)) {
            try {
                Iterator itItems = this.getSelectedItems().iterator();
                while (itItems.hasNext()) {
                    CmsListItem listItem = (CmsListItem)itItems.next();
                    String groupName = listItem.get(LIST_COLUMN_NAME).toString();
                    CmsGroup group = this.getCms().readGroup(groupName);
                    if (group.isEnabled()) continue;
                    group.setEnabled(true);
                    this.getCms().writeGroup(group);
                }
            }
            catch (CmsException e) {
                throw new CmsRuntimeException(Messages.get().container("ERR_ACTIVATE_SELECTED_GROUPS_0"), (Throwable)e);
            }
        } else if (this.getParamListAction().equals(LIST_MACTION_DEACTIVATE)) {
            try {
                Iterator itItems = this.getSelectedItems().iterator();
                while (itItems.hasNext()) {
                    CmsListItem listItem = (CmsListItem)itItems.next();
                    String groupName = listItem.get(LIST_COLUMN_NAME).toString();
                    CmsGroup group = this.getCms().readGroup(groupName);
                    if (!group.isEnabled()) continue;
                    group.setEnabled(false);
                    this.getCms().writeGroup(group);
                }
            }
            catch (CmsException e) {
                throw new CmsRuntimeException(Messages.get().container("ERR_DEACTIVATE_SELECTED_GROUPS_0"), (Throwable)e);
            }
        } else {
            this.throwListUnsupportedActionException();
        }
        this.listSave();
    }

    public void executeListSingleActions() throws IOException, ServletException, CmsRuntimeException {
        String groupId = this.getSelectedItem().getId();
        String groupName = this.getSelectedItem().get(LIST_COLUMN_NAME).toString();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("groupid", groupId);
        params.put("oufqn", this.m_paramOufqn);
        params.put("groupname", groupName);
        params.put("action", "initial");
        if (this.getParamListAction().equals(LIST_DEFACTION_EDIT)) {
            this.getToolManager().jspForwardTool((CmsWorkplace)this, this.getCurrentToolPath() + "/edit", params);
        } else if (m_editActionIds.contains(this.getParamListAction())) {
            this.getToolManager().jspForwardTool((CmsWorkplace)this, this.getCurrentToolPath() + "/edit/group", params);
        } else if (this.getParamListAction().equals(LIST_ACTION_USERS)) {
            this.getToolManager().jspForwardTool((CmsWorkplace)this, this.getCurrentToolPath() + "/edit/users", params);
        } else if (m_deleteActionIds.contains(this.getParamListAction())) {
            this.getToolManager().jspForwardTool((CmsWorkplace)this, this.getCurrentToolPath() + "/edit/delete", params);
        } else if (this.getParamListAction().equals(LIST_ACTION_ACTIVATE)) {
            try {
                CmsGroup group = this.getCms().readGroup(groupName);
                group.setEnabled(true);
                this.getCms().writeGroup(group);
            }
            catch (CmsException e) {
                throw new CmsRuntimeException(Messages.get().container("ERR_ACTIVATE_GROUP_1", (Object)groupName), (Throwable)e);
            }
        } else if (this.getParamListAction().equals(LIST_ACTION_DEACTIVATE)) {
            try {
                CmsGroup group = this.getCms().readGroup(groupName);
                group.setEnabled(false);
                this.getCms().writeGroup(group);
            }
            catch (CmsException e) {
                throw new CmsRuntimeException(Messages.get().container("ERR_DEACTIVATE_GROUP_1", (Object)groupName), (Throwable)e);
            }
        } else {
            this.throwListUnsupportedActionException();
        }
        this.listSave();
    }

    public String getParamOufqn() {
        return this.m_paramOufqn;
    }

    public void setParamOufqn(String ouFqn) {
        if (ouFqn == null) {
            ouFqn = "";
        }
        this.m_paramOufqn = ouFqn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillDetails(String detailId) {
        List groups = this.getList().getAllContent();
        Iterator itGroups = groups.iterator();
        while (itGroups.hasNext()) {
            StringBuffer html;
            CmsListItem item;
            block20: {
                item = (CmsListItem)itGroups.next();
                String groupName = item.get(LIST_COLUMN_NAME).toString();
                html = new StringBuffer(512);
                try {
                    CmsGroup group;
                    if (detailId.equals(LIST_DETAIL_USERS)) {
                        List users = this.getCms().getUsersOfGroup(groupName, true);
                        Iterator itUsers = users.iterator();
                        while (itUsers.hasNext()) {
                            CmsUser user = (CmsUser)itUsers.next();
                            if (user.getOuFqn().equals(this.getParamOufqn())) {
                                html.append(user.getFullName());
                            } else {
                                html.append(user.getDisplayName(this.getCms(), this.getLocale()));
                            }
                            if (itUsers.hasNext()) {
                                html.append("<br>");
                            }
                            html.append("\n");
                        }
                        break block20;
                    }
                    if (detailId.equals(LIST_DETAIL_CHILDREN)) {
                        Iterator itChildren = this.getCms().getChildren(groupName, false).iterator();
                        while (itChildren.hasNext()) {
                            group = (CmsGroup)itChildren.next();
                            if (group.getOuFqn().equals(this.getParamOufqn())) {
                                html.append(group.getSimpleName());
                            } else {
                                html.append(group.getDisplayName(this.getCms(), this.getLocale()));
                            }
                            if (itChildren.hasNext()) {
                                html.append("<br>");
                            }
                            html.append("\n");
                        }
                        break block20;
                    }
                    if (detailId.equals(LIST_DETAIL_PARENT)) {
                        CmsGroup parent = this.getCms().readGroup(this.getCms().readGroup(groupName).getParentId());
                        html.append(parent.getName());
                        break block20;
                    }
                    if (!detailId.equals(LIST_DETAIL_SET_PERM)) continue;
                    String storedSiteRoot = this.getCms().getRequestContext().getSiteRoot();
                    try {
                        this.getCms().getRequestContext().setSiteRoot("/");
                        group = this.getCms().readGroup(groupName);
                        Iterator itRes = this.getCms().getResourcesForPrincipal(group.getId(), null, false).iterator();
                        while (itRes.hasNext()) {
                            CmsResource resource = (CmsResource)itRes.next();
                            html.append(resource.getRootPath());
                            Iterator itAces = this.getCms().getAccessControlEntries(resource.getRootPath(), false).iterator();
                            while (itAces.hasNext()) {
                                CmsAccessControlEntry ace = (CmsAccessControlEntry)itAces.next();
                                if (!ace.getPrincipal().equals((Object)group.getId())) continue;
                                if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)ace.getPermissions().getPermissionString())) break;
                                html.append(" (" + ace.getPermissions().getPermissionString() + ")");
                                break;
                            }
                            if (itRes.hasNext()) {
                                html.append("<br>");
                            }
                            html.append("\n");
                        }
                    }
                    finally {
                        this.getCms().getRequestContext().setSiteRoot(storedSiteRoot);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            item.set(detailId, (Object)html.toString());
        }
    }

    protected abstract List getGroups() throws CmsException;

    protected List getListItems() throws CmsException {
        ArrayList<CmsListItem> ret = new ArrayList<CmsListItem>();
        List groups = this.getGroups();
        Iterator itGroups = groups.iterator();
        while (itGroups.hasNext()) {
            CmsGroup group = (CmsGroup)itGroups.next();
            CmsListItem item = this.getList().newItem(group.getId().toString());
            item.set(LIST_COLUMN_NAME, (Object)group.getName());
            item.set(LIST_COLUMN_DISPLAY, (Object)group.getSimpleName());
            item.set(LIST_COLUMN_DESCRIPTION, (Object)group.getDescription(this.getLocale()));
            ret.add(item);
        }
        return ret;
    }

    protected void initMessages() {
        this.addMessages(Messages.get().getBundleName());
        super.initMessages();
    }

    protected void setColumns(CmsListMetadata metadata) {
        CmsListColumnDefinition editCol = new CmsListColumnDefinition(LIST_COLUMN_EDIT);
        editCol.setName(Messages.get().container("GUI_GROUPS_LIST_COLS_EDIT_0"));
        editCol.setHelpText(Messages.get().container("GUI_GROUPS_LIST_COLS_EDIT_HELP_0"));
        editCol.setWidth("20");
        editCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        editCol.setSorteable(false);
        this.setEditAction(editCol);
        m_editActionIds.addAll(editCol.getDirectActionIds());
        metadata.addColumn(editCol);
        CmsListColumnDefinition usersCol = new CmsListColumnDefinition(LIST_COLUMN_USERS);
        usersCol.setName(Messages.get().container("GUI_GROUPS_LIST_COLS_USERS_0"));
        usersCol.setHelpText(Messages.get().container("GUI_GROUPS_LIST_COLS_USERS_HELP_0"));
        usersCol.setWidth("20");
        usersCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        usersCol.setSorteable(false);
        CmsListDirectAction usersAction = new CmsListDirectAction(LIST_ACTION_USERS);
        usersAction.setName(Messages.get().container("GUI_GROUPS_LIST_ACTION_USERS_NAME_0"));
        usersAction.setHelpText(Messages.get().container("GUI_GROUPS_LIST_ACTION_USERS_HELP_0"));
        usersAction.setIconPath("tools/accounts/buttons/user.png");
        usersCol.addDirectAction((I_CmsListDirectAction)usersAction);
        metadata.addColumn(usersCol);
        CmsListColumnDefinition actCol = new CmsListColumnDefinition(LIST_COLUMN_ACTIVATE);
        actCol.setName(Messages.get().container("GUI_GROUPS_LIST_COLS_ACTIVATE_0"));
        actCol.setHelpText(Messages.get().container("GUI_GROUPS_LIST_COLS_ACTIVATE_HELP_0"));
        actCol.setWidth("20");
        actCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        actCol.setListItemComparator((I_CmsListItemComparator)new CmsListItemActionIconComparator());
        CmsListDirectAction actAction = new CmsListDirectAction(LIST_ACTION_ACTIVATE){

            public boolean isVisible() {
                if (this.getItem() != null) {
                    String groupId = this.getItem().getId();
                    try {
                        return !A_CmsGroupsList.this.getCms().readGroup(new CmsUUID(groupId)).isEnabled();
                    }
                    catch (CmsException e) {
                        return false;
                    }
                }
                return super.isVisible();
            }
        };
        actAction.setName(Messages.get().container("GUI_GROUPS_LIST_ACTION_ACTIVATE_NAME_0"));
        actAction.setHelpText(Messages.get().container("GUI_GROUPS_LIST_ACTION_ACTIVATE_HELP_0"));
        actAction.setConfirmationMessage(Messages.get().container("GUI_GROUPS_LIST_ACTION_ACTIVATE_CONF_0"));
        actAction.setIconPath("list/inactive.png");
        actCol.addDirectAction((I_CmsListDirectAction)actAction);
        CmsListDirectAction deactAction = new CmsListDirectAction(LIST_ACTION_DEACTIVATE){

            public boolean isVisible() {
                if (this.getItem() != null) {
                    String groupId = this.getItem().getId();
                    try {
                        return A_CmsGroupsList.this.getCms().readGroup(new CmsUUID(groupId)).isEnabled();
                    }
                    catch (CmsException e) {
                        return false;
                    }
                }
                return super.isVisible();
            }
        };
        deactAction.setName(Messages.get().container("GUI_GROUPS_LIST_ACTION_DEACTIVATE_NAME_0"));
        deactAction.setHelpText(Messages.get().container("GUI_GROUPS_LIST_ACTION_DEACTIVATE_HELP_0"));
        deactAction.setConfirmationMessage(Messages.get().container("GUI_GROUPS_LIST_ACTION_DEACTIVATE_CONF_0"));
        deactAction.setIconPath("list/active.png");
        actCol.addDirectAction((I_CmsListDirectAction)deactAction);
        metadata.addColumn(actCol);
        CmsListColumnDefinition deleteCol = new CmsListColumnDefinition(LIST_COLUMN_DELETE);
        deleteCol.setName(Messages.get().container("GUI_GROUPS_LIST_COLS_DELETE_0"));
        deleteCol.setHelpText(Messages.get().container("GUI_GROUPS_LIST_COLS_DELETE_HELP_0"));
        deleteCol.setWidth("20");
        deleteCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        deleteCol.setSorteable(false);
        this.setDeleteAction(deleteCol);
        m_deleteActionIds.addAll(deleteCol.getDirectActionIds());
        metadata.addColumn(deleteCol);
        CmsListColumnDefinition nameCol = new CmsListColumnDefinition(LIST_COLUMN_NAME);
        metadata.addColumn(nameCol);
        nameCol.setVisible(false);
        CmsListColumnDefinition displayCol = new CmsListColumnDefinition(LIST_COLUMN_DISPLAY);
        displayCol.setName(Messages.get().container("GUI_GROUPS_LIST_COLS_NAME_0"));
        displayCol.setWidth("35%");
        CmsListDefaultAction defEditAction = new CmsListDefaultAction(LIST_DEFACTION_EDIT);
        defEditAction.setName(Messages.get().container("GUI_GROUPS_LIST_DEFACTION_EDIT_NAME_0"));
        defEditAction.setHelpText(Messages.get().container("GUI_GROUPS_LIST_DEFACTION_EDIT_HELP_0"));
        displayCol.addDefaultAction(defEditAction);
        metadata.addColumn(displayCol);
        CmsListColumnDefinition descriptionCol = new CmsListColumnDefinition(LIST_COLUMN_DESCRIPTION);
        descriptionCol.setName(Messages.get().container("GUI_GROUPS_LIST_COLS_DESCRIPTION_0"));
        descriptionCol.setWidth("65%");
        metadata.addColumn(descriptionCol);
    }

    protected abstract void setDeleteAction(CmsListColumnDefinition var1);

    protected abstract void setEditAction(CmsListColumnDefinition var1);

    protected void setIndependentActions(CmsListMetadata metadata) {
        CmsListItemDetails usersDetails = new CmsListItemDetails(LIST_DETAIL_USERS);
        usersDetails.setAtColumn(LIST_COLUMN_DISPLAY);
        usersDetails.setVisible(false);
        usersDetails.setShowActionName(Messages.get().container("GUI_GROUPS_DETAIL_SHOW_USERS_NAME_0"));
        usersDetails.setShowActionHelpText(Messages.get().container("GUI_GROUPS_DETAIL_SHOW_USERS_HELP_0"));
        usersDetails.setHideActionName(Messages.get().container("GUI_GROUPS_DETAIL_HIDE_USERS_NAME_0"));
        usersDetails.setHideActionHelpText(Messages.get().container("GUI_GROUPS_DETAIL_HIDE_USERS_HELP_0"));
        usersDetails.setName(Messages.get().container("GUI_GROUPS_DETAIL_USERS_NAME_0"));
        usersDetails.setFormatter((I_CmsListFormatter)new CmsListItemDetailsFormatter(Messages.get().container("GUI_GROUPS_DETAIL_USERS_NAME_0")));
        metadata.addItemDetails(usersDetails);
        CmsListItemDetails childDetails = new CmsListItemDetails(LIST_DETAIL_CHILDREN);
        childDetails.setAtColumn(LIST_COLUMN_DISPLAY);
        childDetails.setVisible(false);
        childDetails.setShowActionName(Messages.get().container("GUI_GROUPS_DETAIL_SHOW_CHILDREN_NAME_0"));
        childDetails.setShowActionHelpText(Messages.get().container("GUI_GROUPS_DETAIL_SHOW_CHILDREN_HELP_0"));
        childDetails.setHideActionName(Messages.get().container("GUI_GROUPS_DETAIL_HIDE_CHILDREN_NAME_0"));
        childDetails.setHideActionHelpText(Messages.get().container("GUI_GROUPS_DETAIL_HIDE_CHILDREN_HELP_0"));
        childDetails.setName(Messages.get().container("GUI_GROUPS_DETAIL_CHILDREN_NAME_0"));
        childDetails.setFormatter((I_CmsListFormatter)new CmsListItemDetailsFormatter(Messages.get().container("GUI_GROUPS_DETAIL_CHILDREN_NAME_0")));
        metadata.addItemDetails(childDetails);
        CmsListItemDetails parentDetails = new CmsListItemDetails(LIST_DETAIL_PARENT);
        parentDetails.setAtColumn(LIST_COLUMN_DISPLAY);
        parentDetails.setVisible(false);
        parentDetails.setShowActionName(Messages.get().container("GUI_GROUPS_DETAIL_SHOW_PARENT_NAME_0"));
        parentDetails.setShowActionHelpText(Messages.get().container("GUI_GROUPS_DETAIL_SHOW_PARENT_HELP_0"));
        parentDetails.setHideActionName(Messages.get().container("GUI_GROUPS_DETAIL_HIDE_PARENT_NAME_0"));
        parentDetails.setHideActionHelpText(Messages.get().container("GUI_GROUPS_DETAIL_HIDE_PARENT_HELP_0"));
        parentDetails.setName(Messages.get().container("GUI_GROUPS_DETAIL_PARENT_NAME_0"));
        parentDetails.setFormatter((I_CmsListFormatter)new CmsListItemDetailsFormatter(Messages.get().container("GUI_GROUPS_DETAIL_PARENT_NAME_0")));
        metadata.addItemDetails(parentDetails);
        CmsListItemDetails setPermDetails = new CmsListItemDetails(LIST_DETAIL_SET_PERM);
        setPermDetails.setAtColumn(LIST_COLUMN_DISPLAY);
        setPermDetails.setVisible(false);
        setPermDetails.setShowActionName(Messages.get().container("GUI_GROUPS_DETAIL_SHOW_SET_PERM_NAME_0"));
        setPermDetails.setShowActionHelpText(Messages.get().container("GUI_GROUPS_DETAIL_SHOW_SET_PERM_HELP_0"));
        setPermDetails.setHideActionName(Messages.get().container("GUI_GROUPS_DETAIL_HIDE_SET_PERM_NAME_0"));
        setPermDetails.setHideActionHelpText(Messages.get().container("GUI_GROUPS_DETAIL_HIDE_SET_PERM_HELP_0"));
        setPermDetails.setName(Messages.get().container("GUI_GROUPS_DETAIL_SET_PERM_NAME_0"));
        setPermDetails.setFormatter((I_CmsListFormatter)new CmsListItemDetailsFormatter(Messages.get().container("GUI_GROUPS_DETAIL_SET_PERM_NAME_0")));
        metadata.addItemDetails(setPermDetails);
        CmsListSearchAction searchAction = new CmsListSearchAction(metadata.getColumnDefinition(LIST_COLUMN_DISPLAY));
        metadata.setSearchAction(searchAction);
    }

    protected void setMultiActions(CmsListMetadata metadata) {
        CmsListMultiAction deleteMultiAction = new CmsListMultiAction(LIST_MACTION_DELETE);
        deleteMultiAction.setName(Messages.get().container("GUI_GROUPS_LIST_MACTION_DELETE_NAME_0"));
        deleteMultiAction.setHelpText(Messages.get().container("GUI_GROUPS_LIST_MACTION_DELETE_HELP_0"));
        deleteMultiAction.setConfirmationMessage(Messages.get().container("GUI_GROUPS_LIST_MACTION_DELETE_CONF_0"));
        deleteMultiAction.setIconPath("list/multi_delete.png");
        metadata.addMultiAction(deleteMultiAction);
        CmsListMultiAction activateUser = new CmsListMultiAction(LIST_MACTION_ACTIVATE);
        activateUser.setName(Messages.get().container("GUI_GROUPS_LIST_MACTION_ACTIVATE_NAME_0"));
        activateUser.setHelpText(Messages.get().container("GUI_GROUPS_LIST_MACTION_ACTIVATE_HELP_0"));
        activateUser.setConfirmationMessage(Messages.get().container("GUI_GROUPS_LIST_MACTION_ACTIVATE_CONF_0"));
        activateUser.setIconPath("list/multi_activate.png");
        metadata.addMultiAction(activateUser);
        CmsListMultiAction deactivateUser = new CmsListMultiAction(LIST_MACTION_DEACTIVATE);
        deactivateUser.setName(Messages.get().container("GUI_GROUPS_LIST_MACTION_DEACTIVATE_NAME_0"));
        deactivateUser.setHelpText(Messages.get().container("GUI_GROUPS_LIST_MACTION_DEACTIVATE_HELP_0"));
        deactivateUser.setConfirmationMessage(Messages.get().container("GUI_GROUPS_LIST_MACTION_DEACTIVATE_CONF_0"));
        deactivateUser.setIconPath("list/multi_deactivate.png");
        metadata.addMultiAction(deactivateUser);
    }

    protected void validateParamaters() throws Exception {
        OpenCms.getRoleManager().checkRole(this.getCms(), CmsRole.ACCOUNT_MANAGER.forOrgUnit(this.getParamOufqn()));
        OpenCms.getOrgUnitManager().readOrganizationalUnit(this.getCms(), this.getParamOufqn()).getName();
    }
}

