/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.accounts;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.CmsSelectWidgetOption;
import org.opencms.workplace.CmsWidgetDialog;

public abstract class A_CmsUserDataImexportDialog
extends CmsWidgetDialog {
    public static final String[] PAGES = new String[]{"page1"};
    private List m_groups;
    private String m_paramOufqn;
    private List m_roles;

    public A_CmsUserDataImexportDialog(CmsJspActionElement jsp) {
        super(jsp);
    }

    public A_CmsUserDataImexportDialog(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public abstract void actionCommit() throws IOException, ServletException;

    public List getGroups() {
        return this.m_groups;
    }

    public String getParamOufqn() {
        return this.m_paramOufqn;
    }

    public List getRoles() {
        return this.m_roles;
    }

    public void setGroups(List groups) {
        this.m_groups = groups;
    }

    public void setParamOufqn(String ouFqn) {
        if (ouFqn == null) {
            ouFqn = "";
        }
        this.m_paramOufqn = ouFqn;
    }

    public void setRoles(List roles) {
        this.m_roles = roles;
    }

    protected abstract void defineWidgets();

    protected String[] getPageArray() {
        return PAGES;
    }

    protected List getSelectRoles() {
        ArrayList<CmsSelectWidgetOption> retVal = new ArrayList<CmsSelectWidgetOption>();
        try {
            boolean inRootOu = CmsStringUtil.isEmptyOrWhitespaceOnly((String)this.getParamOufqn()) || "/".equals(this.getParamOufqn());
            List roles = OpenCms.getRoleManager().getRolesOfUser(this.getCms(), this.getCms().getRequestContext().currentUser().getName(), this.getParamOufqn(), false, false, false);
            Iterator itRoles = roles.iterator();
            while (itRoles.hasNext()) {
                CmsRole role = (CmsRole)itRoles.next();
                if (role.isOrganizationalUnitIndependent() && !inRootOu) continue;
                retVal.add(new CmsSelectWidgetOption(role.getGroupName(), false, role.getName(this.getLocale())));
            }
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
        Collections.sort(retVal, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                if (!(arg0 instanceof CmsSelectWidgetOption) || !(arg1 instanceof CmsSelectWidgetOption)) {
                    return 0;
                }
                CmsSelectWidgetOption opt0 = (CmsSelectWidgetOption)arg0;
                CmsSelectWidgetOption opt1 = (CmsSelectWidgetOption)arg1;
                return opt0.getOption().compareTo(opt1.getOption());
            }
        });
        return retVal;
    }
}

