/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.accounts;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opencms.file.CmsGroup;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.list.A_CmsListDialog;
import org.opencms.workplace.list.CmsListColumnAlignEnum;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListIndependentAction;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListItemDetails;
import org.opencms.workplace.list.CmsListItemDetailsFormatter;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListOrderEnum;
import org.opencms.workplace.list.I_CmsListAction;
import org.opencms.workplace.list.I_CmsListFormatter;
import org.opencms.workplace.tools.accounts.Messages;

public abstract class A_CmsUserGroupsList
extends A_CmsListDialog {
    public static final String LIST_ACTION_ICON = "ai";
    public static final String LIST_ACTION_ICON_DIRECT = "aid";
    public static final String LIST_ACTION_ICON_INDIRECT = "aii";
    public static final String LIST_ACTION_STATE_DIRECT = "asd";
    public static final String LIST_ACTION_STATE_INDIRECT = "asi";
    public static final String LIST_COLUMN_DESCRIPTION = "cd";
    public static final String LIST_COLUMN_DISPLAY = "cdn";
    public static final String LIST_COLUMN_ICON = "ci";
    public static final String LIST_COLUMN_NAME = "cn";
    public static final String LIST_COLUMN_ORGUNIT = "co";
    public static final String LIST_COLUMN_STATE = "cs";
    public static final String LIST_DETAIL_OTHEROU = "doo";
    private Boolean m_hasGroupsInOtherOus;
    private String m_paramOufqn;
    private String m_paramUserid;
    private String m_paramUsername;

    protected A_CmsUserGroupsList(CmsJspActionElement jsp, String listId, CmsMessageContainer listName, boolean searchable) {
        super(jsp, listId, listName, LIST_COLUMN_DISPLAY, CmsListOrderEnum.ORDER_ASCENDING, searchable ? LIST_COLUMN_DISPLAY : null);
    }

    public String getParamOufqn() {
        return this.m_paramOufqn;
    }

    public String getParamUserid() {
        return this.m_paramUserid;
    }

    public String getParamUsername() {
        return this.m_paramUsername;
    }

    public boolean hasGroupsInOtherOus() {
        if (this.m_hasGroupsInOtherOus == null) {
            this.m_hasGroupsInOtherOus = Boolean.FALSE;
            try {
                List groups = this.getGroups(true);
                Iterator itGroups = groups.iterator();
                while (itGroups.hasNext()) {
                    CmsGroup group = (CmsGroup)itGroups.next();
                    if (group.getOuFqn().equals(this.getParamOufqn())) continue;
                    this.m_hasGroupsInOtherOus = Boolean.TRUE;
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.m_hasGroupsInOtherOus;
    }

    public void setParamOufqn(String ouFqn) {
        if (ouFqn == null) {
            ouFqn = "";
        }
        this.m_paramOufqn = ouFqn;
    }

    public void setParamUserid(String userId) {
        this.m_paramUserid = userId;
    }

    public void setParamUsername(String username) {
        this.m_paramUsername = username;
    }

    protected void fillDetails(String detailId) {
    }

    protected abstract List getGroups(boolean var1) throws CmsException;

    protected List getListItems() throws CmsException {
        CmsListItemDetails details = this.getList().getMetadata().getItemDetailDefinition(LIST_DETAIL_OTHEROU);
        boolean withOtherOus = this.hasGroupsInOtherOus() && details != null && details.isVisible();
        ArrayList<CmsListItem> ret = new ArrayList<CmsListItem>();
        List groups = this.getGroups(withOtherOus);
        Iterator itGroups = groups.iterator();
        while (itGroups.hasNext()) {
            CmsGroup group = (CmsGroup)itGroups.next();
            CmsListItem item = this.getList().newItem(group.getId().toString());
            item.set(LIST_COLUMN_NAME, (Object)group.getName());
            item.set(LIST_COLUMN_DISPLAY, (Object)group.getSimpleName());
            item.set(LIST_COLUMN_DESCRIPTION, (Object)group.getDescription(this.getLocale()));
            item.set(LIST_COLUMN_ORGUNIT, (Object)("/" + group.getOuFqn()));
            ret.add(item);
        }
        return ret;
    }

    protected void initializeDetail(String detailId) {
        super.initializeDetail(detailId);
        if (detailId.equals(LIST_DETAIL_OTHEROU)) {
            boolean visible = this.hasGroupsInOtherOus() && this.getList().getMetadata().getItemDetailDefinition(LIST_DETAIL_OTHEROU).isVisible();
            this.getList().getMetadata().getColumnDefinition(LIST_COLUMN_ORGUNIT).setVisible(visible);
            this.getList().getMetadata().getColumnDefinition(LIST_COLUMN_ORGUNIT).setPrintable(visible);
        }
    }

    protected void initMessages() {
        this.addMessages(Messages.get().getBundleName());
        super.initMessages();
    }

    protected void setColumns(CmsListMetadata metadata) {
        CmsListColumnDefinition iconCol = new CmsListColumnDefinition(LIST_COLUMN_ICON);
        iconCol.setName(Messages.get().container("GUI_GROUPS_LIST_COLS_ICON_0"));
        iconCol.setHelpText(Messages.get().container("GUI_GROUPS_LIST_COLS_ICON_HELP_0"));
        iconCol.setWidth("20");
        iconCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        iconCol.setSorteable(false);
        this.setIconAction(iconCol);
        metadata.addColumn(iconCol);
        this.setStateActionCol(metadata);
        CmsListColumnDefinition nameCol = new CmsListColumnDefinition(LIST_COLUMN_NAME);
        nameCol.setVisible(false);
        metadata.addColumn(nameCol);
        CmsListColumnDefinition displayCol = new CmsListColumnDefinition(LIST_COLUMN_DISPLAY);
        displayCol.setName(Messages.get().container("GUI_GROUPS_LIST_COLS_NAME_0"));
        displayCol.setWidth("35%");
        this.setDefaultAction(displayCol);
        metadata.addColumn(displayCol);
        CmsListColumnDefinition orgunitCol = new CmsListColumnDefinition(LIST_COLUMN_ORGUNIT);
        orgunitCol.setName(Messages.get().container("GUI_USERS_LIST_COLS_ORGUNIT_0"));
        orgunitCol.setVisible(false);
        metadata.addColumn(orgunitCol);
        CmsListColumnDefinition descCol = new CmsListColumnDefinition(LIST_COLUMN_DESCRIPTION);
        descCol.setName(Messages.get().container("GUI_GROUPS_LIST_COLS_DESCRIPTION_0"));
        descCol.setWidth("65%");
        descCol.setTextWrapping(true);
        metadata.addColumn(descCol);
    }

    protected abstract void setDefaultAction(CmsListColumnDefinition var1);

    protected abstract void setIconAction(CmsListColumnDefinition var1);

    protected void setIndependentActions(CmsListMetadata metadata) {
        CmsListItemDetails otherOuDetails = new CmsListItemDetails(LIST_DETAIL_OTHEROU);
        otherOuDetails.setHideAction((I_CmsListAction)new CmsListIndependentAction(LIST_DETAIL_OTHEROU){

            public String getIconPath() {
                return "list/details_hide.png";
            }

            public boolean isVisible() {
                return ((A_CmsUserGroupsList)this.getWp()).hasGroupsInOtherOus();
            }
        });
        otherOuDetails.setShowAction((I_CmsListAction)new CmsListIndependentAction(LIST_DETAIL_OTHEROU){

            public String getIconPath() {
                return "list/details_show.png";
            }

            public boolean isVisible() {
                return ((A_CmsUserGroupsList)this.getWp()).hasGroupsInOtherOus();
            }
        });
        otherOuDetails.setShowActionName(Messages.get().container("GUI_GROUPS_DETAIL_SHOW_OTHEROU_NAME_0"));
        otherOuDetails.setShowActionHelpText(Messages.get().container("GUI_GROUPS_DETAIL_SHOW_OTHEROU_HELP_0"));
        otherOuDetails.setHideActionName(Messages.get().container("GUI_GROUPS_DETAIL_HIDE_OTHEROU_NAME_0"));
        otherOuDetails.setHideActionHelpText(Messages.get().container("GUI_GROUPS_DETAIL_HIDE_OTHEROU_HELP_0"));
        otherOuDetails.setName(Messages.get().container("GUI_GROUPS_DETAIL_OTHEROU_NAME_0"));
        otherOuDetails.setFormatter((I_CmsListFormatter)new CmsListItemDetailsFormatter(Messages.get().container("GUI_GROUPS_DETAIL_OTHEROU_NAME_0")));
        otherOuDetails.setVisible(true);
        metadata.addItemDetails(otherOuDetails);
    }

    protected abstract void setStateActionCol(CmsListMetadata var1);

    protected void validateParamaters() throws Exception {
        this.m_paramUsername = this.getCms().readUser(new CmsUUID(this.getParamUserid())).getName();
    }
}

