/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.accounts;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletException;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsUser;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.list.A_CmsListDialog;
import org.opencms.workplace.list.CmsListColumnAlignEnum;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListDateMacroFormatter;
import org.opencms.workplace.list.CmsListDefaultAction;
import org.opencms.workplace.list.CmsListDirectAction;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListItemActionIconComparator;
import org.opencms.workplace.list.CmsListItemDetails;
import org.opencms.workplace.list.CmsListItemDetailsFormatter;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListMultiAction;
import org.opencms.workplace.list.CmsListOrderEnum;
import org.opencms.workplace.list.CmsListSearchAction;
import org.opencms.workplace.list.I_CmsListDirectAction;
import org.opencms.workplace.list.I_CmsListFormatter;
import org.opencms.workplace.list.I_CmsListItemComparator;
import org.opencms.workplace.tools.accounts.Messages;

public abstract class A_CmsUsersList
extends A_CmsListDialog {
    public static final String LIST_ACTION_ACTIVATE = "aa";
    public static final String LIST_ACTION_DEACTIVATE = "ac";
    public static final String LIST_ACTION_DELETE = "ad";
    public static final String LIST_ACTION_EDIT = "ae";
    public static final String LIST_ACTION_GROUPS = "ag";
    public static final String LIST_ACTION_ROLE = "ar";
    public static final String LIST_ACTION_ROLES = "ar";
    public static final String LIST_COLUMN_ACTIVATE = "ca";
    public static final String LIST_COLUMN_DELETE = "cd";
    public static final String LIST_COLUMN_DISPLAY = "cdn";
    public static final String LIST_COLUMN_EDIT = "ce";
    public static final String LIST_COLUMN_EMAIL = "cm";
    public static final String LIST_COLUMN_GROUPS = "cg";
    public static final String LIST_COLUMN_LASTLOGIN = "cl";
    public static final String LIST_COLUMN_LOGIN = "ci";
    public static final String LIST_COLUMN_ENABLED = "ceb";
    public static final String LIST_COLUMN_NAME = "cn";
    public static final String LIST_COLUMN_ROLE = "cr";
    public static final String LIST_DEFACTION_EDIT = "de";
    public static final String LIST_DETAIL_ADDRESS = "da";
    public static final String LIST_DETAIL_GROUPS = "dg";
    public static final String LIST_DETAIL_ROLES = "dr";
    public static final String LIST_MACTION_ACTIVATE = "ma";
    public static final String LIST_MACTION_DEACTIVATE = "mc";
    public static final String LIST_MACTION_DELETE = "md";
    public static final String PATH_BUTTONS = "tools/accounts/buttons/";
    private static Set m_deleteActionIds = new HashSet();
    private static Set m_editActionIds = new HashSet();
    private String m_paramOufqn;

    public A_CmsUsersList(CmsJspActionElement jsp, String listId, CmsMessageContainer listName) {
        super(jsp, listId, listName, LIST_COLUMN_DISPLAY, CmsListOrderEnum.ORDER_ASCENDING, null);
    }

    public void executeListMultiActions() throws CmsRuntimeException {
        if (this.getParamListAction().equals(LIST_MACTION_DELETE)) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("userid", this.getParamSelItems());
            params.put("action", "initial");
            try {
                this.getToolManager().jspForwardTool((CmsWorkplace)this, this.getCurrentToolPath() + "/delete", params);
            }
            catch (Exception e) {
                throw new CmsRuntimeException(Messages.get().container("ERR_DELETE_SELECTED_USERS_0"), (Throwable)e);
            }
        } else if (this.getParamListAction().equals(LIST_MACTION_ACTIVATE)) {
            try {
                Iterator itItems = this.getSelectedItems().iterator();
                while (itItems.hasNext()) {
                    CmsListItem listItem = (CmsListItem)itItems.next();
                    String usrName = listItem.get(LIST_COLUMN_LOGIN).toString();
                    CmsUser user = this.readUser(usrName);
                    if (user.isEnabled()) continue;
                    user.setEnabled(true);
                    this.getCms().writeUser(user);
                }
            }
            catch (CmsException e) {
                throw new CmsRuntimeException(Messages.get().container("ERR_ACTIVATE_SELECTED_USERS_0"), (Throwable)e);
            }
        } else if (this.getParamListAction().equals(LIST_MACTION_DEACTIVATE)) {
            try {
                Iterator itItems = this.getSelectedItems().iterator();
                while (itItems.hasNext()) {
                    CmsListItem listItem = (CmsListItem)itItems.next();
                    String usrName = listItem.get(LIST_COLUMN_LOGIN).toString();
                    CmsUser user = this.readUser(usrName);
                    if (!user.isEnabled()) continue;
                    user.setEnabled(false);
                    this.getCms().writeUser(user);
                }
            }
            catch (CmsException e) {
                throw new CmsRuntimeException(Messages.get().container("ERR_DEACTIVATE_SELECTED_USERS_0"), (Throwable)e);
            }
        } else {
            this.throwListUnsupportedActionException();
        }
        this.listSave();
    }

    public void executeListSingleActions() throws IOException, ServletException {
        String userId = this.getSelectedItem().getId();
        String userName = this.getSelectedItem().get(LIST_COLUMN_LOGIN).toString();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userid", userId);
        params.put("oufqn", this.getParamOufqn());
        params.put("action", "initial");
        if (this.getParamListAction().equals("ar")) {
            this.getToolManager().jspForwardTool((CmsWorkplace)this, this.getCurrentToolPath() + "/edit/role", params);
        } else if (this.getParamListAction().equals(LIST_DEFACTION_EDIT)) {
            this.getToolManager().jspForwardTool((CmsWorkplace)this, this.getCurrentToolPath() + "/edit", params);
        } else if (m_editActionIds.contains(this.getParamListAction())) {
            this.getToolManager().jspForwardTool((CmsWorkplace)this, this.getCurrentToolPath() + "/edit/user", params);
        } else if (this.getParamListAction().equals(LIST_ACTION_GROUPS)) {
            this.getToolManager().jspForwardTool((CmsWorkplace)this, this.getCurrentToolPath() + "/edit/groups", params);
        } else if (m_deleteActionIds.contains(this.getParamListAction())) {
            this.getToolManager().jspForwardTool((CmsWorkplace)this, this.getCurrentToolPath() + "/edit/delete", params);
        } else if (this.getParamListAction().equals(LIST_ACTION_ACTIVATE)) {
            try {
                CmsUser user = this.readUser(userName);
                user.setEnabled(true);
                this.getCms().writeUser(user);
            }
            catch (CmsException e) {
                throw new CmsRuntimeException(Messages.get().container("ERR_ACTIVATE_USER_1", (Object)userName), (Throwable)e);
            }
        } else if (this.getParamListAction().equals(LIST_ACTION_DEACTIVATE)) {
            try {
                CmsUser user = this.readUser(userName);
                user.setEnabled(false);
                this.getCms().writeUser(user);
            }
            catch (CmsException e) {
                throw new CmsRuntimeException(Messages.get().container("ERR_DEACTIVATE_USER_1", (Object)userName), (Throwable)e);
            }
        } else {
            this.throwListUnsupportedActionException();
        }
        this.listSave();
    }

    public String getParamOufqn() {
        return this.m_paramOufqn;
    }

    public void setParamOufqn(String ouFqn) {
        if (ouFqn == null) {
            ouFqn = "";
        }
        this.m_paramOufqn = ouFqn;
    }

    protected void fillDetails(String detailId) {
        List users = this.getList().getAllContent();
        Iterator itUsers = users.iterator();
        while (itUsers.hasNext()) {
            CmsListItem item = (CmsListItem)itUsers.next();
            String userName = item.get(LIST_COLUMN_LOGIN).toString();
            StringBuffer html = new StringBuffer(512);
            try {
                if (detailId.equals(LIST_DETAIL_ADDRESS)) {
                    CmsUser user = this.readUser(userName);
                    html.append(user.getAddress());
                    if (user.getCity() != null) {
                        html.append("<br>");
                        if (user.getZipcode() != null) {
                            html.append(user.getZipcode());
                            html.append(" ");
                        }
                        html.append(user.getCity());
                    }
                    if (user.getCountry() != null) {
                        html.append("<br>");
                        html.append(user.getCountry());
                    }
                } else if (detailId.equals(LIST_DETAIL_GROUPS)) {
                    List groups = this.getCms().getGroupsOfUser(userName, true, true);
                    Iterator itGroups = groups.iterator();
                    while (itGroups.hasNext()) {
                        CmsGroup group = (CmsGroup)itGroups.next();
                        if (group.getOuFqn().equals(this.getParamOufqn())) {
                            html.append(group.getSimpleName());
                        } else {
                            html.append(group.getDisplayName(this.getCms(), this.getLocale()));
                        }
                        if (itGroups.hasNext()) {
                            html.append("<br>");
                        }
                        html.append("\n");
                    }
                } else {
                    CmsRole role;
                    if (!detailId.equals(LIST_DETAIL_ROLES)) continue;
                    boolean otherOuRole = false;
                    List roles = OpenCms.getRoleManager().getRolesOfUser(this.getCms(), userName, "/", true, true, false);
                    Iterator itRoles = roles.iterator();
                    while (itRoles.hasNext()) {
                        role = (CmsRole)itRoles.next();
                        if (role.getOuFqn().equals(this.getParamOufqn())) continue;
                        otherOuRole = true;
                        break;
                    }
                    itRoles = roles.iterator();
                    while (itRoles.hasNext()) {
                        role = (CmsRole)itRoles.next();
                        if (!otherOuRole) {
                            html.append(role.getName(this.getLocale()));
                        } else {
                            html.append(role.getDisplayName(this.getCms(), this.getLocale()));
                        }
                        if (itRoles.hasNext()) {
                            html.append("<br>");
                        }
                        html.append("\n");
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            item.set(detailId, (Object)html.toString());
        }
    }

    protected abstract String getGroupIcon();

    protected List getListItems() throws CmsException {
        ArrayList<CmsListItem> ret = new ArrayList<CmsListItem>();
        List users = this.getUsers();
        Iterator itUsers = users.iterator();
        while (itUsers.hasNext()) {
            CmsUser user = (CmsUser)itUsers.next();
            CmsListItem item = this.getList().newItem(user.getId().toString());
            this.setUserData(user, item);
            ret.add(item);
        }
        CmsListColumnDefinition colDef = this.getList().getMetadata().getColumnDefinition(LIST_COLUMN_ROLE);
        if (colDef != null) {
            colDef.setVisible(!OpenCms.getOrgUnitManager().readOrganizationalUnit(this.getCms(), this.getParamOufqn()).hasFlagWebuser());
        }
        return ret;
    }

    protected String getRoleIcon() {
        return "tools/accounts/buttons/role.png";
    }

    protected abstract List getUsers() throws CmsException;

    protected void initMessages() {
        this.addMessages(Messages.get().getBundleName());
        super.initMessages();
    }

    protected abstract CmsUser readUser(String var1) throws CmsException;

    protected void setColumns(CmsListMetadata metadata) {
        CmsListColumnDefinition editCol = new CmsListColumnDefinition(LIST_COLUMN_EDIT);
        editCol.setName(Messages.get().container("GUI_USERS_LIST_COLS_EDIT_0"));
        editCol.setHelpText(Messages.get().container("GUI_USERS_LIST_COLS_EDIT_HELP_0"));
        editCol.setWidth("20");
        editCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        editCol.setSorteable(false);
        this.setEditAction(editCol);
        m_editActionIds.addAll(editCol.getDirectActionIds());
        metadata.addColumn(editCol);
        CmsListColumnDefinition groupCol = new CmsListColumnDefinition(LIST_COLUMN_GROUPS);
        groupCol.setName(Messages.get().container("GUI_USERS_LIST_COLS_GROUPS_0"));
        groupCol.setHelpText(Messages.get().container("GUI_USERS_LIST_COLS_GROUPS_HELP_0"));
        groupCol.setWidth("20");
        groupCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        groupCol.setSorteable(false);
        CmsListDirectAction groupAction = new CmsListDirectAction(LIST_ACTION_GROUPS);
        groupAction.setName(Messages.get().container("GUI_USERS_LIST_ACTION_GROUPS_NAME_0"));
        groupAction.setHelpText(Messages.get().container("GUI_USERS_LIST_ACTION_GROUPS_HELP_0"));
        groupAction.setIconPath(this.getGroupIcon());
        groupCol.addDirectAction((I_CmsListDirectAction)groupAction);
        metadata.addColumn(groupCol);
        CmsListColumnDefinition roleCol = new CmsListColumnDefinition(LIST_COLUMN_ROLE);
        roleCol.setName(Messages.get().container("GUI_USERS_LIST_COLS_ROLE_0"));
        roleCol.setHelpText(Messages.get().container("GUI_USERS_LIST_COLS_ROLE_HELP_0"));
        roleCol.setWidth("20");
        roleCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        roleCol.setSorteable(false);
        CmsListDirectAction roleAction = new CmsListDirectAction("ar");
        roleAction.setName(Messages.get().container("GUI_USERS_LIST_ACTION_ROLE_NAME_0"));
        roleAction.setHelpText(Messages.get().container("GUI_USERS_LIST_ACTION_ROLE_HELP_0"));
        roleAction.setIconPath(this.getRoleIcon());
        roleCol.addDirectAction((I_CmsListDirectAction)roleAction);
        metadata.addColumn(roleCol);
        CmsListColumnDefinition actCol = new CmsListColumnDefinition(LIST_COLUMN_ACTIVATE);
        actCol.setName(Messages.get().container("GUI_USERS_LIST_COLS_ACTIVATE_0"));
        actCol.setHelpText(Messages.get().container("GUI_USERS_LIST_COLS_ACTIVATE_HELP_0"));
        actCol.setWidth("20");
        actCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        actCol.setListItemComparator((I_CmsListItemComparator)new CmsListItemActionIconComparator());
        CmsListDirectAction actAction = new CmsListDirectAction(LIST_ACTION_ACTIVATE){

            public boolean isVisible() {
                if (this.getItem() == null) {
                    return super.isVisible();
                }
                Boolean enabled = (Boolean)this.getItem().get(A_CmsUsersList.LIST_COLUMN_ENABLED);
                if (enabled == null) {
                    return super.isVisible();
                }
                return enabled == false;
            }
        };
        actAction.setName(Messages.get().container("GUI_USERS_LIST_ACTION_ACTIVATE_NAME_0"));
        actAction.setHelpText(Messages.get().container("GUI_USERS_LIST_ACTION_ACTIVATE_HELP_0"));
        actAction.setConfirmationMessage(Messages.get().container("GUI_USERS_LIST_ACTION_ACTIVATE_CONF_0"));
        actAction.setIconPath("list/inactive.png");
        actCol.addDirectAction((I_CmsListDirectAction)actAction);
        CmsListDirectAction deactAction = new CmsListDirectAction(LIST_ACTION_DEACTIVATE){

            public boolean isVisible() {
                if (this.getItem() == null) {
                    return super.isVisible();
                }
                Boolean enabled = (Boolean)this.getItem().get(A_CmsUsersList.LIST_COLUMN_ENABLED);
                if (enabled == null) {
                    return super.isVisible();
                }
                return enabled;
            }
        };
        deactAction.setName(Messages.get().container("GUI_USERS_LIST_ACTION_DEACTIVATE_NAME_0"));
        deactAction.setHelpText(Messages.get().container("GUI_USERS_LIST_ACTION_DEACTIVATE_HELP_0"));
        deactAction.setConfirmationMessage(Messages.get().container("GUI_USERS_LIST_ACTION_DEACTIVATE_CONF_0"));
        deactAction.setIconPath("list/active.png");
        actCol.addDirectAction((I_CmsListDirectAction)deactAction);
        metadata.addColumn(actCol);
        CmsListColumnDefinition deleteCol = new CmsListColumnDefinition(LIST_COLUMN_DELETE);
        deleteCol.setName(Messages.get().container("GUI_USERS_LIST_COLS_DELETE_0"));
        deleteCol.setHelpText(Messages.get().container("GUI_USERS_LIST_COLS_DELETE_HELP_0"));
        deleteCol.setWidth("20");
        deleteCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        deleteCol.setSorteable(false);
        this.setDeleteAction(deleteCol);
        m_deleteActionIds.addAll(deleteCol.getDirectActionIds());
        metadata.addColumn(deleteCol);
        CmsListColumnDefinition loginCol = new CmsListColumnDefinition(LIST_COLUMN_LOGIN);
        metadata.addColumn(loginCol);
        loginCol.setVisible(false);
        CmsListColumnDefinition displayCol = new CmsListColumnDefinition(LIST_COLUMN_DISPLAY);
        displayCol.setName(Messages.get().container("GUI_USERS_LIST_COLS_LOGIN_0"));
        displayCol.setWidth("20%");
        CmsListDefaultAction defEditAction = new CmsListDefaultAction(LIST_DEFACTION_EDIT);
        defEditAction.setName(Messages.get().container("GUI_USERS_LIST_DEFACTION_EDIT_NAME_0"));
        defEditAction.setHelpText(Messages.get().container("GUI_USERS_LIST_DEFACTION_EDIT_HELP_0"));
        displayCol.addDefaultAction(defEditAction);
        metadata.addColumn(displayCol);
        CmsListColumnDefinition nameCol = new CmsListColumnDefinition(LIST_COLUMN_NAME);
        nameCol.setName(Messages.get().container("GUI_USERS_LIST_COLS_USERNAME_0"));
        nameCol.setWidth("30%");
        metadata.addColumn(nameCol);
        CmsListColumnDefinition emailCol = new CmsListColumnDefinition(LIST_COLUMN_EMAIL);
        emailCol.setName(Messages.get().container("GUI_USERS_LIST_COLS_EMAIL_0"));
        emailCol.setWidth("30%");
        metadata.addColumn(emailCol);
        CmsListColumnDefinition lastLoginCol = new CmsListColumnDefinition(LIST_COLUMN_LASTLOGIN);
        lastLoginCol.setName(Messages.get().container("GUI_USERS_LIST_COLS_LASTLOGIN_0"));
        lastLoginCol.setWidth("20%");
        lastLoginCol.setFormatter(CmsListDateMacroFormatter.getDefaultDateFormatter());
        metadata.addColumn(lastLoginCol);
        CmsListColumnDefinition flagCol = new CmsListColumnDefinition(LIST_COLUMN_ENABLED);
        flagCol.setName(Messages.get().container("GUI_USERS_LIST_COLS_LASTLOGIN_0"));
        flagCol.setVisible(false);
        metadata.addColumn(flagCol);
    }

    protected abstract void setDeleteAction(CmsListColumnDefinition var1);

    protected abstract void setEditAction(CmsListColumnDefinition var1);

    protected void setIndependentActions(CmsListMetadata metadata) {
        CmsListItemDetails userAddressDetails = new CmsListItemDetails(LIST_DETAIL_ADDRESS);
        userAddressDetails.setAtColumn(LIST_COLUMN_DISPLAY);
        userAddressDetails.setVisible(false);
        userAddressDetails.setShowActionName(Messages.get().container("GUI_USERS_DETAIL_SHOW_ADDRESS_NAME_0"));
        userAddressDetails.setShowActionHelpText(Messages.get().container("GUI_USERS_DETAIL_SHOW_ADDRESS_HELP_0"));
        userAddressDetails.setHideActionName(Messages.get().container("GUI_USERS_DETAIL_HIDE_ADDRESS_NAME_0"));
        userAddressDetails.setHideActionHelpText(Messages.get().container("GUI_USERS_DETAIL_HIDE_ADDRESS_HELP_0"));
        userAddressDetails.setName(Messages.get().container("GUI_USERS_DETAIL_ADDRESS_NAME_0"));
        userAddressDetails.setFormatter((I_CmsListFormatter)new CmsListItemDetailsFormatter(Messages.get().container("GUI_USERS_DETAIL_ADDRESS_NAME_0")));
        metadata.addItemDetails(userAddressDetails);
        CmsListItemDetails userGroupsDetails = new CmsListItemDetails(LIST_DETAIL_GROUPS);
        userGroupsDetails.setAtColumn(LIST_COLUMN_DISPLAY);
        userGroupsDetails.setVisible(false);
        userGroupsDetails.setShowActionName(Messages.get().container("GUI_USERS_DETAIL_SHOW_GROUPS_NAME_0"));
        userGroupsDetails.setShowActionHelpText(Messages.get().container("GUI_USERS_DETAIL_SHOW_GROUPS_HELP_0"));
        userGroupsDetails.setHideActionName(Messages.get().container("GUI_USERS_DETAIL_HIDE_GROUPS_NAME_0"));
        userGroupsDetails.setHideActionHelpText(Messages.get().container("GUI_USERS_DETAIL_HIDE_GROUPS_HELP_0"));
        userGroupsDetails.setName(Messages.get().container("GUI_USERS_DETAIL_GROUPS_NAME_0"));
        userGroupsDetails.setFormatter((I_CmsListFormatter)new CmsListItemDetailsFormatter(Messages.get().container("GUI_USERS_DETAIL_GROUPS_NAME_0")));
        metadata.addItemDetails(userGroupsDetails);
        CmsListItemDetails userRolesDetails = new CmsListItemDetails(LIST_DETAIL_ROLES);
        userRolesDetails.setAtColumn(LIST_COLUMN_DISPLAY);
        userRolesDetails.setVisible(false);
        userRolesDetails.setShowActionName(Messages.get().container("GUI_USERS_DETAIL_SHOW_ROLES_NAME_0"));
        userRolesDetails.setShowActionHelpText(Messages.get().container("GUI_USERS_DETAIL_SHOW_ROLES_HELP_0"));
        userRolesDetails.setHideActionName(Messages.get().container("GUI_USERS_DETAIL_HIDE_ROLES_NAME_0"));
        userRolesDetails.setHideActionHelpText(Messages.get().container("GUI_USERS_DETAIL_HIDE_ROLES_HELP_0"));
        userRolesDetails.setName(Messages.get().container("GUI_USERS_DETAIL_ROLES_NAME_0"));
        userRolesDetails.setFormatter((I_CmsListFormatter)new CmsListItemDetailsFormatter(Messages.get().container("GUI_USERS_DETAIL_ROLES_NAME_0")));
        metadata.addItemDetails(userRolesDetails);
        CmsListSearchAction searchAction = new CmsListSearchAction(metadata.getColumnDefinition(LIST_COLUMN_DISPLAY));
        searchAction.addColumn(metadata.getColumnDefinition(LIST_COLUMN_NAME));
        metadata.setSearchAction(searchAction);
    }

    protected void setMultiActions(CmsListMetadata metadata) {
        CmsListMultiAction deleteMultiAction = new CmsListMultiAction(LIST_MACTION_DELETE);
        deleteMultiAction.setName(Messages.get().container("GUI_USERS_LIST_MACTION_DELETE_NAME_0"));
        deleteMultiAction.setHelpText(Messages.get().container("GUI_USERS_LIST_MACTION_DELETE_HELP_0"));
        deleteMultiAction.setConfirmationMessage(Messages.get().container("GUI_USERS_LIST_MACTION_DELETE_CONF_0"));
        deleteMultiAction.setIconPath("list/multi_delete.png");
        metadata.addMultiAction(deleteMultiAction);
        CmsListMultiAction activateUser = new CmsListMultiAction(LIST_MACTION_ACTIVATE);
        activateUser.setName(Messages.get().container("GUI_USERS_LIST_MACTION_ACTIVATE_NAME_0"));
        activateUser.setHelpText(Messages.get().container("GUI_USERS_LIST_MACTION_ACTIVATE_HELP_0"));
        activateUser.setConfirmationMessage(Messages.get().container("GUI_USERS_LIST_MACTION_ACTIVATE_CONF_0"));
        activateUser.setIconPath("list/multi_activate.png");
        metadata.addMultiAction(activateUser);
        CmsListMultiAction deactivateUser = new CmsListMultiAction(LIST_MACTION_DEACTIVATE);
        deactivateUser.setName(Messages.get().container("GUI_USERS_LIST_MACTION_DEACTIVATE_NAME_0"));
        deactivateUser.setHelpText(Messages.get().container("GUI_USERS_LIST_MACTION_DEACTIVATE_HELP_0"));
        deactivateUser.setConfirmationMessage(Messages.get().container("GUI_USERS_LIST_MACTION_DEACTIVATE_CONF_0"));
        deactivateUser.setIconPath("list/multi_deactivate.png");
        metadata.addMultiAction(deactivateUser);
    }

    protected void setUserData(CmsUser user, CmsListItem item) {
        item.set(LIST_COLUMN_LOGIN, (Object)user.getName());
        item.set(LIST_COLUMN_DISPLAY, (Object)user.getSimpleName());
        item.set(LIST_COLUMN_NAME, (Object)user.getFullName());
        item.set(LIST_COLUMN_EMAIL, (Object)user.getEmail());
        item.set(LIST_COLUMN_LASTLOGIN, (Object)new Date(user.getLastlogin()));
        item.set(LIST_COLUMN_ENABLED, (Object)new Boolean(user.isEnabled()));
    }

    protected void validateParamaters() throws Exception {
        OpenCms.getRoleManager().checkRole(this.getCms(), CmsRole.ACCOUNT_MANAGER.forOrgUnit(this.getParamOufqn()));
        OpenCms.getOrgUnitManager().readOrganizationalUnit(this.getCms(), this.getParamOufqn()).getName();
    }
}

