/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.accounts;

import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsUser;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.module.CmsModule;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.security.CmsRole;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.CmsWorkplaceUserInfoManager;
import org.opencms.workplace.tools.CmsDefaultToolHandler;

public class CmsAccountsToolHandler
extends CmsDefaultToolHandler {
    protected static final String VISIBILITY_ALL = "all";
    private static final String ACCMAN_FILE = "account_managers.jsp";
    private static final String ALLINFO_FILE = "user_allinfo.jsp";
    private static final String ASSIGN_FILE = "user_assign.jsp";
    private static final String DELETE_FILE = "unit_delete.jsp";
    private static final String OU_EDIT_FILE = "unit_edit.jsp";
    private static final String GROUP_USERS_FILE = "group_users.jsp";
    private static final String GROUPUSERS_FILE = "group_users.jsp";
    private static final Log LOG = CmsLog.getLog((Object)CmsAccountsToolHandler.class);
    private static final String NEW_FILE = "unit_new.jsp";
    private static final String OUROLES_FILE = "roles_list.jsp";
    private static final String OVERVIEW_FILE = "unit_overview.jsp";
    private static final String PARAM_VISIBILITY_FLAG = "visibility";
    private static final String PARENT_FILE = "unit_parent.jsp";
    private static final String ROLEUSERS_EDIT_FILE = "role_users.jsp";
    private static final String SWITCHUSER_FILE = "user_switch.jsp";
    private static final String USERROLE_FILE = "user_role.jsp";
    private static final String VISIBILITY_NONE = "none";
    private boolean m_webuserOu = false;

    public String getDisabledHelpText() {
        if (super.getDisabledHelpText().equals("${key.GUI_TOOLS_DISABLED_HELP_0}")) {
            if (this.getLink().equals(this.getPath("group_users.jsp"))) {
                return "${key.GUI_VIRTUAL_GROUP_DISABLED_EDITION_HELP_0}";
            }
            if (this.getLink().equals(this.getPath(ROLEUSERS_EDIT_FILE))) {
                return "${key.GUI_ROLEUSERS_EDIT_DISABLED_HELP_0}";
            }
            return "${key.GUI_ORGUNIT_ADMIN_TOOL_DISABLED_DELETE_HELP_0}";
        }
        return super.getDisabledHelpText();
    }

    public boolean isEnabled(CmsWorkplace wp) {
        if (this.getLink().equals(this.getPath("group_users.jsp"))) {
            String groupId = CmsRequestUtil.getNotEmptyDecodedParameter((HttpServletRequest)wp.getJsp().getRequest(), (String)"groupid");
            try {
                return !wp.getCms().readGroup(new CmsUUID(groupId)).isVirtual();
            }
            catch (Exception e) {
                return false;
            }
        }
        if (!this.getLink().equals(ASSIGN_FILE)) {
            wp.getJsp().getRequest().getSession().removeAttribute("orgunit_users");
            wp.getJsp().getRequest().getSession().removeAttribute("not_orgunit_users");
        }
        if (this.getLink().equals(DELETE_FILE)) {
            String ouFqn = CmsRequestUtil.getNotEmptyDecodedParameter((HttpServletRequest)wp.getJsp().getRequest(), (String)"oufqn");
            if (ouFqn == null) {
                ouFqn = wp.getCms().getRequestContext().getOuFqn();
            }
            try {
                if (OpenCms.getOrgUnitManager().getUsers(wp.getCms(), ouFqn, true).size() > 0) {
                    return false;
                }
                if (OpenCms.getOrgUnitManager().getGroups(wp.getCms(), ouFqn, true).size() > 0) {
                    List groups = OpenCms.getOrgUnitManager().getGroups(wp.getCms(), ouFqn, true);
                    Iterator itGroups = groups.iterator();
                    while (itGroups.hasNext()) {
                        CmsGroup group = (CmsGroup)itGroups.next();
                        if (OpenCms.getDefaultUsers().isDefaultGroup(group.getName())) continue;
                        return false;
                    }
                }
                if (OpenCms.getOrgUnitManager().getOrganizationalUnits(wp.getCms(), ouFqn, true).size() > 0) {
                    return false;
                }
            }
            catch (CmsException e) {
                // empty catch block
            }
        }
        if (this.getLink().equals(this.getPath(ROLEUSERS_EDIT_FILE))) {
            String roleName = CmsRequestUtil.getNotEmptyDecodedParameter((HttpServletRequest)wp.getJsp().getRequest(), (String)"role");
            if (!OpenCms.getRoleManager().hasRole(wp.getCms(), CmsRole.valueOfGroupName((String)roleName))) {
                return false;
            }
        } else if (this.getPath().indexOf("/users/edit/") > -1) {
            if (OpenCms.getRoleManager().hasRole(wp.getCms(), CmsRole.ROOT_ADMIN)) {
                return true;
            }
            String paramId = CmsRequestUtil.getNotEmptyDecodedParameter((HttpServletRequest)wp.getJsp().getRequest(), (String)"userid");
            if (paramId == null) {
                return false;
            }
            CmsUUID userId = new CmsUUID(paramId);
            try {
                CmsUser user = wp.getCms().readUser(userId);
                if (OpenCms.getRoleManager().hasRole(wp.getCms(), user.getName(), CmsRole.ROOT_ADMIN)) {
                    return false;
                }
                if (OpenCms.getRoleManager().hasRole(wp.getCms(), CmsRole.ADMINISTRATOR)) {
                    return true;
                }
                return !OpenCms.getRoleManager().hasRole(wp.getCms(), user.getName(), CmsRole.ADMINISTRATOR);
            }
            catch (CmsException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
                return false;
            }
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isVisible(CmsWorkplace wp) {
        String parentOu;
        CmsObject cms;
        block31: {
            if (this.getVisibilityFlag().equals(VISIBILITY_NONE)) {
                return false;
            }
            if (this.getLink().equals(this.getPath(ALLINFO_FILE))) {
                CmsWorkplaceUserInfoManager manager = OpenCms.getWorkplaceManager().getUserInfoManager();
                if (manager == null) return false;
                if (manager.getBlocks() == null) return false;
                if (manager.getBlocks().isEmpty()) {
                    return false;
                }
            }
            cms = wp.getCms();
            if (!OpenCms.getRoleManager().hasRole(cms, CmsRole.ACCOUNT_MANAGER)) {
                return false;
            }
            String ouFqn = CmsRequestUtil.getNotEmptyDecodedParameter((HttpServletRequest)wp.getJsp().getRequest(), (String)"oufqn");
            if (ouFqn == null) {
                ouFqn = cms.getRequestContext().getOuFqn();
            }
            parentOu = CmsOrganizationalUnit.getParentFqn((String)ouFqn);
            try {
                this.m_webuserOu = OpenCms.getOrgUnitManager().readOrganizationalUnit(wp.getCms(), ouFqn).hasFlagWebuser();
            }
            catch (CmsException e) {
                if (!LOG.isErrorEnabled()) break block31;
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        if (this.getLink().equals(this.getPath(OVERVIEW_FILE))) {
            if (parentOu == null) return true;
            if (OpenCms.getRoleManager().hasRole(cms, CmsRole.ADMINISTRATOR.forOrgUnit(parentOu))) return false;
            return true;
        }
        if (this.getLink().equals(this.getPath(OU_EDIT_FILE))) {
            if (parentOu == null) return false;
            if (!OpenCms.getRoleManager().hasRole(cms, CmsRole.ADMINISTRATOR)) return false;
            if (!OpenCms.getRoleManager().hasRole(cms, CmsRole.ADMINISTRATOR.forOrgUnit(parentOu))) return false;
            return true;
        }
        if (this.getLink().equals(this.getPath(NEW_FILE))) {
            if (!this.m_webuserOu) return OpenCms.getRoleManager().hasRole(cms, CmsRole.ADMINISTRATOR);
            return false;
        }
        if (this.getLink().equals(this.getPath(PARENT_FILE))) {
            if (parentOu == null) return false;
            return OpenCms.getRoleManager().hasRole(cms, CmsRole.ACCOUNT_MANAGER.forOrgUnit(parentOu));
        }
        if (this.getLink().equals(this.getPath(DELETE_FILE))) {
            if (parentOu == null) return false;
            if (!OpenCms.getRoleManager().hasRole(cms, CmsRole.ADMINISTRATOR)) return false;
            if (!OpenCms.getRoleManager().hasRole(cms, CmsRole.ADMINISTRATOR.forOrgUnit(parentOu))) return false;
            return true;
        }
        if (this.getLink().equals(this.getPath(ASSIGN_FILE))) {
            try {
                List orgUnits = OpenCms.getRoleManager().getOrgUnitsForRole(cms, CmsRole.ACCOUNT_MANAGER.forOrgUnit(""), true);
                if (orgUnits.size() == 1) {
                    return false;
                }
                if (this.m_webuserOu) return false;
                return true;
            }
            catch (CmsException e) {
                if (!LOG.isErrorEnabled()) return true;
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                return true;
            }
        }
        if (this.getLink().equals(this.getPath(OUROLES_FILE))) {
            if (this.m_webuserOu) return false;
            return true;
        }
        if (this.getLink().equals(this.getPath(SWITCHUSER_FILE))) {
            boolean visible = OpenCms.getRoleManager().hasRole(wp.getCms(), CmsRole.ROOT_ADMIN);
            CmsUUID userId = new CmsUUID(CmsRequestUtil.getNotEmptyDecodedParameter((HttpServletRequest)wp.getJsp().getRequest(), (String)"userid"));
            try {
                visible &= OpenCms.getRoleManager().hasRole(wp.getCms(), wp.getCms().readUser(userId).getName(), CmsRole.WORKPLACE_USER);
                return visible;
            }
            catch (CmsException e) {
                if (!LOG.isErrorEnabled()) return visible;
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            return visible;
        }
        if (this.getPath().indexOf("/users/edit/") > -1) {
            if (OpenCms.getRoleManager().hasRole(wp.getCms(), CmsRole.ROOT_ADMIN)) {
                return true;
            }
            CmsUUID userId = new CmsUUID(CmsRequestUtil.getNotEmptyDecodedParameter((HttpServletRequest)wp.getJsp().getRequest(), (String)"userid"));
            try {
                CmsUser user = wp.getCms().readUser(userId);
                if (OpenCms.getRoleManager().hasRole(wp.getCms(), user.getName(), CmsRole.ROOT_ADMIN)) {
                    return false;
                }
                if (OpenCms.getRoleManager().hasRole(wp.getCms(), CmsRole.ADMINISTRATOR)) {
                    return true;
                }
                if (OpenCms.getRoleManager().hasRole(wp.getCms(), user.getName(), CmsRole.ADMINISTRATOR)) return false;
                return true;
            }
            catch (CmsException e) {
                if (!LOG.isErrorEnabled()) return false;
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                return false;
            }
        }
        if (this.getLink().equals(this.getPath(USERROLE_FILE)) || this.getLink().equals(this.getPath("group_users.jsp"))) {
            String userId = CmsRequestUtil.getNotEmptyDecodedParameter((HttpServletRequest)wp.getJsp().getRequest(), (String)"userid");
            if (userId == null) {
                return false;
            }
            try {
                if (wp.getCms().readUser(new CmsUUID(userId)).isWebuser()) return false;
                return true;
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) return true;
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                return true;
            }
        } else {
            if (!this.getLink().equals(this.getPath(ACCMAN_FILE))) return true;
            return this.m_webuserOu;
        }
    }

    protected String getPath(String jspName) {
        return "/system/workplace/admin/accounts/" + jspName;
    }

    protected String getVisibilityFlag() {
        CmsModule module = OpenCms.getModuleManager().getModule(((Object)((Object)this)).getClass().getPackage().getName());
        if (module == null) {
            return VISIBILITY_ALL;
        }
        return module.getParameter(PARAM_VISIBILITY_FLAG, VISIBILITY_ALL);
    }
}

