/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.accounts;

import java.util.List;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsObject;
import org.opencms.workplace.list.A_CmsListDialog;
import org.opencms.workplace.list.CmsListDefaultAction;
import org.opencms.workplace.tools.accounts.A_CmsUserGroupsList;

public class CmsGroupStateAction
extends CmsListDefaultAction {
    private CmsObject m_cms;
    private final boolean m_direct;
    private String m_userName;

    public CmsGroupStateAction(String id, boolean direct) {
        super(id);
        this.m_direct = direct;
    }

    public CmsGroupStateAction(String id, CmsObject cms, boolean direct) {
        super(id);
        this.m_cms = cms;
        this.m_direct = direct;
    }

    public CmsObject getCms() {
        return this.m_cms;
    }

    public String getUserName() {
        if (this.m_userName == null) {
            this.m_userName = ((A_CmsUserGroupsList)this.getWp()).getParamUsername();
        }
        return this.m_userName;
    }

    public boolean isDirect() {
        return this.m_direct;
    }

    public boolean isVisible() {
        try {
            String groupName = (String)this.getItem().get("cn");
            List dGroups = this.getCms().getGroupsOfUser(this.getUserName(), true);
            CmsGroup group = this.getCms().readGroup(groupName);
            if (this.isDirect()) {
                return dGroups.contains(group);
            }
            return !dGroups.contains(group);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setUserName(String userName) {
        this.m_userName = userName;
    }

    public void setWp(A_CmsListDialog wp) {
        super.setWp(wp);
        this.m_cms = wp.getCms();
        this.m_userName = null;
    }
}

