/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.accounts;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsUser;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPrincipal;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.list.A_CmsListDialog;
import org.opencms.workplace.list.CmsListColumnAlignEnum;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListDefaultAction;
import org.opencms.workplace.list.CmsListDirectAction;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListItemDetails;
import org.opencms.workplace.list.CmsListItemDetailsFormatter;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListOrderEnum;
import org.opencms.workplace.list.I_CmsListDirectAction;
import org.opencms.workplace.list.I_CmsListFormatter;
import org.opencms.workplace.tools.accounts.Messages;

public class CmsGroupTransferList
extends A_CmsListDialog {
    public static final String LIST_ACTION_TRANSFER = "at";
    public static final String LIST_COLUMN_DESCRIPTION = "cc";
    public static final String LIST_COLUMN_NAME = "cn";
    public static final String LIST_COLUMN_PARENT = "cp";
    public static final String LIST_COLUMN_TRANSFER = "ct";
    public static final String LIST_COLUMN_USERS = "cu";
    public static final String LIST_DEFACTION_TRANSFER = "dt";
    public static final String LIST_DETAIL_CHILDREN = "dc";
    public static final String LIST_DETAIL_USERS = "du";
    public static final String LIST_ID = "lgt";
    private String m_groupName;
    private String m_paramGroupid;

    public CmsGroupTransferList(CmsJspActionElement jsp) {
        this(LIST_ID, jsp);
    }

    public CmsGroupTransferList(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    protected CmsGroupTransferList(String listId, CmsJspActionElement jsp) {
        super(jsp, listId, Messages.get().container("GUI_GROUPS_TRANSFER_LIST_NAME_0"), LIST_COLUMN_NAME, CmsListOrderEnum.ORDER_ASCENDING, LIST_COLUMN_NAME);
    }

    public void executeListMultiActions() throws CmsRuntimeException {
        this.throwListUnsupportedActionException();
    }

    public void executeListSingleActions() throws IOException, ServletException, CmsRuntimeException {
        if (this.getParamListAction().equals(LIST_DEFACTION_TRANSFER) || this.getParamListAction().equals(LIST_ACTION_TRANSFER)) {
            try {
                this.getCms().deleteGroup(new CmsUUID(this.getParamGroupid()), new CmsUUID(this.getSelectedItem().getId()));
                CmsRequestUtil.forwardRequest((String)this.getParamCloseLink(), (HttpServletRequest)this.getJsp().getRequest(), (HttpServletResponse)this.getJsp().getResponse());
                this.setForwarded(true);
            }
            catch (CmsException e) {
                throw new CmsRuntimeException(Messages.get().container("ERR_TRANSFER_GROUP_1", this.getSelectedItem().get(LIST_COLUMN_NAME)), (Throwable)e);
            }
        } else {
            this.throwListUnsupportedActionException();
        }
        this.listSave();
    }

    public String getGroupName() {
        return this.m_groupName;
    }

    public String getParamGroupid() {
        return this.m_paramGroupid;
    }

    public void setParamGroupid(String groupId) {
        this.m_paramGroupid = groupId;
    }

    protected String customHtmlStart() {
        StringBuffer result = new StringBuffer(2048);
        result.append(this.dialogBlockStart(Messages.get().container("GUI_GROUPS_TRANSFER_NOTICE_0").key(this.getLocale())));
        result.append("\n");
        if (this.getCurrentToolPath().indexOf("/edit/") < 0) {
            result.append(this.key("GUI_GROUP_DEPENDENCIES_SELECTED_GROUPS_0"));
            result.append(":<br>\n");
            List users = CmsStringUtil.splitAsList((String)this.getGroupName(), (String)"|", (boolean)true);
            result.append("<ul>\n");
            Iterator it = users.iterator();
            while (it.hasNext()) {
                String name = (String)it.next();
                result.append("<li>");
                result.append(name);
                result.append("</li>\n");
            }
            result.append("</ul>\n");
        }
        result.append(this.key("GUI_GROUPS_TRANSFER_NOTICE_TEXT_0"));
        result.append(this.dialogBlockEnd());
        return result.toString();
    }

    protected void fillDetails(String detailId) {
        List groups = this.getList().getAllContent();
        Iterator itGroups = groups.iterator();
        while (itGroups.hasNext()) {
            CmsListItem item = (CmsListItem)itGroups.next();
            String groupName = item.get(LIST_COLUMN_NAME).toString();
            StringBuffer html = new StringBuffer(512);
            try {
                if (detailId.equals(LIST_DETAIL_USERS)) {
                    Iterator itUsers = this.getCms().getUsersOfGroup(groupName).iterator();
                    while (itUsers.hasNext()) {
                        html.append(((CmsUser)itUsers.next()).getFullName());
                        if (itUsers.hasNext()) {
                            html.append("<br>");
                        }
                        html.append("\n");
                    }
                } else {
                    if (!detailId.equals(LIST_DETAIL_CHILDREN)) continue;
                    Iterator itChildren = this.getCms().getChildren(groupName, false).iterator();
                    while (itChildren.hasNext()) {
                        html.append(((CmsGroup)itChildren.next()).getName());
                        if (itChildren.hasNext()) {
                            html.append("<br>");
                        }
                        html.append("\n");
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            item.set(detailId, (Object)html.toString());
        }
    }

    protected List getGroups() throws CmsException {
        return CmsPrincipal.filterCore((List)OpenCms.getOrgUnitManager().getGroups(this.getCms(), "", true));
    }

    protected List getListItems() throws CmsException {
        ArrayList<CmsListItem> ret = new ArrayList<CmsListItem>();
        List groups = this.getGroups();
        HashSet selGroups = new HashSet(CmsStringUtil.splitAsList((String)this.getParamGroupid(), (String)"|", (boolean)true));
        Iterator itGroups = groups.iterator();
        while (itGroups.hasNext()) {
            CmsGroup group = (CmsGroup)itGroups.next();
            if (selGroups.contains(group.getId().toString())) continue;
            CmsListItem item = this.getList().newItem(group.getId().toString());
            item.set(LIST_COLUMN_NAME, (Object)group.getName());
            item.set(LIST_COLUMN_DESCRIPTION, (Object)group.getDescription(this.getLocale()));
            try {
                item.set(LIST_COLUMN_PARENT, (Object)this.getCms().readGroup(group.getParentId()).getName());
            }
            catch (Exception e) {
                // empty catch block
            }
            ret.add(item);
        }
        return ret;
    }

    protected void initMessages() {
        this.addMessages(Messages.get().getBundleName());
        super.initMessages();
    }

    protected void setColumns(CmsListMetadata metadata) {
        CmsListColumnDefinition transferCol = new CmsListColumnDefinition(LIST_COLUMN_TRANSFER);
        transferCol.setName(Messages.get().container("GUI_GROUPS_TRANSFER_LIST_COLS_TRANSFER_0"));
        transferCol.setHelpText(Messages.get().container("GUI_GROUPS_TRANSFER_LIST_COLS_TRANSFER_HELP_0"));
        transferCol.setWidth("20");
        transferCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        transferCol.setSorteable(false);
        this.setTransferAction(transferCol);
        metadata.addColumn(transferCol);
        CmsListColumnDefinition nameCol = new CmsListColumnDefinition(LIST_COLUMN_NAME);
        nameCol.setName(Messages.get().container("GUI_GROUPS_LIST_COLS_NAME_0"));
        nameCol.setWidth("20%");
        CmsListDefaultAction defTransferAction = new CmsListDefaultAction(LIST_DEFACTION_TRANSFER);
        defTransferAction.setName(Messages.get().container("GUI_GROUPS_TRANSFER_LIST_DEFACTION_TRANSFER_NAME_0"));
        defTransferAction.setHelpText(Messages.get().container("GUI_GROUPS_TRANSFER_LIST_DEFACTION_TRANSFER_HELP_0"));
        nameCol.addDefaultAction(defTransferAction);
        metadata.addColumn(nameCol);
        CmsListColumnDefinition descriptionCol = new CmsListColumnDefinition(LIST_COLUMN_DESCRIPTION);
        descriptionCol.setName(Messages.get().container("GUI_GROUPS_LIST_COLS_DESCRIPTION_0"));
        descriptionCol.setWidth("60%");
        metadata.addColumn(descriptionCol);
        CmsListColumnDefinition parentCol = new CmsListColumnDefinition(LIST_COLUMN_PARENT);
        parentCol.setName(Messages.get().container("GUI_GROUPS_LIST_COLS_PARENT_0"));
        parentCol.setWidth("20%");
        metadata.addColumn(parentCol);
    }

    protected void setIndependentActions(CmsListMetadata metadata) {
        CmsListItemDetails usersDetails = new CmsListItemDetails(LIST_DETAIL_USERS);
        usersDetails.setAtColumn(LIST_COLUMN_NAME);
        usersDetails.setVisible(false);
        usersDetails.setShowActionName(Messages.get().container("GUI_GROUPS_DETAIL_SHOW_USERS_NAME_0"));
        usersDetails.setShowActionHelpText(Messages.get().container("GUI_GROUPS_DETAIL_SHOW_USERS_HELP_0"));
        usersDetails.setHideActionName(Messages.get().container("GUI_GROUPS_DETAIL_HIDE_USERS_NAME_0"));
        usersDetails.setHideActionHelpText(Messages.get().container("GUI_GROUPS_DETAIL_HIDE_USERS_HELP_0"));
        usersDetails.setName(Messages.get().container("GUI_GROUPS_DETAIL_USERS_NAME_0"));
        usersDetails.setFormatter((I_CmsListFormatter)new CmsListItemDetailsFormatter(Messages.get().container("GUI_GROUPS_DETAIL_USERS_NAME_0")));
        metadata.addItemDetails(usersDetails);
        CmsListItemDetails childDetails = new CmsListItemDetails(LIST_DETAIL_CHILDREN);
        childDetails.setAtColumn(LIST_COLUMN_NAME);
        childDetails.setVisible(false);
        childDetails.setShowActionName(Messages.get().container("GUI_GROUPS_DETAIL_SHOW_CHILDREN_NAME_0"));
        childDetails.setShowActionHelpText(Messages.get().container("GUI_GROUPS_DETAIL_SHOW_CHILDREN_HELP_0"));
        childDetails.setHideActionName(Messages.get().container("GUI_GROUPS_DETAIL_HIDE_CHILDREN_NAME_0"));
        childDetails.setHideActionHelpText(Messages.get().container("GUI_GROUPS_DETAIL_HIDE_CHILDREN_HELP_0"));
        childDetails.setName(Messages.get().container("GUI_GROUPS_DETAIL_CHILDREN_NAME_0"));
        childDetails.setFormatter((I_CmsListFormatter)new CmsListItemDetailsFormatter(Messages.get().container("GUI_GROUPS_DETAIL_CHILDREN_NAME_0")));
        metadata.addItemDetails(childDetails);
    }

    protected void setMultiActions(CmsListMetadata metadata) {
    }

    protected void setTransferAction(CmsListColumnDefinition transferCol) {
        CmsListDirectAction transferAction = new CmsListDirectAction(LIST_ACTION_TRANSFER);
        transferAction.setName(Messages.get().container("GUI_GROUPS_TRANSFER_LIST_ACTION_TRANSFER_NAME_0"));
        transferAction.setHelpText(Messages.get().container("GUI_GROUPS_TRANSFER_LIST_ACTION_TRANSFER_HELP_0"));
        transferAction.setIconPath("tools/accounts/buttons/group.png");
        transferCol.addDirectAction((I_CmsListDirectAction)transferAction);
    }

    protected void validateParamaters() throws Exception {
        this.m_groupName = "";
        Iterator itGroups = CmsStringUtil.splitAsList((String)this.getParamGroupid(), (String)"|", (boolean)true).iterator();
        while (itGroups.hasNext()) {
            CmsUUID id = new CmsUUID(itGroups.next().toString());
            this.m_groupName = this.m_groupName + this.getCms().readGroup(id).getName();
            if (!itGroups.hasNext()) continue;
            this.m_groupName = this.m_groupName + "|";
        }
    }
}

